/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.SubProcessWrapper;
import autoweka.Trajectory;
import autoweka.TrajectoryGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class TrajectoryPointExtraRunner {
    public static void main(String[] args) {
        String targetSeed = null;
        boolean onlyBestPoint = false;
        boolean splitTrajFile = false;
        String trajGroupName = null;
        boolean reverse = false;
        String instanceOverride = null;
        boolean saveModel = false;
        boolean doPredictions = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-seed")) {
                targetSeed = args[++i];
                continue;
            }
            if (args[i].equals("-onlyBest")) {
                onlyBestPoint = true;
                continue;
            }
            if (args[i].equals("-reverse")) {
                reverse = true;
                continue;
            }
            if (args[i].equals("-splitTrajFile")) {
                splitTrajFile = true;
                continue;
            }
            if (args[i].equals("-instanceOverride")) {
                instanceOverride = args[++i];
                continue;
            }
            if (args[i].equals("-saveModel")) {
                saveModel = true;
                continue;
            }
            if (args[i].equals("-doPredictions")) {
                doPredictions = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new RuntimeException("Unknown arg: " + args[i]);
            }
            if (trajGroupName != null) {
                throw new RuntimeException("Only one trajectory group can be specified at a time");
            }
            trajGroupName = args[i];
        }
        TrajectoryGroup trajGroup = TrajectoryGroup.fromXML(trajGroupName);
        Experiment experiment = trajGroup.getExperiment();
        double timeout = experiment.tunerTimeout;
        File experimentDir = new File(trajGroupName).getParentFile();
        HashMap<String, SubProcessWrapper.ErrorAndTime> mResultCache = new HashMap<String, SubProcessWrapper.ErrorAndTime>();
        if (instanceOverride != null) {
            experiment.datasetString = instanceOverride;
            trajGroupName = trajGroupName + "." + new File(instanceOverride).getName() + ".traj";
        }
        if (targetSeed != null) {
            Trajectory singleTraj = trajGroup.getTrajectory(targetSeed);
            trajGroup = new TrajectoryGroup(experiment);
            trajGroup.addTrajectory(singleTraj);
            if (splitTrajFile) {
                trajGroupName = trajGroupName + "." + targetSeed;
            }
        }
        Properties runnerProps = new Properties();
        if (saveModel) {
            if (!onlyBestPoint) {
                throw new RuntimeException("Can't save the model unless looking at only the best");
            }
            runnerProps.put("modelOutputFilePrefix", trajGroupName);
        }
        for (Trajectory traj : trajGroup.getTrajectories()) {
            List<Object> points;
            if (onlyBestPoint) {
                points = new ArrayList<Trajectory.Point>();
                points.add(traj.getPointAtTime(timeout));
            } else if (reverse) {
                points = new ArrayList<Trajectory.Point>(traj.getPoints());
                Collections.reverse(points);
            } else {
                points = traj.getPoints();
            }
            if (doPredictions) {
                if (!onlyBestPoint) {
                    throw new RuntimeException("Can't do predictions unless looking at only the best");
                }
                runnerProps.put("predictionsFileName", trajGroupName + ".predictions." + traj.getSeed() + ".csv");
            }
            for (Trajectory.Point point : points) {
                point.specificInstanceInfo.clear();
                for (Experiment.TrajectoryPointExtra extra : experiment.trajectoryPointExtras) {
                    String cacheLookup = extra.instance + "__" + point.getArgs();
                    SubProcessWrapper.ErrorAndTime errTime = new SubProcessWrapper.ErrorAndTime(0.0f, 0.0f);
                    errTime = mResultCache.get(cacheLookup) != null ? (SubProcessWrapper.ErrorAndTime)mResultCache.get(cacheLookup) : SubProcessWrapper.getErrorAndTime(experimentDir, experiment, extra.instance, point.getArgs(), traj.getSeed(), runnerProps);
                    mResultCache.put(cacheLookup, errTime);
                    point.specificInstanceInfo.add(new Trajectory.Point.SpecificInstanceInfo(extra.name, extra.instance, errTime.error, errTime.time));
                }
                trajGroup.toXML(trajGroupName);
            }
        }
    }
}

