/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.SubProcessWrapper;
import autoweka.Trajectory;
import autoweka.TrajectoryGroup;
import java.io.File;
import java.net.URLDecoder;
import java.util.Properties;

public class TrajectoryPointPredictionRunner {
    public static void main(String[] args) {
        String targetSeed = null;
        String trajGroupName = null;
        String instance = "default";
        String dataset = null;
        boolean saveModel = false;
        boolean skipEvaluation = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-seed")) {
                targetSeed = args[++i];
                continue;
            }
            if (args[i].equals("-instance")) {
                instance = args[++i];
                continue;
            }
            if (args[i].equals("-dataset")) {
                dataset = args[++i];
                continue;
            }
            if (args[i].equals("-savemodel")) {
                saveModel = true;
                continue;
            }
            if (args[i].equals("-skipevaluation")) {
                skipEvaluation = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                throw new RuntimeException("Unknown arg: " + args[i]);
            }
            if (trajGroupName != null) {
                throw new RuntimeException("Only one trajectory group can be specified at a time");
            }
            trajGroupName = args[i];
        }
        TrajectoryGroup trajGroup = TrajectoryGroup.fromXML(trajGroupName);
        Experiment experiment = trajGroup.getExperiment();
        double timeout = experiment.tunerTimeout;
        File experimentDir = new File(trajGroupName).getParentFile();
        if (dataset != null) {
            experiment.datasetString = dataset;
        }
        if (targetSeed != null) {
            Trajectory singleTraj = trajGroup.getTrajectory(targetSeed);
            trajGroup = new TrajectoryGroup(experiment);
            trajGroup.addTrajectory(singleTraj);
        }
        for (Trajectory traj : trajGroup.getTrajectories()) {
            Trajectory.Point point = traj.getPointAtTime(timeout);
            Properties props = new Properties();
            props.put("predictionsFileName", URLDecoder.decode(experimentDir.getAbsolutePath()) + "/predictions." + traj.getSeed() + ".csv");
            if (saveModel) {
                props.put("modelOutputFilePrefix", URLDecoder.decode(experimentDir.getAbsolutePath()) + "/trained." + traj.getSeed());
            }
            SubProcessWrapper.getErrorAndTime(experimentDir, experiment, instance, point.getArgs(), traj.getSeed(), props);
        }
    }
}

