/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WekaArgumentConverter {
    static final Logger log = LoggerFactory.getLogger(WekaArgumentConverter.class);

    public static Arguments convert(List<String> args) {
        List<ArgumentPair> sortedArgPairs = WekaArgumentConverter.sortArgs(args);
        return WekaArgumentConverter.processArgs(sortedArgPairs);
    }

    /*
     * WARNING - void declaration
     */
    private static Arguments processArgs(List<ArgumentPair> argList) {
        String quotedString = null;
        int quoteDepth = 0;
        HashMap argMap = new HashMap();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        PrefixElement[] prefixElements = new PrefixElement[]{new PrefixElement("assearch_", "attributesearch"), new PrefixElement("aseval_", "attributeeval"), new PrefixElement("", "classifier")};
        String[] propertyNames = new String[]{"targetclass", "attributeeval", "attributesearch", "attributetime"};
        for (PrefixElement prefixElement : prefixElements) {
            if (argMap.get(prefixElement.mapName) != null) continue;
            argMap.put(prefixElement.mapName, new ArrayList());
        }
        for (ArgumentPair arg : argList) {
            void var10_17;
            if (arg.name.equals("REMOVED") || arg.name.contains("HIDDEN") || arg.value.equals("REMOVE_PREV")) continue;
            boolean gobbeled = false;
            for (String property : propertyNames) {
                if (!arg.name.equals("-" + property)) continue;
                propertyMap.put(property, arg.value);
                gobbeled = true;
            }
            if (gobbeled) continue;
            Object var10_15 = null;
            for (PrefixElement ele : prefixElements) {
                if (!arg.name.startsWith(ele.prefix) && !arg.name.startsWith(ele.prefix, 1)) continue;
                List list = (List)argMap.get(ele.mapName);
                break;
            }
            if (var10_17 == null) {
                throw new RuntimeException("Couldn't find a home for the arg '" + arg.name + "'");
            }
            if (arg.name.contains("LOG_")) {
                arg.value = String.format("%f", Math.pow(10.0, Float.parseFloat(arg.value)));
            }
            if (arg.name.contains("INT_")) {
                int val = Math.round(Float.parseFloat(arg.value));
                arg.value = String.format("%d", val);
            }
            String sanitizedName = arg.name;
            if (arg.name.lastIndexOf(95) != -1) {
                sanitizedName = "-" + arg.name.substring(1 + arg.name.lastIndexOf(95));
            }
            if (quotedString == null) {
                if (arg.name.endsWith("QUOTE_START")) {
                    quotedString = "";
                    ++quoteDepth;
                    continue;
                }
                if (arg.name.contains("QUOTE_START")) {
                    var10_17.add(sanitizedName);
                    ++quoteDepth;
                    quotedString = "";
                    if (arg.value.equals("REMOVED")) continue;
                    quotedString = quotedString + arg.value + " ";
                    continue;
                }
                if (arg.name.contains("DASHDASH")) {
                    var10_17.add("--");
                    continue;
                }
                var10_17.add(sanitizedName);
                if (arg.value.equals("REMOVED")) continue;
                var10_17.add(arg.value);
                continue;
            }
            if (arg.name.endsWith("QUOTE_END")) {
                quotedString = quotedString.trim();
                if (quoteDepth > 1) {
                    quotedString = quotedString + "\" ";
                }
                if (--quoteDepth != 0) continue;
                var10_17.add(quotedString);
                quotedString = null;
                continue;
            }
            if (arg.name.endsWith("QUOTE_START")) {
                quotedString = quotedString + "\"";
                ++quoteDepth;
                continue;
            }
            if (arg.name.contains("QUOTE_START")) {
                quotedString = quotedString + sanitizedName + " \"";
                ++quoteDepth;
            } else {
                quotedString = quotedString + sanitizedName + " ";
            }
            if (arg.value.equals("REMOVED")) continue;
            quotedString = quotedString + arg.value + " ";
        }
        for (String s : (List)argMap.get("classifier")) {
            log.trace("arg: {}", (Object)s);
        }
        if (quotedString != null) {
            throw new RuntimeException("Unbalanced QUOTE markers in arguments" + quoteDepth);
        }
        return new Arguments(propertyMap, argMap);
    }

    private static List<ArgumentPair> sortArgs(List<String> args) {
        ArrayList<ArgumentPair> argPairs = new ArrayList<ArgumentPair>();
        for (int i = 0; i < args.size() && i + 1 != args.size(); i += 2) {
            ArgumentPair arg = new ArgumentPair(args.get(i), args.get(i + 1));
            argPairs.add(arg);
        }
        Collections.sort(argPairs);
        return argPairs;
    }

    private static class PrefixElement {
        public String prefix;
        public String mapName;

        public PrefixElement(String _prefix, String _mapName) {
            this.prefix = _prefix;
            this.mapName = _mapName;
        }
    }

    private static class ArgumentPair
    implements Comparable<ArgumentPair> {
        public String name;
        public String value;

        public ArgumentPair(String _name, String _value) {
            this.name = _name;
            this.value = _value;
        }

        @Override
        public int compareTo(ArgumentPair rhs) {
            return this.name.compareTo(rhs.name);
        }

        public String toString() {
            return this.name + ": " + this.value;
        }
    }

    public static class Arguments {
        public Map<String, String> propertyMap;
        public Map<String, List<String>> argMap;

        private Arguments(Map<String, String> _propertyMap, Map<String, List<String>> _argMap) {
            this.propertyMap = _propertyMap;
            this.argMap = _argMap;
        }

        public String toString() {
            return "Property Map:" + this.propertyMap.toString() + " ||| Arg Map:" + this.argMap.toString();
        }
    }
}

