/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ClassifierResult;
import autoweka.ClassifierRunner;
import autoweka.Util;
import com.sun.management.OperatingSystemMXBean;
import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wrapper {
    protected String mExperimentSeed = null;
    protected String mInstance = null;
    protected float mTimeout = 0.0f;
    protected ClassifierRunner mRunner;
    protected Properties mProperties;
    protected String mResultMetric = null;
    final Logger log = LoggerFactory.getLogger(Wrapper.class);

    public void run(String[] argsArray) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argsArray));
        ArrayList<String> wrapperConstructorArgs = new ArrayList<String>();
        ArrayList<String> wrapperArgs = new ArrayList<String>();
        String configFileName = null;
        this.mExperimentSeed = System.getenv().get("AUTOWEKA_EXPERIMENT_SEED");
        boolean inWrapper = false;
        while (!args.isEmpty()) {
            String arg = args.poll();
            if (!inWrapper && arg.equals("-experimentseed")) {
                this.mExperimentSeed = args.poll();
                continue;
            }
            if (!inWrapper && arg.equals("-wrapper")) {
                inWrapper = true;
                this._processWrapperParameterStart(args);
                continue;
            }
            if (inWrapper) {
                if (arg.startsWith("'") && arg.endsWith("'")) {
                    wrapperArgs.add(arg.substring(1, arg.length() - 1));
                    continue;
                }
                wrapperArgs.add(arg);
                continue;
            }
            if (arg.equals("-propsfile")) {
                configFileName = args.poll();
                continue;
            }
            if (arg.equals("-prop")) {
                wrapperConstructorArgs.add(arg);
                wrapperConstructorArgs.add(args.poll());
                continue;
            }
            this._processParameter(arg, args);
        }
        if (this.mExperimentSeed == null) {
            this.log.warn("No experiment seed defined, using default of 0");
            this.mExperimentSeed = "0";
        }
        if (this.mInstance == null) {
            throw new RuntimeException("Subclass did not set the instance string");
        }
        this.mInstance = this.mInstance.replace("{SEED}", this.mExperimentSeed);
        this.mProperties = new Properties();
        if (configFileName != null) {
            try {
                this.mProperties.load(new FileInputStream(configFileName));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load config file: " + e.getMessage(), e);
            }
        }
        Util.parseCommandLineProperties(this.mProperties, wrapperConstructorArgs);
        this.mResultMetric = this.mProperties.getProperty("resultMetric", null);
        if (this.mResultMetric == null) {
            this.log.warn("No evaluation method specified, defaulting to error rate");
            this.mResultMetric = "errorRate";
        }
        this._preRun();
        this.mRunner = new ClassifierRunner(this.mProperties);
        ClassifierResult res = this._doRun(wrapperArgs);
        if (res == null) {
            throw new RuntimeException("Failed compute result!");
        }
        this._postRun();
        this._processResults(res);
    }

    protected ClassifierResult _doRun(List<String> runnerArgs) {
        ClassifierResult res = new ClassifierResult(this.mResultMetric);
        res.setCompleted(false);
        OperatingSystemMXBean OSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long startTime = OSBean.getProcessCpuTime();
        for (String s : runnerArgs) {
            this.log.trace("Adding arg {}", (Object)s);
        }
        try {
            res = this.mRunner.run(this.mInstance, this.mResultMetric, this.mTimeout, this.mExperimentSeed, runnerArgs);
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            long stopTime = OSBean.getProcessCpuTime();
            res.setTrainingTime(1.0f + (float)(stopTime - startTime) * 1.0E-9f);
        }
        return res;
    }

    protected void _processWrapperParameterStart(Queue<String> args) {
    }

    protected void _processParameter(String arg, Queue<String> args) {
    }

    protected void _preRun() {
    }

    protected void _postRun() {
    }

    protected void _processResults(ClassifierResult res) {
    }
}

