/*
 * Decompiled with CFR 0.152.
 */
package autoweka.instancegenerators;

import autoweka.InstanceGenerator;
import autoweka.Util;
import autoweka.instancegenerators.RandomSubSampling;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;
import weka.filters.supervised.instance.Resample;

public class MultiLevel
extends RandomSubSampling {
    final Logger log = LoggerFactory.getLogger(MultiLevel.class);

    public MultiLevel(String instanceFileName) {
        super(instanceFileName);
    }

    public MultiLevel(InstanceGenerator generator) {
        super(generator);
    }

    public MultiLevel(Instances training, Instances testing) {
        super(training, testing);
    }

    @Override
    public Instances _getTrainingFromParams(String params) {
        InstanceGenerator.NestedArgs args = new InstanceGenerator.NestedArgs(params);
        InstanceGenerator child = InstanceGenerator.create(args.child, this.getInstancesFromParamsForSubClass(args.current, false), this.getInstancesFromParamsForSubClass(args.current, true));
        return child.getTrainingFromParams(args.instance);
    }

    @Override
    public Instances _getTestingFromParams(String params) {
        InstanceGenerator.NestedArgs args = new InstanceGenerator.NestedArgs(params);
        InstanceGenerator child = InstanceGenerator.create(args.child, this.getInstancesFromParamsForSubClass(args.current, false), this.getInstancesFromParamsForSubClass(args.current, true));
        this.log.debug("{} {} {}", this.getTraining().numInstances(), child.getTrainingFromParams(args.instance).numInstances(), child.getTestingFromParams(args.instance).numInstances());
        return child.getTestingFromParams(args.instance);
    }

    private Instances getInstancesFromParamsForSubClass(String params, boolean invert) {
        Resample filter = this.newFilter();
        filter.setInvertSelection(false);
        int level = this.setFilterParams(filter, params);
        Instances instances = this.getTraining();
        for (int i = 0; i <= level - 1; ++i) {
            instances = this.getInstances(instances, filter);
        }
        filter.setInvertSelection(invert);
        return this.getInstances(instances, filter);
    }

    private int setFilterParams(Resample filter, String paramStr) {
        Properties params = Util.parsePropertyString(paramStr);
        filter.setNoReplacement(true);
        if (!"{SEED}".equals(params.getProperty("levelSeed"))) {
            filter.setRandomSeed(Integer.parseInt(params.getProperty("levelSeed", "0")));
        }
        filter.setSampleSizePercent(Double.parseDouble(params.getProperty("levelPercent", "70")));
        filter.setBiasToUniformClass(Double.parseDouble(params.getProperty("levelBias", "0")));
        int level = Integer.parseInt(params.getProperty("level", "-1"));
        if (level < 0) {
            throw new RuntimeException("Invalid level '" + level + "'");
        }
        return level;
    }

    @Override
    public List<String> getAllInstanceStrings(String params) {
        InstanceGenerator.NestedArgs args = new InstanceGenerator.NestedArgs(params);
        Properties levelParams = Util.parsePropertyString(args.current);
        int numLevels = Integer.parseInt(levelParams.getProperty("numLevels", "-1"));
        if (numLevels <= 0) {
            throw new RuntimeException("Invalid number of levels");
        }
        levelParams.remove("numLevels");
        ArrayList<String> instances = new ArrayList<String>();
        for (int level = numLevels - 1; level >= 0; --level) {
            levelParams.setProperty("level", Integer.toString(level));
            args.current = Util.propertiesToString(levelParams);
            InstanceGenerator child = InstanceGenerator.create(args.child, this.getInstancesFromParamsForSubClass(args.current, false), this.getInstancesFromParamsForSubClass(args.current, true));
            Iterator<String> iterator = child.getAllInstanceStrings(args.instance).iterator();
            while (iterator.hasNext()) {
                String res;
                args.instance = res = iterator.next();
                instances.add(args.toString());
            }
        }
        return instances;
    }

    @Override
    public Map<String, Map<String, String>> getAllInstanceFeatures(String params) {
        HashMap<String, Map<String, String>> feats = new HashMap<String, Map<String, String>>();
        InstanceGenerator.NestedArgs args = new InstanceGenerator.NestedArgs(params);
        Properties levelParams = Util.parsePropertyString(args.current);
        int numLevels = Integer.parseInt(levelParams.getProperty("numLevels", "-1"));
        if (numLevels <= 0) {
            throw new RuntimeException("Invalid number of levels");
        }
        levelParams.remove("numLevels");
        for (int level = numLevels - 1; level >= 0; --level) {
            levelParams.setProperty("level", Integer.toString(level));
            args.current = Util.propertiesToString(levelParams);
            InstanceGenerator child = InstanceGenerator.create(args.child, this.getInstancesFromParamsForSubClass(args.current, false), this.getInstancesFromParamsForSubClass(args.current, true));
            Map<String, Map<String, String>> childFeatures = child.getAllInstanceFeatures(args.instance);
            Iterator<String> iterator = childFeatures.keySet().iterator();
            while (iterator.hasNext()) {
                String instance;
                args.instance = instance = iterator.next();
                String instName = args.toString();
                feats.put(instName, childFeatures.get(instance));
                ((Map)feats.get(instName)).put("level", Integer.toString(level));
            }
        }
        return feats;
    }
}

