/*
 * Decompiled with CFR 0.152.
 */
package autoweka.smac;

import autoweka.ClassifierResult;
import autoweka.Conditional;
import autoweka.ExperimentConstructor;
import autoweka.Parameter;
import autoweka.ParameterConditionalGroup;
import autoweka.Util;
import java.io.File;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SMACExperimentConstructor
extends ExperimentConstructor {
    @Override
    public void prepareExperiment(String path) {
        path = URLDecoder.decode(path);
        try {
            this.printParamFile(new PrintStream(new File(path + "autoweka.params")));
            this.printInstanceFile(new PrintStream(new File(path + "autoweka.instances")));
            this.printTestInstanceFile(new PrintStream(new File(path + "autoweka.test.instances")));
            this.printFeatureFile(new PrintStream(new File(path + "autoweka.features")));
            this.printScenarioFile(new PrintStream(new File(path + "autoweka.scenario")));
            Util.makePath(path + "out");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to prepare the experiment", e);
        }
    }

    @Override
    public String getTrajectoryParserClassName() {
        return "autoweka.smac.SMACTrajectoryParser";
    }

    @Override
    public List<String> getCallString(String experimentPath) {
        String smac;
        File f;
        String prefix = new File(URLDecoder.decode(SMACExperimentConstructor.class.getProtectionDomain().getCodeSource().getLocation().getPath())).getParentFile().toString();
        if (this.mProperties.getProperty("smacexecutable") == null) {
            throw new RuntimeException("The 'smacexecutable' property was not defined");
        }
        Properties props = Util.parsePropertyString(this.mExperiment.extraPropsString);
        String execExtension = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            execExtension = ".bat";
        }
        if (!(f = new File(Util.expandPath(smac = prefix + File.separator + this.mProperties.getProperty("smacexecutable") + execExtension))).exists()) {
            throw new RuntimeException("Could not find SMAC executable '" + f.getAbsoluteFile() + "'");
        }
        f.setExecutable(true);
        ArrayList<String> args = new ArrayList<String>();
        args.add(smac);
        args.add("--seed");
        args.add("{SEED}");
        args.add("--validation-seed");
        args.add("{SEED}");
        args.add("--random-sample-seed");
        args.add("{SEED}");
        args.add("--scenarioFile");
        args.add("autoweka.scenario");
        args.add("--logModel");
        args.add("false");
        args.add("--logAllProcessOutput");
        args.add("TRUE");
        args.add("--adaptiveCapping");
        args.add("false");
        args.add("--runGroupName");
        args.add("autoweka");
        args.add("--terminate-on-delete");
        args.add(experimentPath + File.separator + "out" + File.separator + "runstamps" + File.separator + "{SEED}.stamp");
        args.add("--kill-runs-on-file-delete");
        args.add(experimentPath + File.separator + "out" + File.separator + "runstamps" + File.separator + "{SEED}.stamp");
        args.add("--algo-cutoff-time");
        args.add("" + this.mExperiment.trainTimeout);
        args.add("--transform-crashed-quality-value");
        args.add("" + ClassifierResult.getInfinity());
        args.add("--kill-run-exceeding-captime-factor");
        args.add("2.0");
        if (props.containsKey("deterministicInstanceOrdering")) {
            args.add("--deterministicInstanceOrdering");
            args.add(props.getProperty("deterministicInstanceOrdering"));
        }
        if (props.containsKey("initialIncumbent")) {
            args.add("--initialIncumbent");
            args.add(props.getProperty("initialIncumbent"));
        }
        if (props.containsKey("initialIncumbentRuns")) {
            args.add("--initialIncumbentRuns");
            args.add(props.getProperty("initialIncumbentRuns"));
        }
        if (props.containsKey("initialN")) {
            args.add("--initialN");
            args.add(props.getProperty("initialN"));
        }
        if (props.containsKey("initialChallenge")) {
            args.add("--initialChallenge");
            args.add(props.getProperty("initialChallenge"));
        }
        if (props.containsKey("stateSerializer")) {
            args.add("--stateSerializer");
            args.add(props.getProperty("stateSerializer"));
        }
        if (props.containsKey("acq-func")) {
            args.add("--acq-func");
            args.add(props.getProperty("acq-func"));
        } else {
            args.add("--acq-func");
            args.add("EI");
        }
        if (props.containsKey("executionMode")) {
            args.add("--executionMode");
            args.add(props.getProperty("executionMode"));
        }
        return args;
    }

    @Override
    public String getType() {
        return "SMAC";
    }

    public void printInstanceFile(PrintStream out) {
        Properties props = Util.parsePropertyString(this.mExperiment.extraPropsString);
        String instancesOverride = props.getProperty("instancesOverride", null);
        if (instancesOverride != null) {
            out.println(instancesOverride);
        } else {
            List<String> instanceStrings = this.mInstanceGenerator.getAllInstanceStrings(this.mExperiment.instanceGeneratorArgs);
            for (String s : instanceStrings) {
                out.println(s);
            }
        }
    }

    public void printFeatureFile(PrintStream out) {
        HashSet<String> featureNamesSet = new HashSet<String>();
        Map<String, Map<String, String>> features = this.mInstanceGenerator.getAllInstanceFeatures(this.mExperiment.instanceGeneratorArgs);
        for (String inst : features.keySet()) {
            featureNamesSet.addAll(features.get(inst).keySet());
        }
        String[] featureNames = featureNamesSet.toArray(new String[0]);
        out.print("instance");
        for (String feat : featureNames) {
            out.print("," + feat);
        }
        out.println();
        for (String inst : features.keySet()) {
            out.print(inst);
            for (String feat : featureNames) {
                out.print("," + features.get(inst).get(feat));
            }
            out.println();
        }
    }

    public void printTestInstanceFile(PrintStream out) {
        out.println("default");
    }

    public void printScenarioFile(PrintStream out) {
        String extraProps = "";
        if (this.mExperiment.extraPropsString != null && this.mExperiment.extraPropsString.length() > 0) {
            extraProps = " -prop " + this.mExperiment.extraPropsString;
        }
        Properties props = Util.parsePropertyString(this.mExperiment.extraPropsString);
        String wrapper = props.getProperty("wrapper", "autoweka.smac.SMACWrapper");
        out.println("algo = \"" + Util.getJavaExecutable() + "\" -Dautoweka.infinity=" + ClassifierResult.getInfinity() + " -Xmx" + this.mExperiment.memory + " -cp \"" + Util.getAbsoluteClasspath() + "\" " + wrapper + " -prop " + this.getWrapperPropString() + extraProps + " -wrapper");
        out.println("execdir = ./");
        out.println("deterministic = 1");
        out.println("run_obj = quality");
        out.println("overall_obj = mean");
        out.println("cutoff_time = " + (int)this.mExperiment.trainTimeout);
        out.println("target_run_cputime_limit = " + (int)this.mExperiment.trainTimeout);
        out.println("wallclock_limit = " + (int)this.mExperiment.tunerTimeout);
        out.println("outdir = out");
        out.println("paramfile = autoweka.params");
        out.println("instance_file = autoweka.instances");
        out.println("test_instance_file = autoweka.test.instances");
        if (!this.mInstanceGenerator.getAllInstanceFeatures(this.mExperiment.instanceGeneratorArgs).isEmpty() && this.mProperties.get("instancesOverride") != null) {
            out.println("feature_file = autoweka.features");
        }
    }

    public void printParamFile(PrintStream out) {
        ParameterConditionalGroup paramGroup = this.generateAlgorithmParameterConditionalGroupForDAG();
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList<String> conditionals = new ArrayList<String>();
        for (Parameter parameter : paramGroup.getParameters()) {
            parameters.add(parameter.toString());
            for (Conditional cond : paramGroup.getConditionalsForParameter(parameter)) {
                conditionals.add(cond.toString());
            }
        }
        Collections.sort(parameters);
        Collections.sort(conditionals);
        for (String string : parameters) {
            out.println(string);
        }
        out.println("Conditionals:");
        for (String string : conditionals) {
            out.println(string);
        }
    }
}

