/*
 * Decompiled with CFR 0.152.
 */
package autoweka.smac;

import autoweka.ClassParams;
import autoweka.Experiment;
import autoweka.Parameter;
import autoweka.Trajectory;
import autoweka.TrajectoryParser;
import autoweka.Util;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACTrajectoryParser
extends TrajectoryParser {
    final Logger log = LoggerFactory.getLogger(SMACTrajectoryParser.class);
    private Pattern mTrajPattern = Pattern.compile("([\\-\\.\\d]+), ([\\-\\.\\dEef]+), [\\-\\.\\d]+, [\\-\\.\\d]+, [\\-\\.\\d]+, (.*)");
    private Pattern mRunsAndResultFileNamePattern = Pattern.compile("runs_and_results-it(\\d+).csv");

    @Override
    public Trajectory parseTrajectory(Experiment experiment, File folder, String seed) {
        ClassParams params = new ClassParams(URLDecoder.decode(folder.getAbsolutePath()) + File.separator + "autoweka.params");
        Trajectory traj = new Trajectory(seed);
        try {
            File[] files;
            String trajFileName = "";
            for (File f : files = new File(URLDecoder.decode(folder.getAbsolutePath()) + File.separator + "out" + File.separator + "autoweka").listFiles()) {
                String s = f.getName();
                if (!s.startsWith("traj") || !s.endsWith("-" + seed + ".txt")) continue;
                trajFileName = URLDecoder.decode(f.getAbsolutePath());
                break;
            }
            this.log.debug("Trajectory file name: {}", (Object)trajFileName);
            Scanner scanner = new Scanner(new FileInputStream(trajFileName));
            String argString = null;
            double time = 0.0;
            double score = 3.4028234663852886E38;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Matcher matcher = this.mTrajPattern.matcher(line);
                if (matcher.matches()) {
                    time = Float.parseFloat(matcher.group(1));
                    score = Float.parseFloat(matcher.group(2));
                    this.log.debug("Time: {}, score: {}", (Object)time, (Object)score);
                    argString = this.filterArgString(params, matcher.group(3));
                    traj.addPoint(new Trajectory.Point(time, score, argString));
                    continue;
                }
                this.log.debug("Could not match {}", (Object)line);
            }
            String runsAndResultsFileName = null;
            int runsAndResultsIteration = -1;
            for (File f : files = new File(URLDecoder.decode(folder.getAbsolutePath()) + File.separator + "out" + File.separator + "autoweka" + File.separator + "state-run" + seed + File.separator).listFiles()) {
                int itr;
                String s = f.getName();
                Matcher matcher = this.mRunsAndResultFileNamePattern.matcher(s);
                if (!matcher.matches() || (itr = Integer.parseInt(matcher.group(1))) <= runsAndResultsIteration) continue;
                runsAndResultsFileName = URLDecoder.decode(f.getAbsolutePath());
                runsAndResultsIteration = itr;
            }
            if (runsAndResultsFileName != null) {
                int numEvals = 0;
                int numMemOut = 0;
                int numTimeOut = 0;
                this.log.debug("Run results file: {}", (Object)runsAndResultsFileName);
                scanner = new Scanner(new FileInputStream(runsAndResultsFileName));
                scanner.nextLine();
                while (scanner.hasNextLine()) {
                    String[] row = scanner.nextLine().split(",");
                    try {
                        ++numEvals;
                        if ((double)Float.parseFloat(row[7]) >= 1.1 * (double)experiment.trainTimeout) {
                            ++numTimeOut;
                        }
                        if (!row[14].contains("MEMOUT")) continue;
                        ++numMemOut;
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), e);
                    }
                }
                traj.setEvaluationCounts(numEvals, numMemOut, numTimeOut);
            } else {
                this.log.warn("Could not find runs_and_results file");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse trajectory", e);
        }
        return traj;
    }

    private String filterArgString(ClassParams params, String args) {
        String[] splitArgs;
        HashMap<String, Parameter> paramMap = params.getParameterMap();
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (String argPair : splitArgs = args.split(", ")) {
            this.log.trace(argPair);
            String[] splitArg = argPair.split("=", 2);
            String arg = splitArg[0].trim();
            String value = splitArg[1].trim();
            if (paramMap.get(arg) == null) {
                throw new RuntimeException("Unknown argument found in trajectory '" + arg + "'");
            }
            if (value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            argMap.put(arg, value);
        }
        return Util.argMapToString(params.filterParams(argMap));
    }
}

