/*
 * Decompiled with CFR 0.152.
 */
package autoweka.smac;

import autoweka.ClassifierResult;
import autoweka.Wrapper;
import java.util.Queue;

public class SMACWrapper
extends Wrapper {
    private boolean mRawEval = false;

    public static void main(String[] args) {
        SMACWrapper wrapper = new SMACWrapper();
        try {
            wrapper.run(args);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    @Override
    protected void _processWrapperParameterStart(Queue<String> args) {
        this.mInstance = args.poll();
        args.poll();
        this.mTimeout = Float.parseFloat(args.poll());
        args.poll();
        args.poll();
    }

    @Override
    protected void _processParameter(String arg, Queue<String> args) {
        if (arg.equals("-raw")) {
            this.mRawEval = true;
        }
    }

    @Override
    protected void _processResults(ClassifierResult res) {
        double score = res.getScore();
        if (this.mRawEval) {
            score = res.getRawScore();
        }
        String resultStr = "SAT";
        if (!res.getCompleted()) {
            resultStr = "TIMEOUT";
        }
        StringBuilder extraResultsSB = new StringBuilder();
        int i = 0;
        while (this.mProperties.containsKey("extraRun" + i)) {
            ClassifierResult evalRes = this.mRunner.evaluateClassifierOnTesting(res.getClassifier(), this.mProperties.getProperty("extraRun" + i), this.mResultMetric, this.mTimeout);
            extraResultsSB.append("(");
            extraResultsSB.append(evalRes.getEvaluationTime());
            extraResultsSB.append(" ");
            extraResultsSB.append(evalRes.getRawScore());
            extraResultsSB.append(") ");
            ++i;
        }
        if (this.mRawEval) {
            extraResultsSB.append("[");
            extraResultsSB.append(res.getNormalizationPenalty());
            extraResultsSB.append("] ");
        }
        if (res.getMemOut()) {
            extraResultsSB.append("MEMOUT ");
        }
        extraResultsSB.append(res.getPercentEvaluated());
        System.out.println("Result for ParamILS: " + resultStr + ", " + res.getTime() + ", 0, " + score + ", " + this.mExperimentSeed + ", EXTRA " + extraResultsSB.toString());
        System.exit(0);
    }
}

