/*
 * Decompiled with CFR 0.152.
 */
package autoweka.tools;

import autoweka.InstanceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.Instances;

class DatasetStats {
    static final Logger log = LoggerFactory.getLogger(DatasetStats.class);

    DatasetStats() {
    }

    public static void main(String[] args) {
        for (String zip : args) {
            InstanceGenerator generator;
            log.info("Dataset: {}", (Object)zip);
            try {
                generator = InstanceGenerator.create("autoweka.instancegenerators.Default", "type=zipFile:zipFile=" + zip);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                continue;
            }
            Instances training = generator.getTraining();
            Instances testing = generator.getTesting();
            int numString = 0;
            int numDate = 0;
            int numNominal = 0;
            int numNumeric = 0;
            block9: for (int i = 0; i < training.numAttributes(); ++i) {
                if (i == training.classIndex()) continue;
                Attribute at = training.attribute(i);
                switch (at.type()) {
                    case 0: {
                        ++numNumeric;
                        continue block9;
                    }
                    case 1: {
                        ++numNominal;
                        continue block9;
                    }
                    case 3: {
                        ++numDate;
                        continue block9;
                    }
                    case 2: {
                        ++numString;
                        continue block9;
                    }
                    default: {
                        throw new RuntimeException("Invalid attribute type '" + at.type() + "'");
                    }
                }
            }
            log.info(" Num Training: {}", (Object)training.size());
            log.info(" Num Testing:  {}", (Object)testing.size());
            log.info("   Num Numeric:  {}", (Object)numNumeric);
            log.info("   Num Nominal:  {}", (Object)numNominal);
            log.info("   Num Date:     {}", (Object)numDate);
            log.info("   Num String:   {}", (Object)numString);
        }
    }
}

