/*
 * Decompiled with CFR 0.152.
 */
package autoweka.tools;

import autoweka.Experiment;
import autoweka.TrajectoryParser;
import autoweka.TrajectoryPointPredictionRunner;
import java.io.File;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExperimentRunner {
    static final Logger log = LoggerFactory.getLogger(ExperimentRunner.class);

    ExperimentRunner() {
    }

    public static void main(String[] args) {
        String[] oldFiles;
        if (args.length != 2) {
            log.error("ExperimentRunner requires 2 arguments - the experiment folder and the seed");
            System.exit(1);
        }
        File expFolderFile = new File(args[0]);
        String seed = args[1];
        if (!expFolderFile.exists() || !expFolderFile.isDirectory()) {
            log.error("The first argument does not appear to be an experiment folder");
            System.exit(1);
        }
        String expFolder = URLDecoder.decode(expFolderFile.getAbsolutePath());
        String expName = expFolderFile.getName();
        for (String path : oldFiles = new String[]{expName + ".trajectories." + seed, "trained." + seed + ".model", "trained." + seed + ".attributeselection", "predictions." + seed}) {
            File tmpFile = new File(expFolder + File.separator + path);
            if (!tmpFile.exists()) continue;
            tmpFile.delete();
        }
        String[] expArgs = new String[]{"-noexit", expFolder, seed};
        Experiment.main(expArgs);
        String[] trajParseArgs = new String[]{"-single", expFolder, seed};
        TrajectoryParser.main(trajParseArgs);
        String[] runnerArgs = new String[]{expFolder + File.separator + expName + ".trajectories." + seed, "-savemodel"};
        TrajectoryPointPredictionRunner.main(runnerArgs);
    }
}

