/*
 * Decompiled with CFR 0.152.
 */
package xni.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public abstract class AbstractConfiguration
implements XMLParserConfiguration {
    protected final Vector fRecognizedFeatures = new Vector();
    protected final Vector fRecognizedProperties = new Vector();
    protected final Hashtable fFeatures = new Hashtable();
    protected final Hashtable fProperties = new Hashtable();
    protected XMLEntityResolver fEntityResolver;
    protected XMLErrorHandler fErrorHandler;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected Locale fLocale;
    protected final Vector fComponents = new Vector();

    public void addRecognizedFeatures(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!this.fRecognizedFeatures.contains(string)) {
                this.fRecognizedFeatures.addElement(string);
            }
            ++n2;
        }
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string)) {
            short s = 0;
            throw new XMLConfigurationException(s, string);
        }
        this.fFeatures.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        int n = this.fComponents.size();
        int n2 = 0;
        while (n2 < n) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.elementAt(n2);
            xMLComponent.setFeature(string, bl);
            ++n2;
        }
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string)) {
            short s = 0;
            throw new XMLConfigurationException(s, string);
        }
        Boolean bl = (Boolean)this.fFeatures.get(string);
        return bl != null ? bl : false;
    }

    public void addRecognizedProperties(String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!this.fRecognizedProperties.contains(string)) {
                this.fRecognizedProperties.addElement(string);
            }
            ++n2;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string)) {
            short s = 0;
            throw new XMLConfigurationException(s, string);
        }
        if (object != null) {
            this.fProperties.put(string, object);
        } else {
            this.fProperties.remove(string);
        }
        int n = this.fComponents.size();
        int n2 = 0;
        while (n2 < n) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.elementAt(n2);
            xMLComponent.setProperty(string, object);
            ++n2;
        }
    }

    public Object getProperty(String string) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string)) {
            short s = 0;
            throw new XMLConfigurationException(s, string);
        }
        Object v = this.fProperties.get(string);
        return v;
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.fEntityResolver = xMLEntityResolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setErrorHandler(XMLErrorHandler xMLErrorHandler) {
        this.fErrorHandler = xMLErrorHandler;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler xMLDTDContentModelHandler) {
        this.fDTDContentModelHandler = xMLDTDContentModelHandler;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public abstract void parse(XMLInputSource var1) throws IOException, XNIException;

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    protected void addComponent(XMLComponent xMLComponent) {
        if (!this.fComponents.contains(xMLComponent)) {
            this.fComponents.addElement(xMLComponent);
            this.addRecognizedFeatures(xMLComponent.getRecognizedFeatures());
            this.addRecognizedProperties(xMLComponent.getRecognizedProperties());
        }
    }

    protected void resetComponents() throws XMLConfigurationException {
        int n = this.fComponents.size();
        int n2 = 0;
        while (n2 < n) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.elementAt(n2);
            xMLComponent.reset(this);
            ++n2;
        }
    }

    protected void openInputSourceStream(XMLInputSource xMLInputSource) throws IOException {
        if (xMLInputSource.getCharacterStream() != null) {
            return;
        }
        InputStream inputStream = xMLInputSource.getByteStream();
        if (inputStream == null) {
            String string = xMLInputSource.getSystemId();
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string);
            }
            xMLInputSource.setByteStream(inputStream);
        }
    }
}

