/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.evaluator;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionOptions;
import ca.ubc.cs.beta.aeatk.example.evaluator.TAEEvaluatorNoArgumentHandler;
import ca.ubc.cs.beta.aeatk.logging.ConsoleOnlyLoggingOptions;
import ca.ubc.cs.beta.aeatk.logging.LoggingOptions;
import ca.ubc.cs.beta.aeatk.misc.options.OptionLevel;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterFile;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.util.Map;

@UsageTextField(title="TAE Evaluator Options", description="Parameter defining a TAE and the instances to be executed with said TAE.", noarg=TAEEvaluatorNoArgumentHandler.class)
public class TAEEvaluatorOptions
extends AbstractOptions {
    private static final long serialVersionUID = 1L;
    @ParameterFile
    @Parameter(names={"--scenario"}, description="file containing options to run a TAE evaluation.")
    public File ScenarioFile;
    @ParametersDelegate
    public LoggingOptions fLoggingOptions = new ConsoleOnlyLoggingOptions();
    @UsageTextField(defaultValues="<current working directory>", level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--experiment-dir", "--experimentDir", "-e"}, description="root directory for experiments Folder")
    public String fExperimentDir = System.getProperty("user.dir") + File.separator + "";
    @ParametersDelegate
    public ProblemInstanceOptions fProblemInstanceOptions = new ProblemInstanceOptions();
    public final Map<String, AbstractOptions> fAvailableTAEOptions = TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators();
    @ParametersDelegate
    public AlgorithmExecutionOptions fAlgorithmExecutionOptions = new AlgorithmExecutionOptions();
    @Parameter(names={"--name", "--algorithm-name"}, description="TAE name (used for identification only)", required=true)
    public String fTAEName;
    @UsageTextField(defaultValues="DEFAULT")
    @Parameter(names={"--configuration", "--config"}, description="configuration to execute the TAE with.")
    public String fConfig = "DEFAULT";
    @Parameter(names={"--output-filename"}, description="name of a file to write output to (no extension)")
    private String fOutputFilename = null;
    @Parameter(names={"--output-type"}, description="type of output file to write")
    public ReportType fReportType = ReportType.JSON;
    @Parameter(names={"--overwrite-report"}, description="whether to automatically overwrite output report if already present")
    public boolean fOverwriteReport = false;
    @Parameter(names={"--cutoff"}, description="cutoff time for TAE execution.", required=true)
    public double fCutoff;
    @Parameter(names={"--seed"}, description="seed to use in evaluation.", required=true)
    public long fSeed;
    @Parameter(names={"--exit-after-submission"}, description="whether to exit right after submission; useful when submitting many runs to asynchronously")
    public boolean fExitAfterSubmission = false;

    public TargetAlgorithmEvaluator getTAE() {
        return TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator(this.fAlgorithmExecutionOptions.taeOpts, true, false, this.fAvailableTAEOptions, null);
    }

    public ParameterConfiguration getConfiguration() {
        return this.fAlgorithmExecutionOptions.getAlgorithmExecutionConfig().getParameterConfigurationSpace().getParameterConfigurationFromString(this.fConfig, ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX);
    }

    public String getOuputFileName() {
        if (this.fOutputFilename == null) {
            return "TAEEvaluationOutput-" + this.fTAEName;
        }
        return this.fOutputFilename;
    }

    public static enum ReportType {
        JSON,
        CSV;

    }
}

