/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.jsonexecutor;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.example.jsonexecutor.JSONExecutorOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONExecutor {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JSONExecutorOptions mainOptions = new JSONExecutorOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.taeOptions.getAvailableTargetAlgorithmEvaluators();
        try {
            SimpleModule sModule;
            try {
                JCommander jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(JSONExecutor.class);
            }
            List<AlgorithmRunResult> results = null;
            try (TargetAlgorithmEvaluator tae = mainOptions.taeOptions.getTargetAlgorithmEvaluator(taeOptions);){
                log.info("Waiting for an array of AlgorithmRunConfiguration in JSON format to be recieved on STDIN. You can use the algo-test utility --print-json true to get example JSON.");
                JsonFactory jfactory = new JsonFactory();
                ObjectMapper map = new ObjectMapper(jfactory);
                sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
                map.registerModule((Module)sModule);
                JsonParser jParser = jfactory.createParser(System.in);
                ArrayList<Object> runsToDo = new ArrayList<Object>(Arrays.asList((Object[])map.readValue(jParser, AlgorithmRunConfiguration[].class)));
                final AtomicBoolean outputCompleted = new AtomicBoolean(false);
                TargetAlgorithmEvaluatorRunObserver taeRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

                    @Override
                    public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                        int total = runs.size();
                        int completed = 0;
                        int notStarted = 0;
                        int started = 0;
                        for (AlgorithmRunResult algorithmRunResult : runs) {
                            if (algorithmRunResult.isRunCompleted()) {
                                ++completed;
                                continue;
                            }
                            if (algorithmRunResult.getRuntime() > 0.0 || algorithmRunResult.getWallclockExecutionTime() > 0.0) {
                                ++started;
                                continue;
                            }
                            ++notStarted;
                        }
                        if (!outputCompleted.get()) {
                            log.info("Current Run Status, Total: {} , Started: {} , Completed: {}, Not Started: {}", new Object[]{total, started, completed, notStarted});
                        }
                    }
                };
                if (mainOptions.printStatus) {
                    log.info("Periodically printing status, use --print-status false to disable");
                    results = tae.evaluateRun(runsToDo, taeRunObserver);
                } else {
                    results = tae.evaluateRun(runsToDo);
                }
                outputCompleted.set(true);
            }
            ObjectMapper map = new ObjectMapper();
            JsonFactory factory = new JsonFactory();
            factory.setCodec((ObjectCodec)map);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JsonGenerator g = factory.createGenerator((OutputStream)bout);
            sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            map.configure(SerializationFeature.INDENT_OUTPUT, true);
            map.registerModule((Module)sModule);
            ArrayList<AlgorithmRunResult> results2 = new ArrayList<AlgorithmRunResult>(results);
            g.writeObject(results2);
            g.flush();
            System.out.flush();
            System.out.println("******JSON******\n" + bout.toString("UTF-8") + "\n********");
            System.out.flush();
        }
        catch (ParameterException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processRunConfig(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluator tae, final double killTime) {
        TargetAlgorithmEvaluatorRunObserver runStatus = new TargetAlgorithmEvaluatorRunObserver(){
            private long lastUpdate = 0L;

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (System.currentTimeMillis() - this.lastUpdate < 1000L) {
                    return;
                }
                for (int i = 0; i < runs.size(); ++i) {
                    AlgorithmRunResult run = runs.get(i);
                    Object[] logArguments = new Object[]{i, run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), run.getRunStatus(), run.getRuntime()};
                    log.info("Run {} on {} has status =>  {}, {}", logArguments);
                    if (!(run.getRuntime() > killTime)) continue;
                    log.info("Dynamically killing run");
                    run.kill();
                }
                this.lastUpdate = System.currentTimeMillis();
            }
        };
        List<AlgorithmRunResult> runResults = tae.evaluateRun(Collections.singletonList(runConfig), runStatus);
        log.info("Run Completed");
        for (int i = 0; i < runResults.size(); ++i) {
            AlgorithmRunResult run = runResults.get(i);
            AlgorithmRunConfiguration resultRunConfig = run.getAlgorithmRunConfiguration();
            RunStatus runResult = run.getRunStatus();
            double runtime = run.getRuntime();
            double runLength = run.getRunLength();
            double quality = run.getQuality();
            long resultSeed = run.getResultSeed();
            long requestSeed = resultRunConfig.getProblemInstanceSeedPair().getSeed();
            String additionalData = run.getAdditionalRunData();
            if (resultSeed != requestSeed) {
                log.error("Algorithm Run Result does not have a matching seed, requested: {} , returned: {}", (Object)resultSeed, (Object)requestSeed);
            }
            String configString = resultRunConfig.getParameterConfiguration().getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX);
            Object[] logArguments = new Object[]{i, resultRunConfig.getProblemInstanceSeedPair().getProblemInstance(), configString, runResult, runtime, runLength, quality, resultSeed, additionalData};
            log.info("Run {} on {} with config: {} had the result => {}, {}, {}, {}, {}, {}", logArguments);
        }
    }
}

