/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.initialization.doublingcapping;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aeatk.initialization.doublingcapping.DoublingCappingInitializationProcedureOptions;
import ca.ubc.cs.beta.aeatk.misc.MapList;
import ca.ubc.cs.beta.aeatk.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.SetInstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueue;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueueResultContext;
import ca.ubc.cs.beta.aeatk.termination.TerminationCondition;
import com.beust.jcommander.ParameterException;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DoublingCappingInitializationProcedure
implements InitializationProcedure {
    private final ThreadSafeRunHistory runHistory;
    private final ParameterConfiguration initialIncumbent;
    private final TargetAlgorithmEvaluator tae;
    private final DoublingCappingInitializationProcedureOptions opts;
    private final Logger log = LoggerFactory.getLogger(DoublingCappingInitializationProcedure.class);
    private final int maxIncumbentRuns;
    private final List<ProblemInstance> instances;
    private final InstanceSeedGenerator insc;
    private ParameterConfiguration incumbent;
    private final TerminationCondition termCond;
    private final double cutoffTime;
    private final SeedableRandomPool pool;
    private boolean deterministicInstanceOrdering;
    private final ParameterConfigurationSpace configSpace;
    private final int numberOfChallengers;
    private final int numberOfRunsPerChallenger;
    private final ObjectiveHelper objHelp;
    private final AlgorithmExecutionConfiguration execConfig;

    public DoublingCappingInitializationProcedure(ThreadSafeRunHistory runHistory, ParameterConfiguration initialIncumbent, TargetAlgorithmEvaluator tae, DoublingCappingInitializationProcedureOptions opts, InstanceSeedGenerator insc, List<ProblemInstance> instances, int maxIncumbentRuns, TerminationCondition termCond, double cutoffTime, SeedableRandomPool pool, boolean deterministicInstanceOrdering, ObjectiveHelper objHelp, AlgorithmExecutionConfiguration execConfig) {
        this.runHistory = runHistory;
        this.initialIncumbent = initialIncumbent;
        this.opts = opts;
        this.instances = instances;
        this.maxIncumbentRuns = maxIncumbentRuns;
        this.insc = insc;
        this.incumbent = initialIncumbent;
        this.termCond = termCond;
        this.cutoffTime = cutoffTime;
        this.pool = pool;
        this.deterministicInstanceOrdering = deterministicInstanceOrdering;
        this.configSpace = initialIncumbent.getParameterConfigurationSpace();
        this.numberOfChallengers = opts.numberOfChallengers;
        this.numberOfRunsPerChallenger = opts.numberOfRunsPerChallenger;
        this.objHelp = objHelp;
        this.execConfig = execConfig;
        this.tae = tae;
    }

    @Override
    public void run() {
        int i;
        this.log.warn("Doubling Capping initialization procedure does NOT cache results currently");
        this.log.warn("Doubling Capping initialization procedure is EXPERIMENTAL currently. It may not work in all scenarios, such as those with small configurations and/or instance distributions. Termination conditions will be updated but not actually checked until after the procedure is completed, and state restoration will not properly restore the state (some runs will be lost). Finally as it has a lot of edge cases bugs are likely, the bugs should only manifest themselves as a crash");
        if (this.numberOfChallengers == 1) {
            throw new ParameterException("Number of Challengers must be greater than 1, use CLASSIC initialization ");
        }
        this.log.error("TAE Notify and Events need to be handled");
        this.log.debug("Using Doubling Capping Initialization");
        ParameterConfiguration incumbent = this.initialIncumbent;
        this.log.trace("Configuration Set as initial Incumbent: {}", (Object)incumbent);
        double startKappa = this.cutoffTime;
        int divisions = 1;
        while (startKappa / 2.0 > 1.0) {
            startKappa /= 2.0;
            ++divisions;
        }
        HashSet<ParameterConfiguration> randomConfigurations = new HashSet<ParameterConfiguration>();
        int totalFirstRoundChallengers = this.numberOfChallengers * this.numberOfRunsPerChallenger * divisions;
        if ((double)totalFirstRoundChallengers > this.configSpace.getUpperBoundOnSize()) {
            throw new IllegalStateException("Doubling Capping initialization won't work with this configuration space as it's too small, use classic");
        }
        Random configRandom = this.pool.getRandom("DOUBLING_INITIALIZATION_CONFIGS");
        while (randomConfigurations.size() < totalFirstRoundChallengers) {
            randomConfigurations.add(this.configSpace.getRandomParameterConfiguration(configRandom));
        }
        ArrayList<ProblemInstanceSeedPair> pisps = new ArrayList<ProblemInstanceSeedPair>(totalFirstRoundChallengers);
        Random pispRandom = this.pool.getRandom("DOUBLING_INITIALIZATION_PISPS");
        int i2 = 0;
        int attempts = 0;
        while (i2 < totalFirstRoundChallengers) {
            ProblemInstance pi;
            if (this.insc instanceof SetInstanceSeedGenerator) {
                this.insc.reinit();
            }
            if (!this.insc.hasNextSeed(pi = this.instances.get(pispRandom.nextInt(this.instances.size())))) {
                --i2;
                if (attempts > 10000) {
                    throw new IllegalStateException("Could not generate anymore problem instance seed pairs, probably the number of instances * number of seeds is too small compared to the number of challengers and runs per challenge to use in initialization");
                }
            } else {
                attempts = 0;
                ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, this.insc.getNextSeed(pi));
                pisps.add(pisp);
            }
            ++i2;
            ++attempts;
        }
        this.log.trace("Doubling capping has generated {} distinct configurations and {} problem instance seed pairs", (Object)randomConfigurations.size(), (Object)pisps.size());
        LinkedBlockingQueue<ParameterConfiguration> configsQueue = new LinkedBlockingQueue<ParameterConfiguration>();
        configsQueue.addAll(randomConfigurations);
        LinkedBlockingQueue<ProblemInstanceSeedPair> pispsQueue = new LinkedBlockingQueue<ProblemInstanceSeedPair>();
        pispsQueue.addAll(pisps);
        LinkedBlockingQueue<AlgorithmRunConfiguration> runsToDo = new LinkedBlockingQueue<AlgorithmRunConfiguration>();
        for (double kappa = startKappa; kappa <= this.cutoffTime; kappa *= 2.0) {
            for (i = 0; i < this.numberOfChallengers * this.numberOfRunsPerChallenger; ++i) {
                ParameterConfiguration config = i == 0 ? this.initialIncumbent : (ParameterConfiguration)configsQueue.poll();
                AlgorithmRunConfiguration rc = new AlgorithmRunConfiguration((ProblemInstanceSeedPair)pispsQueue.poll(), kappa, config, this.execConfig);
                runsToDo.add(rc);
            }
        }
        this.log.trace("Doubling capping has generated {} runs to do", runsToDo);
        MapList<RunStatus, AlgorithmRunResult> runs = new MapList<RunStatus, AlgorithmRunResult>(new EnumMap(RunStatus.class));
        this.phaseOneRuns(runsToDo, runs);
        HashSet<AlgorithmRunResult> phaseTwoRuns = new HashSet<AlgorithmRunResult>();
        phaseTwoRuns.addAll(runs.getList(RunStatus.SAT));
        phaseTwoRuns.addAll(runs.getList(RunStatus.UNSAT));
        if (phaseTwoRuns.size() < this.numberOfChallengers) {
            this.log.debug("Insufficient runs with SAT and UNSAT were found {} but needed {}, using some TIMEOUT runs for Phase 2 of initialization", (Object)phaseTwoRuns.size(), (Object)this.numberOfChallengers);
            List<AlgorithmRunResult> timeouts = runs.getList(RunStatus.TIMEOUT);
            for (i = 0; phaseTwoRuns.size() < this.numberOfChallengers && i < timeouts.size(); ++i) {
                phaseTwoRuns.add(timeouts.get(i));
            }
        }
        if (phaseTwoRuns.size() < this.numberOfChallengers) {
            this.log.debug("Phase one did not have enough completed runs ({}) to satisfy request of challengers: {}", (Object)phaseTwoRuns.size(), (Object)this.numberOfChallengers);
        } else {
            this.log.debug("Beginning Phase 2 of initialization with {} completed runs", (Object)phaseTwoRuns.size());
        }
        HashSet<AlgorithmRunConfiguration> existingRunConfigs = new HashSet<AlgorithmRunConfiguration>();
        HashSet<ParameterConfiguration> configs = new HashSet<ParameterConfiguration>();
        HashSet<ProblemInstanceSeedPair> phaseTwoPisps = new HashSet<ProblemInstanceSeedPair>();
        MapList<ParameterConfiguration, AlgorithmRunResult> phaseTwoResults = new MapList<ParameterConfiguration, AlgorithmRunResult>(new HashMap());
        MapList<ParameterConfiguration, ProblemInstanceSeedPair> phaseTwoPispResults = MapList.getHashMapList();
        final ConcurrentHashMap previouslyExistingRun = new ConcurrentHashMap();
        for (AlgorithmRunResult run : phaseTwoRuns) {
            existingRunConfigs.add(run.getAlgorithmRunConfiguration());
            configs.add(run.getAlgorithmRunConfiguration().getParameterConfiguration());
            phaseTwoPisps.add(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair());
            phaseTwoResults.addToList(run.getAlgorithmRunConfiguration().getParameterConfiguration(), run);
            phaseTwoPispResults.addToList(run.getAlgorithmRunConfiguration().getParameterConfiguration(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair());
            if (phaseTwoResults.get(run.getAlgorithmRunConfiguration().getParameterConfiguration()).size() <= 1) continue;
            this.log.warn("[BUG Detected]: Expected that only run one would be completed for a given configuration, but got {}", phaseTwoResults.get(run.getAlgorithmRunConfiguration().getParameterConfiguration()));
        }
        ArrayList configToIterate = new ArrayList(configs);
        Random diShuffle = this.pool.getRandom("DOUBLING_INITIALIZATION_SHUFFLE");
        Collections.shuffle(configToIterate, diShuffle);
        if (!configs.contains(this.initialIncumbent)) {
            this.log.trace("Initial Incumbent did not pass first round, adding to set");
            configToIterate.add(configToIterate.get(0));
            configToIterate.set(0, this.initialIncumbent);
        }
        ArrayList pispsToIterate = new ArrayList(phaseTwoPisps);
        Collections.shuffle(pispsToIterate, diShuffle);
        final AtomicDouble bestPerformance = new AtomicDouble(Double.MAX_VALUE);
        TargetAlgorithmEvaluatorRunObserver phaseTwoObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                ArrayList<? extends AlgorithmRunResult> objRuns = new ArrayList<AlgorithmRunResult>(runs);
                objRuns.add((AlgorithmRunResult)previouslyExistingRun.get(runs.get(0).getAlgorithmRunConfiguration().getParameterConfiguration()));
                double myPerformance = DoublingCappingInitializationProcedure.this.objHelp.computeObjective(runs);
                if (myPerformance > bestPerformance.get()) {
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        algorithmRunResult.kill();
                    }
                    return;
                }
            }
        };
        BasicTargetAlgorithmEvaluatorQueue phaseTwoTaeQueue = new BasicTargetAlgorithmEvaluatorQueue(this.tae, true);
        for (int i3 = 0; i3 < Math.min(this.numberOfChallengers, configToIterate.size()); ++i3) {
            ParameterConfiguration config = (ParameterConfiguration)configToIterate.get(i3);
            ArrayList<AlgorithmRunConfiguration> runsForConfig = new ArrayList<AlgorithmRunConfiguration>();
            for (int j = 0; j < Math.min(this.numberOfRunsPerChallenger, phaseTwoPisps.size()); ++j) {
                ProblemInstanceSeedPair pisp = (ProblemInstanceSeedPair)pispsToIterate.get(j);
                runsForConfig.add(new AlgorithmRunConfiguration(pisp, this.cutoffTime, config, this.execConfig));
            }
            this.log.trace("Scheduling {} runs for config {}", (Object)runsForConfig.size(), (Object)config);
            phaseTwoTaeQueue.evaluateRunAsync(runsForConfig, phaseTwoObs);
        }
        ParameterConfiguration newIncumbent = null;
        while (phaseTwoTaeQueue.getNumberOfOutstandingAndQueuedRuns() > 0) {
            try {
                List<AlgorithmRunResult> currentResults = phaseTwoTaeQueue.take().getAlgorithmRuns();
                double myPerformance = this.objHelp.computeObjective(currentResults);
                if (bestPerformance.get() > myPerformance) {
                    double previousBest = bestPerformance.get();
                    bestPerformance.set(myPerformance);
                    newIncumbent = currentResults.get(0).getAlgorithmRunConfiguration().getParameterConfiguration();
                    this.log.trace("New Incumbent set to {} with performance {} previous best was {}. Other challenges will continue until this bound is reached ", new Object[]{newIncumbent, myPerformance, previousBest});
                }
                try {
                    for (AlgorithmRunResult run : currentResults) {
                        this.insc.take(run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getSeed());
                    }
                    this.runHistory.append(currentResults);
                }
                catch (DuplicateRunException e) {
                    throw new IllegalStateException(e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted Exception occurred during start up, cannot continue, every invariant I am designed to hold true can not be assured.");
            }
        }
        this.log.debug("Initialization Procedure Completed. Selected incumbent {} ({}) incumbent has performance: {} ", new Object[]{this.runHistory.getThetaIdx(newIncumbent), newIncumbent, bestPerformance.get()});
        this.incumbent = newIncumbent;
    }

    private void phaseOneRuns(LinkedBlockingQueue<AlgorithmRunConfiguration> runsToDo, MapList<RunStatus, AlgorithmRunResult> runs) {
        int completedRuns = 0;
        final AtomicBoolean allRunsCompleted = new AtomicBoolean(false);
        AtomicBoolean incumbentSolved = new AtomicBoolean(false);
        TargetAlgorithmEvaluatorRunObserver obs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (allRunsCompleted.get()) {
                    DoublingCappingInitializationProcedure.this.log.trace("Phase One completed killing in progress runs {}", runs);
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        algorithmRunResult.kill();
                    }
                }
            }
        };
        this.log.debug("Beginning Phase One Runs");
        double lastKappa = 0.0;
        BasicTargetAlgorithmEvaluatorQueue taeQueue = new BasicTargetAlgorithmEvaluatorQueue(this.tae, true);
        block8: while (completedRuns < this.numberOfChallengers) {
            try {
                BasicTargetAlgorithmEvaluatorQueueResultContext context;
                AlgorithmRunConfiguration rc = runsToDo.poll();
                if (rc != null) {
                    while (incumbentSolved.get() && rc.getParameterConfiguration().equals(this.initialIncumbent)) {
                        rc = runsToDo.poll();
                        if (rc != null) continue;
                        continue block8;
                    }
                    if (lastKappa != rc.getCutoffTime()) {
                        lastKappa = rc.getCutoffTime();
                        this.log.debug("Beginning Phase One Runs with Cutoff time {} (s)", (Object)lastKappa);
                    }
                    taeQueue.evaluateRunAsync(Collections.singletonList(rc), obs);
                    context = taeQueue.poll();
                } else {
                    context = taeQueue.take();
                }
                while (context != null) {
                    AlgorithmRunResult run = context.getAlgorithmRuns().get(0);
                    this.log.trace("Run Returned: {}", (Object)run);
                    switch (run.getRunStatus()) {
                        case SAT: 
                        case UNSAT: {
                            if (run.getAlgorithmRunConfiguration().getParameterConfiguration().equals(this.initialIncumbent)) {
                                if (incumbentSolved.get()) break;
                                incumbentSolved.set(true);
                                this.log.trace("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                                runs.addToList(run.getRunStatus(), run);
                                break;
                            }
                            this.log.trace("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunStatus(), run);
                            break;
                        }
                        case TIMEOUT: {
                            if (run.getAlgorithmRunConfiguration().hasCutoffLessThanMax()) break;
                            if (run.getAlgorithmRunConfiguration().getParameterConfiguration().equals(this.initialIncumbent)) {
                                if (incumbentSolved.get()) break;
                                incumbentSolved.set(true);
                                this.log.trace("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                                runs.addToList(run.getRunStatus(), run);
                                break;
                            }
                            this.log.trace("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunStatus(), run);
                            break;
                        }
                        case KILLED: {
                            this.log.trace("Killed run detected in First round: {}", (Object)run);
                            break;
                        }
                        case CRASHED: {
                            if (run.getAlgorithmRunConfiguration().hasCutoffLessThanMax()) break;
                            if (run.getAlgorithmRunConfiguration().getParameterConfiguration().equals(this.initialIncumbent)) {
                                incumbentSolved.set(true);
                            }
                            this.log.trace("Run completed need {} more", (Object)(this.numberOfChallengers - ++completedRuns));
                            runs.addToList(run.getRunStatus(), run);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Got unexpected run result back " + (Object)((Object)context.getAlgorithmRuns().get(0).getRunStatus()));
                        }
                    }
                    context = taeQueue.poll();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted prematurely");
            }
        }
        this.log.trace("Notifying existing Phase One runs to terminate");
        allRunsCompleted.set(true);
        this.log.debug("Phase One Runs Complete");
    }

    @Override
    public ParameterConfiguration getIncumbent() {
        return this.incumbent;
    }
}

