/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.json.serializers;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.json.serializers.JsonDeserializerHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AlgorithmExecutionConfigurationJson {
    public static final String ALGO_TAE_CONTEXT = "algo-tae-context";
    public static final String ALGO_DETERMINISTIC = "algo-deterministic";
    public static final String PCS_FILE = "algo-pcs";
    public static final String ALGO_EXEC_DIR = "algo-exec-dir";
    public static final String ALGO_EXEC = "algo-exec";
    public static final String ALGO_CUTOFF_TIME = "algo-cutoff";
    public static final String ALGO_EXEC_CONFIG_ID = "@algo-exec-config-id";
    private static final Map<ObjectCodec, Map<Integer, AlgorithmExecutionConfiguration>> cacheMap = JsonDeserializerHelper.getMap();

    public static class AlgorithmExecutionConfigSerializer
    extends StdSerializer<AlgorithmExecutionConfiguration> {
        private final ConcurrentHashMap<AlgorithmExecutionConfiguration, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        protected AlgorithmExecutionConfigSerializer() {
            super(AlgorithmExecutionConfiguration.class);
        }

        public void serialize(AlgorithmExecutionConfiguration value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_EXEC_CONFIG_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_EXEC, (Object)value.getAlgorithmExecutable());
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_EXEC_DIR, (Object)value.getAlgorithmExecutionDirectory());
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.PCS_FILE, (Object)value.getParameterConfigurationSpace());
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_CUTOFF_TIME, (Object)value.getAlgorithmMaximumCutoffTime());
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_DETERMINISTIC, (Object)value.isDeterministicAlgorithm());
                jgen.writeObjectField(AlgorithmExecutionConfigurationJson.ALGO_TAE_CONTEXT, value.getTargetAlgorithmExecutionContext());
            }
            jgen.writeEndObject();
        }
    }

    public static class AlgorithmExecutionConfigDeserializer
    extends StdDeserializer<AlgorithmExecutionConfiguration> {
        protected AlgorithmExecutionConfigDeserializer() {
            super(AlgorithmExecutionConfiguration.class);
        }

        public AlgorithmExecutionConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            String algo = null;
            String algoDir = null;
            double cutoffTime = Double.NEGATIVE_INFINITY;
            ParameterConfigurationSpace pcs = null;
            boolean deterministic = false;
            TreeMap<String, String> taeContext = new TreeMap<String, String>();
            int execConfig_id = 0;
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "algo-exec": {
                        algo = jp.getValueAsString();
                        break;
                    }
                    case "algo-exec-dir": {
                        algoDir = jp.getValueAsString();
                        break;
                    }
                    case "algo-pcs": {
                        pcs = (ParameterConfigurationSpace)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, ParameterConfigurationSpace.class);
                        break;
                    }
                    case "algo-deterministic": {
                        deterministic = jp.getValueAsBoolean();
                        break;
                    }
                    case "algo-tae-context": {
                        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
                        Iterator i = node.fields();
                        while (i.hasNext()) {
                            Map.Entry ent = (Map.Entry)i.next();
                            taeContext.put((String)ent.getKey(), ((JsonNode)ent.getValue()).asText());
                        }
                        break;
                    }
                    case "algo-cutoff": {
                        cutoffTime = jp.getDoubleValue();
                        break;
                    }
                    case "@algo-exec-config-id": {
                        execConfig_id = jp.getValueAsInt();
                        break;
                    }
                }
            }
            if (execConfig_id > 0 && cache.get(execConfig_id) != null) {
                return (AlgorithmExecutionConfiguration)cache.get(execConfig_id);
            }
            AlgorithmExecutionConfiguration execConfig = new AlgorithmExecutionConfiguration(algo, algoDir, pcs, deterministic, cutoffTime, taeContext);
            if (execConfig_id > 0) {
                cache.put(execConfig_id, (Integer)((Object)execConfig));
            }
            return execConfig;
        }
    }
}

