/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.json.serializers;

import ca.ubc.cs.beta.aeatk.json.serializers.JsonDeserializerHelper;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProblemInstanceJson {
    public static final String PI_ID = "@pi-id";
    public static final String PI_INSTANCE_ID_DEPRECATED = "pi-instance-id(deprecated)";
    public static final String PI_FEATURES = "pi-features";
    public static final String PI_INSTANCE_SPECIFIC_INFO = "pi-instance-specific-info";
    public static final String PI_NAME = "pi-name";
    public static final String PISP_SEED = "pisp-seed";
    public static final String PISP_PI = "pisp-pi";
    public static final String PISP_ID = "@pisp-id";

    public static class ProblemInstanceSeedPairSerializer
    extends JsonSerializer<ProblemInstanceSeedPair> {
        private final ConcurrentHashMap<ProblemInstanceSeedPair, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        public void serialize(ProblemInstanceSeedPair value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeObjectField(ProblemInstanceJson.PISP_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(ProblemInstanceJson.PISP_PI, (Object)value.getProblemInstance());
                jgen.writeObjectField(ProblemInstanceJson.PISP_SEED, (Object)value.getSeed());
            }
            jgen.writeEndObject();
        }
    }

    public static class ProblemInstanceSeedPairDeserializer
    extends StdDeserializer<ProblemInstanceSeedPair> {
        private static final Map<ObjectCodec, Map<Integer, ProblemInstanceSeedPair>> cacheMap = JsonDeserializerHelper.getMap();

        protected ProblemInstanceSeedPairDeserializer() {
            super(ProblemInstanceSeedPair.class);
        }

        public ProblemInstanceSeedPair deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            ProblemInstance pi = null;
            long seed = Integer.MIN_VALUE;
            int pisp_id = -1;
            boolean readFullValue = false;
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "pisp-pi": {
                        pi = (ProblemInstance)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, ProblemInstance.class);
                        readFullValue = true;
                        break;
                    }
                    case "pisp-seed": {
                        seed = jp.getValueAsLong();
                        readFullValue = true;
                        break;
                    }
                    case "@pisp-id": {
                        pisp_id = jp.getValueAsInt();
                        break;
                    }
                }
            }
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            if (cache.get(pisp_id) != null) {
                return (ProblemInstanceSeedPair)cache.get(pisp_id);
            }
            if (!readFullValue) {
                throw new JsonMappingException("Short Object form for " + ProblemInstanceSeedPair.class.getSimpleName() + " detected, but no previously cached version found for ID:" + pisp_id + " cache contains: " + cache.keySet() + " entries ");
            }
            ProblemInstanceSeedPair pisp = new ProblemInstanceSeedPair(pi, seed);
            if (pisp_id > 0) {
                cache.put(pisp_id, (Integer)((Object)pisp));
            }
            return pisp;
        }
    }

    public static class ProblemInstanceSerializer
    extends JsonSerializer<ProblemInstance> {
        private final ConcurrentHashMap<ProblemInstance, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        public void serialize(ProblemInstance value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeObjectField(ProblemInstanceJson.PI_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(ProblemInstanceJson.PI_NAME, (Object)value.getInstanceName());
                jgen.writeObjectField(ProblemInstanceJson.PI_INSTANCE_SPECIFIC_INFO, (Object)value.getInstanceSpecificInformation());
                jgen.writeObjectField(ProblemInstanceJson.PI_FEATURES, value.getFeatures());
                jgen.writeObjectField(ProblemInstanceJson.PI_INSTANCE_ID_DEPRECATED, (Object)value.getInstanceID());
            }
            jgen.writeEndObject();
        }
    }

    public static class ProblemInstanceDeserializer
    extends StdDeserializer<ProblemInstance> {
        private static final Map<ObjectCodec, Map<Integer, ProblemInstance>> cacheMap = JsonDeserializerHelper.getMap();

        protected ProblemInstanceDeserializer() {
            super(ProblemInstance.class);
        }

        public ProblemInstance deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            String instanceName = null;
            int instanceDeprecatedId = 0;
            TreeMap<String, Double> features = new TreeMap<String, Double>();
            String instanceSpecificInformation = null;
            int pi_id = 0;
            block14: while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "pi-name": {
                        instanceName = jp.getValueAsString();
                        continue block14;
                    }
                    case "pi-instance-specific-info": {
                        instanceSpecificInformation = jp.getValueAsString();
                        continue block14;
                    }
                    case "pi-instance-id(deprecated)": {
                        instanceDeprecatedId = jp.getValueAsInt();
                        continue block14;
                    }
                    case "pi-features": {
                        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
                        Iterator i = node.fields();
                        while (i.hasNext()) {
                            Map.Entry ent = (Map.Entry)i.next();
                            features.put((String)ent.getKey(), ((JsonNode)ent.getValue()).asDouble());
                        }
                        continue block14;
                    }
                    case "@pi-id": {
                        pi_id = jp.getValueAsInt();
                        continue block14;
                    }
                }
                System.out.println("Not sure what this is:" + jp.getCurrentName());
            }
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            if (cache.get(pi_id) != null) {
                return (ProblemInstance)cache.get(pi_id);
            }
            ProblemInstance pi = new ProblemInstance(instanceName, instanceDeprecatedId, features, instanceSpecificInformation);
            if (pi_id > 0) {
                cache.put(pi_id, (Integer)((Object)pi));
            }
            return pi;
        }
    }
}

