/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ConditionalOperator {
    EQ("==", 0),
    NEQ("!=", 1),
    LE("<", 2),
    GR(">", 3),
    IN("in", 4);

    private final String operatorString;
    private final int opCode;
    private static Pattern conditionalMatch;
    private static Pattern inSetMatch;

    private ConditionalOperator(String operatorString, int opCode) {
        this.operatorString = operatorString;
        this.opCode = opCode;
    }

    static ConditionalOperator getOperatorFromConditionalClause(String clause) {
        Matcher m = conditionalMatch.matcher(clause);
        if (m.find()) {
            String operator = m.group(2);
            for (ConditionalOperator op : ConditionalOperator.values()) {
                if (!op.operatorString.equals(operator)) continue;
                return op;
            }
            throw new IllegalArgumentException("Detected conditional operator of \"" + operator + "\" in clause: " + clause + ", this operator is unsupported only the following operators are legal: " + ConditionalOperator.getAllOperators());
        }
        throw new IllegalArgumentException("Could not find conditional operator in clause: " + clause);
    }

    public static String getParent(String clause) {
        Matcher m = conditionalMatch.matcher(clause);
        if (m.find()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("The following is not a valid conditional clause: " + clause);
    }

    private static String getAllOperators() {
        StringBuilder sb = new StringBuilder("{");
        for (ConditionalOperator op : ConditionalOperator.values()) {
            sb.append(op.operatorString).append(",");
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public static String[] getValues(String clause) {
        Matcher m = conditionalMatch.matcher(clause);
        ConditionalOperator op = ConditionalOperator.getOperatorFromConditionalClause(clause);
        String[] values = null;
        switch (op) {
            case EQ: 
            case NEQ: 
            case LE: 
            case GR: {
                values = new String[1];
                if (!m.find()) {
                    throw new IllegalStateException("No match found, this shouldn't happen with clause:" + clause);
                }
                values[0] = m.group(3);
                return values;
            }
            case IN: {
                Matcher setValue = inSetMatch.matcher(clause);
                if (setValue.find()) {
                    String[] args = setValue.group(2).split(",");
                    values = new String[args.length];
                    HashSet<String> previousValues = new HashSet<String>();
                    for (int i = 0; i < args.length; ++i) {
                        values[i] = args[i].trim();
                        if (previousValues.add(values[i])) continue;
                        throw new IllegalArgumentException("Duplicate value in conditional clause detected: " + values[i] + " clause: " + clause);
                    }
                    return values;
                }
                throw new IllegalArgumentException("Illegal value for \"in\" operator, must contain list of values in set notation e.g., {1,2,3}, failed parsing: " + clause);
            }
        }
        throw new IllegalStateException("Unsupported operator: " + (Object)((Object)op));
    }

    public boolean conditionalClauseMatch(double currentValue, double[] possibleValues) {
        switch (this) {
            case EQ: {
                return currentValue == possibleValues[0];
            }
            case NEQ: {
                return currentValue != possibleValues[0];
            }
            case LE: {
                return currentValue < possibleValues[0];
            }
            case GR: {
                return currentValue > possibleValues[0];
            }
            case IN: {
                for (double d : possibleValues) {
                    if (currentValue != d) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException("Unsupported Operation: " + (Object)((Object)this));
    }

    public int getOperatorCode() {
        return this.opCode;
    }

    static {
        conditionalMatch = Pattern.compile("^\\s*(\\S+)\\s+(\\S+)\\s+(\\S+|\\{.+\\})\\s*$");
        inSetMatch = Pattern.compile("^\\s*(\\S+)\\s+in\\s+\\{(.+)\\}\\s*$");
    }
}

