/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.parameterconfigurationspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.objecthunter.exp4j.operator.Operator;

public class ForbiddenOperators {
    private static final int HIGHEST_PRECEDENCE = 500;
    public static final List<Operator> operators;

    static {
        ArrayList<Operator> cos = new ArrayList<Operator>();
        cos.add(new NotEqualsOperator());
        cos.add(new EqualsOperator());
        cos.add(new GreaterThanOperator());
        cos.add(new LessThanOperator());
        cos.add(new GreaterThanOrEqualToOperator());
        cos.add(new LessThanOrEqualsOperator());
        cos.add(new AndOperator());
        cos.add(new OrOperator());
        operators = Collections.unmodifiableList(cos);
    }

    private static final class OrOperator
    extends Operator {
        private OrOperator() {
            super("||", 2, true, 400);
        }

        public double apply(double ... values) {
            return values[0] > 0.0 || values[1] > 0.0 ? 1.0 : 0.0;
        }
    }

    private static final class AndOperator
    extends Operator {
        private AndOperator() {
            super("&&", 2, true, 410);
        }

        public double apply(double ... values) {
            return values[0] > 0.0 && values[1] > 0.0 ? 1.0 : 0.0;
        }
    }

    private static final class EqualsOperator
    extends Operator {
        public EqualsOperator() {
            super("==", 2, true, 420);
        }

        public double apply(double ... values) {
            return values[0] == values[1] ? 1.0 : 0.0;
        }
    }

    private static final class NotEqualsOperator
    extends Operator {
        private NotEqualsOperator() {
            super("!=", 2, true, 420);
        }

        public double apply(double ... values) {
            return values[0] != values[1] ? 1.0 : 0.0;
        }
    }

    private static final class GreaterThanOperator
    extends Operator {
        private GreaterThanOperator() {
            super(">", 2, true, 430);
        }

        public double apply(double ... values) {
            return values[0] > values[1] ? 1.0 : 0.0;
        }
    }

    private static final class LessThanOperator
    extends Operator {
        private LessThanOperator() {
            super("<", 2, true, 430);
        }

        public double apply(double ... values) {
            return values[0] < values[1] ? 1.0 : 0.0;
        }
    }

    private static final class GreaterThanOrEqualToOperator
    extends Operator {
        private GreaterThanOrEqualToOperator() {
            super(">=", 2, true, 430);
        }

        public double apply(double ... values) {
            return values[0] >= values[1] ? 1.0 : 0.0;
        }
    }

    private static final class LessThanOrEqualsOperator
    extends Operator {
        private LessThanOrEqualsOperator() {
            super("<=", 2, true, 430);
        }

        public double apply(double ... values) {
            return values[0] <= values[1] ? 1.0 : 0.0;
        }
    }
}

