/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.ReadWriteLockThreadTracker;
import ca.ubc.cs.beta.aeatk.runhistory.RunData;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.smac.SMACOptions;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSharingRunHistoryDecorator
implements ThreadSafeRunHistory {
    private final RunHistory runHistory;
    ReadWriteLockThreadTracker rwltt = new ReadWriteLockThreadTracker();
    private static final Logger log = LoggerFactory.getLogger(FileSharingRunHistoryDecorator.class);
    private final String sharedFileName;
    private final FileOutputStream fout;
    private final ObjectMapper map = new ObjectMapper();
    private static final String JSON_FILE_PREFIX = "live-rundata-";
    private static final String JSON_FILE_SUFFIX = ".json";
    private final File outputDir;
    private final int MSBetweenUpdates;
    private final JsonFactory factory = new JsonFactory();
    private final JsonGenerator g;
    private final List<ProblemInstance> pis;
    private final ConcurrentMap<File, Integer> importedRuns = new ConcurrentSkipListMap<File, Integer>();
    private final SMACOptions.SharedModelModeDefaultHandling srdh;
    private final boolean writeData;
    private final boolean assymetricMode;
    private final boolean readData;
    private final AtomicInteger locallyAddedRuns = new AtomicInteger(0);
    private long lastUpdateTime = 0L;
    private final Set<File> filesWithErrors = Collections.synchronizedSet(new HashSet());

    public FileSharingRunHistoryDecorator(RunHistory runHistory, File directory, int outputID, List<ProblemInstance> pis, int MSecondsBetweenUpdates, boolean readData) {
        this(runHistory, directory, outputID, pis, MSecondsBetweenUpdates, readData, false, SMACOptions.SharedModelModeDefaultHandling.USE_ALL, true);
    }

    public FileSharingRunHistoryDecorator(RunHistory runHistory, File directory, final int outputID, List<ProblemInstance> pis, int MSecondsBetweenUpdates, final boolean readData, boolean sharedModeModeAssymetricMode, SMACOptions.SharedModelModeDefaultHandling defaultHandler, boolean writeRunData) {
        this.runHistory = runHistory;
        this.outputDir = directory;
        this.readData = readData;
        this.srdh = defaultHandler;
        this.writeData = writeRunData;
        this.assymetricMode = sharedModeModeAssymetricMode;
        if (MSecondsBetweenUpdates < 0) {
            throw new IllegalArgumentException("Seconds between updates must be positive, not:" + MSecondsBetweenUpdates);
        }
        this.MSBetweenUpdates = MSecondsBetweenUpdates;
        String filename = this.sharedFileName = new File(directory + File.separator + JSON_FILE_PREFIX + outputID + JSON_FILE_SUFFIX).getAbsolutePath();
        if (!this.writeData) {
            try {
                File tmp = File.createTempFile("DummyFile", "AEATK");
                tmp.deleteOnExit();
                filename = tmp.getAbsolutePath();
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't create temp file");
            }
        }
        final File f = new File(filename);
        try {
            this.fout = new FileOutputStream(f);
            this.factory.setCodec((ObjectCodec)this.map);
            this.g = this.factory.createGenerator((OutputStream)this.fout);
            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            this.map.configure(SerializationFeature.INDENT_OUTPUT, true);
            this.map.registerModule((Module)sModule);
            ArrayList<ProblemInstance> myPis = new ArrayList<ProblemInstance>(pis);
            if (this.writeData) {
                this.g.writeObject(myPis);
                this.g.flush();
            }
            this.pis = Collections.unmodifiableList(myPis);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create shared model output file :" + this.sharedFileName);
        }
        if (log.isInfoEnabled()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("FileSharingRunHistory Logger ( outputID:" + outputID + ")");
                    ArrayList<String> addedRunsStr = new ArrayList<String>();
                    int total = 0;
                    for (Map.Entry ent : FileSharingRunHistoryDecorator.this.importedRuns.entrySet()) {
                        addedRunsStr.add(((File)ent.getKey()).getName() + "=>" + ent.getValue());
                        int values = (Integer)ent.getValue();
                        if (values <= 0) continue;
                        total += values;
                    }
                    if (readData) {
                        log.info("At shutdown: {} had {} runs added to it", (Object)f, (Object)FileSharingRunHistoryDecorator.this.locallyAddedRuns.get());
                        log.info("At shutdown: we retrieved atleast {} runs and added them to our current data set {} which now has {} runs ({} local)", new Object[]{total, addedRunsStr, FileSharingRunHistoryDecorator.this.getAlgorithmRunDataIncludingRedundant().size(), FileSharingRunHistoryDecorator.this.locallyAddedRuns.get()});
                    } else {
                        log.debug("At shutdown: {} had {} runs added to it", (Object)f, (Object)FileSharingRunHistoryDecorator.this.locallyAddedRuns.get());
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Collection<AlgorithmRunResult> runs) {
        this.lockWrite();
        try {
            for (AlgorithmRunResult run : runs) {
                try {
                    this.runHistory.append(run);
                }
                catch (DuplicateRunException e1) {
                    continue;
                }
                try {
                    if (this.writeData) {
                        this.g.writeObject((Object)run);
                        this.g.flush();
                    }
                    this.locallyAddedRuns.incrementAndGet();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't save data as JSON", e);
                }
                if (!this.readData) continue;
                this.reReadFiles();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reReadFiles() {
        try {
            this.lockWrite();
            if (System.currentTimeMillis() - this.lastUpdateTime < (long)this.MSBetweenUpdates) {
                return;
            }
            try {
                File[] matchingFiles = this.outputDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.getName().startsWith(FileSharingRunHistoryDecorator.JSON_FILE_PREFIX) && pathname.getName().endsWith(FileSharingRunHistoryDecorator.JSON_FILE_SUFFIX)) {
                            return !pathname.getAbsolutePath().equals(FileSharingRunHistoryDecorator.this.sharedFileName);
                        }
                        return false;
                    }
                });
                if (this.assymetricMode) {
                    TreeSet<File> allFiles = new TreeSet<File>();
                    allFiles.addAll(Arrays.asList(matchingFiles));
                    File me = new File(this.sharedFileName);
                    allFiles.add(me);
                    ArrayList filesInOrder = new ArrayList(allFiles);
                    int startingFile = filesInOrder.indexOf(me);
                    TreeSet<File> myFilesToReadSet = new TreeSet<File>();
                    myFilesToReadSet.add(me);
                    for (int i = startingFile; i < filesInOrder.size(); ++i) {
                        if (!myFilesToReadSet.contains(filesInOrder.get(i))) continue;
                        if (2 * i < filesInOrder.size()) {
                            myFilesToReadSet.add((File)filesInOrder.get(2 * i));
                        }
                        if (2 * i + 1 >= filesInOrder.size()) continue;
                        myFilesToReadSet.add((File)filesInOrder.get(2 * i + 1));
                    }
                    myFilesToReadSet.remove(me);
                    ArrayList myFilesToRead = new ArrayList(myFilesToReadSet);
                    matchingFiles = myFilesToRead.toArray(new File[0]);
                }
                TreeSet<String> newReads = new TreeSet<String>();
                for (File match : matchingFiles) {
                    log.trace("Matching files: {} my file: {} ", (Object)match.getAbsolutePath(), (Object)this.sharedFileName);
                    boolean newFileRead = this.readRunsFromFile(match);
                    if (!newFileRead) continue;
                    newReads.add(match.getName());
                }
                if (newReads.size() > 0) {
                    log.info("Detected new source(s) of run data which we will read from : {}", newReads);
                }
            }
            finally {
                this.lastUpdateTime = System.currentTimeMillis();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readRunsFromFile(File match) {
        this.importedRuns.putIfAbsent(match, 0);
        int previousRuns = (Integer)this.importedRuns.get(match);
        if (previousRuns == -1) {
            return false;
        }
        JsonFactory jfactory = new JsonFactory();
        boolean readNewFile = false;
        try {
            int newValue;
            block18: {
                ObjectMapper map = new ObjectMapper(jfactory);
                SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
                map.registerModule((Module)sModule);
                JsonParser jParser = jfactory.createParser(match);
                ArrayList<Object> pis = new ArrayList<Object>(Arrays.asList((Object[])map.readValue(jParser, ProblemInstance[].class)));
                if (!pis.equals(this.pis)) {
                    log.warn("Instances in file {} do match our instances, ignoring file.\nMine   : {}\nTheirs : {}", new Object[]{match, this.pis, pis});
                    return false;
                }
                ArrayList<Object> runResult = new ArrayList<Object>();
                MappingIterator it = map.readValues(jParser, (TypeReference)new TypeReference<AlgorithmRunResult>(){});
                while (it.hasNext()) {
                    runResult.add(it.nextValue());
                }
                newValue = previousRuns;
                try {
                    block12: for (AlgorithmRunResult run : runResult.subList(previousRuns, runResult.size())) {
                        if (previousRuns == 0) {
                            readNewFile = true;
                        }
                        try {
                            ++newValue;
                            if (run.getParameterConfiguration().equals(run.getParameterConfiguration().getParameterConfigurationSpace().getDefaultConfiguration())) {
                                switch (this.srdh) {
                                    case IGNORE_ALL: {
                                        continue block12;
                                    }
                                    case SKIP_FIRST_TWO: {
                                        if (newValue <= 2) continue block12;
                                    }
                                    case USE_ALL: {
                                        this.runHistory.append(run);
                                        continue block12;
                                    }
                                }
                                throw new IllegalStateException("Not sure how to deal with this");
                            }
                            this.runHistory.append(run);
                        }
                        catch (DuplicateRunException duplicateRunException) {}
                    }
                    if (previousRuns == newValue) break block18;
                }
                catch (Throwable throwable) {
                    if (previousRuns != newValue) {
                        log.debug("Successfully read {} new runs (out of {} total) from file {} ", new Object[]{newValue - previousRuns, newValue, match});
                    }
                    this.importedRuns.put(match, newValue);
                    throw throwable;
                }
                log.debug("Successfully read {} new runs (out of {} total) from file {} ", new Object[]{newValue - previousRuns, newValue, match});
            }
            this.importedRuns.put(match, newValue);
            if (!this.filesWithErrors.remove(match)) return readNewFile;
            log.info("Successfully read file: {} after previously logged error", (Object)match.getAbsolutePath());
            return readNewFile;
        }
        catch (IOException | RuntimeException e) {
            if (!this.filesWithErrors.add(match)) return readNewFile;
            log.warn("Error occurred reading file in shared run history " + match.getAbsolutePath() + ". We will keep trying to read this file, but will only log another error after it succeeds once. We may not be able to get it's run data but we should be able to continue", (Throwable)e);
        }
        return readNewFile;
    }

    @Override
    public void append(AlgorithmRunResult run) throws DuplicateRunException {
        this.append(Collections.singleton(run));
    }

    @Override
    public RunObjective getRunObjective() {
        this.lockRead();
        try {
            RunObjective runObjective = this.runHistory.getRunObjective();
            return runObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public OverallObjective getOverallObjective() {
        this.lockRead();
        try {
            OverallObjective overallObjective = this.runHistory.getOverallObjective();
            return overallObjective;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void incrementIteration() {
        this.lockWrite();
        try {
            this.runHistory.incrementIteration();
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public int getIteration() {
        this.lockRead();
        try {
            int n = this.runHistory.getIteration();
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Set<ProblemInstance> getProblemInstancesRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getProblemInstancesRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Set<ProblemInstanceSeedPair> getProblemInstanceSeedPairsRan(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getProblemInstanceSeedPairsRan(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, Map<ProblemInstance, Map<Long, Double>> hallucinatedValues, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime, hallucinatedValues, minimumResponseValue);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public double getTotalRunCost() {
        this.lockRead();
        try {
            double d = this.runHistory.getTotalRunCost();
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Set<ProblemInstance> getUniqueInstancesRan() {
        this.lockRead();
        try {
            Set<ProblemInstance> set = this.runHistory.getUniqueInstancesRan();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Set<ParameterConfiguration> getUniqueParamConfigurations() {
        this.lockRead();
        try {
            Set<ParameterConfiguration> set = this.runHistory.getUniqueParamConfigurations();
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public int[][] getParameterConfigurationInstancesRanByIndexExcludingRedundant() {
        this.lockRead();
        try {
            int[][] nArray = this.runHistory.getParameterConfigurationInstancesRanByIndexExcludingRedundant();
            return nArray;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<ParameterConfiguration> getAllParameterConfigurationsRan() {
        this.lockRead();
        try {
            List<ParameterConfiguration> list = this.runHistory.getAllParameterConfigurationsRan();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public double[][] getAllConfigurationsRanInValueArrayForm() {
        this.lockRead();
        try {
            double[][] dArray = this.runHistory.getAllConfigurationsRanInValueArrayForm();
            return dArray;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<RunData> getAlgorithmRunDataIncludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<RunData> getAlgorithmRunDataExcludingRedundant() {
        this.lockRead();
        try {
            List<RunData> list = this.runHistory.getAlgorithmRunDataExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Set<ProblemInstanceSeedPair> getEarlyCensoredProblemInstanceSeedPairs(ParameterConfiguration config) {
        this.lockRead();
        try {
            Set<ProblemInstanceSeedPair> set = this.runHistory.getEarlyCensoredProblemInstanceSeedPairs(config);
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public int getThetaIdx(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            int n = this.runHistory.getThetaIdx(configuration);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getEmpiricalCost(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime, double minimumResponseValue) {
        this.lockRead();
        try {
            double d = this.runHistory.getEmpiricalCost(config, instanceSet, cutoffTime);
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public int getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getNumberOfUniqueProblemInstanceSeedPairsForConfiguration(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void readLock() {
        this.lockRead();
    }

    @Override
    public void releaseReadLock() {
        this.unlockRead();
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public int getTotalNumRunsOfConfigExcludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigExcludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsExcludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsExcludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant(config);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public int getTotalNumRunsOfConfigIncludingRedundant(ParameterConfiguration config) {
        this.lockRead();
        try {
            int n = this.runHistory.getTotalNumRunsOfConfigIncludingRedundant(config);
            return n;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<AlgorithmRunResult> getAlgorithmRunsIncludingRedundant() {
        this.lockRead();
        try {
            List<AlgorithmRunResult> list = this.runHistory.getAlgorithmRunsIncludingRedundant();
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public Map<ProblemInstance, LinkedHashMap<Long, Double>> getPerformanceForConfig(ParameterConfiguration configuration) {
        this.lockRead();
        try {
            Map<ProblemInstance, LinkedHashMap<Long, Double>> map = this.runHistory.getPerformanceForConfig(configuration);
            return map;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public List<Long> getSeedsUsedByInstance(ProblemInstance pi) {
        this.lockRead();
        try {
            List<Long> list = this.runHistory.getSeedsUsedByInstance(pi);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    public void lockRead() {
        this.rwltt.lockRead();
    }

    private void unlockRead() {
        this.rwltt.unlockRead();
    }

    private void lockWrite() {
        this.rwltt.lockWrite();
    }

    private void unlockWrite() {
        this.rwltt.unlockWrite();
    }

    @Override
    public int getOrCreateThetaIdx(ParameterConfiguration config) {
        this.lockWrite();
        try {
            int n = this.runHistory.getOrCreateThetaIdx(config);
            return n;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public double getEmpiricalCostLowerBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostLowerBound(config, instanceSet, cutoffTime);
    }

    @Override
    public double getEmpiricalCostUpperBound(ParameterConfiguration config, Set<ProblemInstance> instanceSet, double cutoffTime) {
        return this.runHistory.getEmpiricalCostUpperBound(config, instanceSet, cutoffTime);
    }

    @Override
    public AlgorithmRunResult getAlgorithmRunResultForAlgorithmRunConfiguration(AlgorithmRunConfiguration runConfig) {
        this.lockRead();
        try {
            AlgorithmRunResult algorithmRunResult = this.runHistory.getAlgorithmRunResultForAlgorithmRunConfiguration(runConfig);
            return algorithmRunResult;
        }
        finally {
            this.unlockRead();
        }
    }
}

