/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WaitableTAECallback
implements TargetAlgorithmEvaluatorCallback {
    private final CountDownLatch completeCount = new CountDownLatch(1);
    private final TargetAlgorithmEvaluatorCallback handler;

    public WaitableTAECallback(TargetAlgorithmEvaluatorCallback handler) {
        this.handler = handler;
    }

    @Override
    public void onSuccess(List<AlgorithmRunResult> runs) {
        this.handler.onSuccess(runs);
        this.completeCount.countDown();
    }

    @Override
    public void onFailure(RuntimeException t) {
        try {
            this.handler.onFailure(t);
        }
        finally {
            this.completeCount.countDown();
        }
    }

    public void waitForCompletion() {
        try {
            this.completeCount.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

