/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.random;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.AbstractSyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.random.RandomResponseTargetAlgorithmEvaluatorOptions;
import com.beust.jcommander.ParameterException;
import ec.util.MersenneTwister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RandomResponseTargetAlgorithmEvaluator
extends AbstractSyncTargetAlgorithmEvaluator {
    private final double scale;
    private final double trendCoefficient;
    private final double minValue;
    private boolean persistent;
    private boolean shuffleRuns;
    private final String additionalRunData;
    private final long sleepInternally;
    private final long seed;
    private static final Logger log = LoggerFactory.getLogger(RandomResponseTargetAlgorithmEvaluator.class);
    private final Random shuffleRand;

    public RandomResponseTargetAlgorithmEvaluator(RandomResponseTargetAlgorithmEvaluatorOptions options) {
        if (options.maxResponse - options.minResponse < 0.0) {
            throw new ParameterException("Maximum response must be greater than the minimum response");
        }
        this.scale = options.maxResponse - options.minResponse;
        this.minValue = options.minResponse;
        this.trendCoefficient = options.trendCoefficient;
        log.debug("Target Algorithm Evaluator initialized with seed: {} ", (Object)options.seed);
        this.seed = options.seed;
        this.shuffleRuns = options.shuffleResponses;
        this.shuffleRand = new MersenneTwister(this.seed);
        this.persistent = options.persistent;
        this.additionalRunData = options.additionalRunData;
        this.sleepInternally = options.sleepInternally;
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        ArrayList<AlgorithmRunResult> ar = new ArrayList<AlgorithmRunResult>(runConfigs.size());
        for (AlgorithmRunConfiguration rc : runConfigs) {
            MersenneTwister rand = new MersenneTwister(this.seed ^ rc.getProblemInstanceSeedPair().getSeed());
            double time = Math.max(0.01, ((Random)rand).nextDouble() * this.scale + this.minValue + this.trendCoefficient * (double)this.getRunCount());
            if (time >= rc.getCutoffTime()) {
                ar.add(new ExistingAlgorithmRunResult(rc, RunStatus.TIMEOUT, rc.getCutoffTime(), -1.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), this.additionalRunData));
            } else {
                ar.add(new ExistingAlgorithmRunResult(rc, RunStatus.SAT, time, -1.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), this.additionalRunData));
            }
            this.runCount.incrementAndGet();
        }
        if (this.shuffleRuns) {
            Collections.shuffle(ar, this.shuffleRand);
        }
        if (this.sleepInternally > 0L) {
            try {
                Thread.sleep(this.sleepInternally);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return ar;
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return this.persistent;
    }

    @Override
    protected void subtypeShutdown() {
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }
}

