/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractTargetAlgorithmEvaluatorDecorator
implements TargetAlgorithmEvaluator {
    protected final TargetAlgorithmEvaluator tae;

    public AbstractTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        this.tae = tae;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(AlgorithmRunConfiguration runConfig) {
        return this.evaluateRun(Collections.singletonList(runConfig));
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs) {
        return this.evaluateRun(runConfigs, null);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver observer) {
        return this.tae.evaluateRun(runConfigs, observer);
    }

    @Override
    public final void evaluateRunsAsync(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluatorCallback callback) {
        this.evaluateRunsAsync(Collections.singletonList(runConfig), callback);
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback callback) {
        this.evaluateRunsAsync(runConfigs, callback, null);
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback callback, TargetAlgorithmEvaluatorRunObserver observer) {
        this.tae.evaluateRunsAsync(runConfigs, callback, observer);
    }

    @Override
    public int getRunCount() {
        return this.tae.getRunCount();
    }

    @Override
    public int getRunHash() {
        return this.tae.getRunHash();
    }

    @Override
    public void seek(List<AlgorithmRunResult> runs) {
        this.tae.seek(runs);
    }

    @Override
    public String getManualCallString(AlgorithmRunConfiguration runConfig) {
        return this.tae.getManualCallString(runConfig);
    }

    protected void preDecorateeNotifyShutdown() {
    }

    @Override
    public final void notifyShutdown() {
        try {
            this.preDecorateeNotifyShutdown();
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error occured while shutting down", (Throwable)e);
        }
        RuntimeException first = null;
        try {
            this.tae.notifyShutdown();
        }
        catch (RuntimeException e) {
            first = e;
        }
        try {
            this.postDecorateeNotifyShutdown();
            if (first != null) {
                throw first;
            }
        }
        catch (RuntimeException e) {
            if (first != null) {
                LoggerFactory.getLogger(this.getClass()).error("Error occured while shutting down", (Throwable)e);
                throw first;
            }
            throw e;
        }
    }

    protected abstract void postDecorateeNotifyShutdown();

    @Override
    public boolean isRunFinal() {
        return this.tae.isRunFinal();
    }

    @Override
    public boolean areRunsPersisted() {
        return this.tae.areRunsPersisted();
    }

    @Override
    public boolean areRunsObservable() {
        return this.tae.areRunsObservable();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "( 0x" + Integer.toHexString(System.identityHashCode(this)) + " ) ==> [ " + this.tae.toString() + " ]";
    }

    @Override
    public void waitForOutstandingEvaluations() {
        this.tae.waitForOutstandingEvaluations();
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        return this.tae.getNumberOfOutstandingBatches();
    }

    @Override
    public int getNumberOfOutstandingBatches() {
        return this.tae.getNumberOfOutstandingBatches();
    }

    @Override
    public int getNumberOfOutstandingRuns() {
        return this.tae.getNumberOfOutstandingRuns();
    }

    @Override
    public final void close() {
        this.notifyShutdown();
    }
}

