/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.PartialResultsAggregator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractAsyncTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.NonBlockingAsyncTargetAlgorithmEvaluatorDecorator;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptingTargetAlgorithmEvaluator
extends AbstractAsyncTargetAlgorithmEvaluatorDecorator {
    private final ScheduledExecutorService execService = Executors.newScheduledThreadPool(1, new SequentiallyNamedThreadFactory(PreemptingTargetAlgorithmEvaluator.class.getSimpleName() + " execution", true));
    private final AtomicInteger blockingMethods = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(PreemptingTargetAlgorithmEvaluator.class);
    private final AtomicInteger highPriorityRunsSubmitted = new AtomicInteger(0);
    private final AtomicInteger lowPriorityAndRetriedRunsSubmitted = new AtomicInteger(0);
    private final AtomicDouble lowPriorityCPUTimeLost = new AtomicDouble(0.0);
    private final AtomicDouble lowPriorityWallTimeLost = new AtomicDouble(0.0);
    private final AtomicInteger retriedRuns = new AtomicInteger(0);
    private final TargetAlgorithmEvaluator lowPriorityTAE = new LowPriorityTargetAlgorithmEvaluatorDecorator();
    private final TargetAlgorithmEvaluator nonBlockingLowPriorityTAE = new NonBlockingAsyncTargetAlgorithmEvaluatorDecorator(this.lowPriorityTAE);

    public PreemptingTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback callback, final TargetAlgorithmEvaluatorRunObserver observer) {
        this.highPriorityRunsSubmitted.addAndGet(runConfigs.size());
        final AtomicInteger nonStartedRuns = new AtomicInteger(runConfigs.size());
        Runnable incrementRunnable = new Runnable(){

            @Override
            public void run() {
                log.trace("Incremented Blocked Runs by {} ", (Object)runConfigs.size());
                PreemptingTargetAlgorithmEvaluator.this.blockingMethods.addAndGet(runConfigs.size());
            }
        };
        this.execService.schedule(incrementRunnable, 2L, TimeUnit.SECONDS);
        TargetAlgorithmEvaluatorRunObserver taeObserver = new TargetAlgorithmEvaluatorRunObserver(){
            private final Set<AlgorithmRunConfiguration> startedRunConfigurations = new HashSet<AlgorithmRunConfiguration>();

            @Override
            public synchronized void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (nonStartedRuns.get() > 0) {
                    block0: for (AlgorithmRunResult algorithmRunResult : runs) {
                        int presentNonStartedRuns;
                        if (!algorithmRunResult.isRunCompleted() && !(algorithmRunResult.getRuntime() > 0.0) && !(algorithmRunResult.getWallclockExecutionTime() > 0.0) || this.startedRunConfigurations.contains(algorithmRunResult.getAlgorithmRunConfiguration())) continue;
                        this.startedRunConfigurations.add(algorithmRunResult.getAlgorithmRunConfiguration());
                        while ((presentNonStartedRuns = nonStartedRuns.get()) != 0) {
                            if (!nonStartedRuns.compareAndSet(presentNonStartedRuns, presentNonStartedRuns - 1)) continue;
                            PreemptingTargetAlgorithmEvaluator.this.blockingMethods.decrementAndGet();
                            continue block0;
                        }
                        break block0;
                    }
                }
                if (observer != null) {
                    observer.currentStatus(runs);
                }
            }
        };
        try {
            this.tae.evaluateRunsAsync(runConfigs, callback, taeObserver);
        }
        finally {
            int remainingNonStartedRuns = nonStartedRuns.getAndSet(0);
            this.blockingMethods.addAndGet(-remainingNonStartedRuns);
            log.trace("On completion of runs blockingMethods is {}, fixed {} runs", (Object)this.blockingMethods.get(), (Object)remainingNonStartedRuns);
        }
    }

    private void evaluateRunsAsyncLowPriority(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback callback, final TargetAlgorithmEvaluatorRunObserver observer) {
        this.lowPriorityAndRetriedRunsSubmitted.addAndGet(runConfigs.size());
        final AtomicInteger incrementsToBlockingMethodsWhenDone = new AtomicInteger(0);
        final Set killedRuns = Collections.newSetFromMap(new ConcurrentHashMap());
        final PartialResultsAggregator pra = new PartialResultsAggregator(runConfigs);
        TargetAlgorithmEvaluatorRunObserver taeObserver = new TargetAlgorithmEvaluatorRunObserver(){

            /*
             * WARNING - void declaration
             */
            @Override
            public synchronized void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (PreemptingTargetAlgorithmEvaluator.this.blockingMethods.get() > 0) {
                    void var3_5;
                    log.trace("Detected {} blocking methods", (Object)PreemptingTargetAlgorithmEvaluator.this.blockingMethods.get());
                    int runningCount = 0;
                    boolean bl = false;
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        if (algorithmRunResult.isRunCompleted() || killedRuns.contains(algorithmRunResult.getAlgorithmRunConfiguration())) continue;
                        ++runningCount;
                        if (!PreemptingTargetAlgorithmEvaluator.isStarted(algorithmRunResult)) continue;
                        ++var3_5;
                    }
                    if (runningCount > 0) {
                        int n;
                        int runsToTerminate = 0;
                        while (!((n = PreemptingTargetAlgorithmEvaluator.this.blockingMethods.get()) == 0 || PreemptingTargetAlgorithmEvaluator.this.blockingMethods.compareAndSet(n, n - 1) && ++runsToTerminate == var3_5)) {
                        }
                        if (runsToTerminate > 0) {
                            void var5_12;
                            incrementsToBlockingMethodsWhenDone.addAndGet(runsToTerminate);
                            boolean bl2 = false;
                            for (AlgorithmRunResult algorithmRunResult : runs) {
                                if (algorithmRunResult.isRunCompleted()) continue;
                                killedRuns.add(algorithmRunResult.getAlgorithmRunConfiguration());
                                algorithmRunResult.kill();
                                ++var5_12;
                            }
                            log.trace("Due to blocking high priority runs, killed {} low priority runs, currently blocking runs {} . When run is completed we will do {} increments ", new Object[]{(int)var5_12, PreemptingTargetAlgorithmEvaluator.this.blockingMethods.get(), incrementsToBlockingMethodsWhenDone.get()});
                        }
                    } else {
                        log.trace("No currently running runs detected");
                    }
                }
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    if (!killedRuns.contains(algorithmRunResult.getAlgorithmRunConfiguration())) continue;
                    algorithmRunResult.kill();
                }
                if (observer != null) {
                    observer.currentStatus(runs);
                }
            }
        };
        TargetAlgorithmEvaluatorCallback taeCallback = new TargetAlgorithmEvaluatorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                try {
                    for (AlgorithmRunResult run : runs) {
                        if (!run.getRunStatus().equals((Object)RunStatus.KILLED) || !killedRuns.contains(run.getAlgorithmRunConfiguration())) {
                            pra.updateCompletedRun(run);
                            continue;
                        }
                        PreemptingTargetAlgorithmEvaluator.this.lowPriorityCPUTimeLost.addAndGet(run.getRuntime());
                        PreemptingTargetAlgorithmEvaluator.this.lowPriorityWallTimeLost.addAndGet(run.getWallclockExecutionTime());
                    }
                    if (pra.isCompleted()) {
                        if (callback != null) {
                            callback.onSuccess(pra.getCurrentRunStatusOnCompletion());
                        }
                    } else {
                        log.debug("Low Priority Runs were killed in place of high priority runs, {} runs will be rescheduled", (Object)pra.getOutstandingRunConfigurations().size());
                        PreemptingTargetAlgorithmEvaluator.this.retriedRuns.addAndGet(pra.getOutstandingRunConfigurations().size());
                        PreemptingTargetAlgorithmEvaluator.this.recursivelyRetryRuns(pra, callback, observer);
                    }
                }
                finally {
                    PreemptingTargetAlgorithmEvaluator.this.blockingMethods.addAndGet(incrementsToBlockingMethodsWhenDone.getAndSet(0));
                }
            }

            @Override
            public void onFailure(RuntimeException e) {
                try {
                    if (callback != null) {
                        callback.onFailure(e);
                    }
                }
                finally {
                    PreemptingTargetAlgorithmEvaluator.this.blockingMethods.addAndGet(incrementsToBlockingMethodsWhenDone.getAndSet(0));
                }
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, taeCallback, taeObserver);
    }

    private static boolean isStarted(AlgorithmRunResult run) {
        return run.getRuntime() > 0.0 || run.getWallclockExecutionTime() > 0.0 || run.isRunCompleted();
    }

    private void recursivelyRetryRuns(final PartialResultsAggregator pra, final TargetAlgorithmEvaluatorCallback callback, final TargetAlgorithmEvaluatorRunObserver observer) {
        ArrayList<AlgorithmRunConfiguration> outstanding = new ArrayList<AlgorithmRunConfiguration>(pra.getOutstandingRunConfigurations());
        TargetAlgorithmEvaluatorCallback newCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                pra.updateCompletedRuns(runs);
                if (callback != null) {
                    callback.onSuccess(pra.getCurrentRunStatusOnCompletion());
                }
            }

            @Override
            public void onFailure(RuntimeException e) {
                callback.onFailure(e);
            }
        };
        TargetAlgorithmEvaluatorRunObserver obs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                pra.updateCurrentRunStatus(runs);
                if (observer != null) {
                    observer.currentStatus(pra.getCurrentRunStatusForObserver());
                }
            }
        };
        this.nonBlockingLowPriorityTAE.evaluateRunsAsync(outstanding, newCallback, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        log.info(this.getClass().getSimpleName() + " on shutdown we had served {} high priority requests, {} low priority requests. We retried {} low priority requests," + " and consequently lost {} (s) of cpu time and {} (s) of algorithm execution wall time. The current number of high priority runs that are stalled is: {}", new Object[]{this.highPriorityRunsSubmitted.get(), this.lowPriorityAndRetriedRunsSubmitted.get() - this.retriedRuns.get(), this.retriedRuns.get(), this.lowPriorityCPUTimeLost.get(), this.lowPriorityWallTimeLost.get(), this.blockingMethods.get()});
    }

    public TargetAlgorithmEvaluator getLowPriorityTargetAlgorithmEvaluator() {
        return this.lowPriorityTAE;
    }

    private class LowPriorityTargetAlgorithmEvaluatorDecorator
    extends AbstractAsyncTargetAlgorithmEvaluatorDecorator {
        public LowPriorityTargetAlgorithmEvaluatorDecorator() {
            super(PreemptingTargetAlgorithmEvaluator.this);
        }

        @Override
        public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback callback, TargetAlgorithmEvaluatorRunObserver observer) {
            PreemptingTargetAlgorithmEvaluator.this.evaluateRunsAsyncLowPriority(runConfigs, callback, observer);
        }

        @Override
        protected void postDecorateeNotifyShutdown() {
        }
    }
}

