/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.termination;

import ca.ubc.cs.beta.aeatk.termination.ConditionType;
import java.text.DecimalFormat;

public class ValueMaxStatus {
    private final double current;
    private final double max;
    private final String status;
    private final String name;
    private ConditionType type;

    public ValueMaxStatus(ConditionType type, double current, double max, String name, String status) {
        this.type = type;
        this.current = current;
        this.max = max;
        this.status = status;
        this.name = name;
    }

    public ValueMaxStatus(ConditionType type, double current, double max, String name) {
        this.type = type;
        this.current = current;
        this.max = max;
        this.name = name;
        this.status = name + " is currently (" + current + "). Max is ( " + max + " ) ";
    }

    public ValueMaxStatus(ConditionType type, double current, double max, String name, String friendlyName, String unit) {
        this.type = type;
        this.current = current;
        this.max = max;
        this.name = name;
        String remaining = "";
        DecimalFormat c = current > 1000000.0 ? new DecimalFormat("0.00E0") : new DecimalFormat("0.00");
        DecimalFormat mc = max - current > 1000000.0 ? new DecimalFormat("0.00E0") : new DecimalFormat("0.00");
        this.status = friendlyName + " used: " + c.format(current) + " " + unit + " (" + (int)(current / max * 100.0) + "%)\n" + friendlyName + " remaining: " + mc.format(max - current) + " " + unit + "\n";
    }

    public double getCurrent() {
        return this.current;
    }

    public double getMax() {
        return this.max;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return this.getStatus();
    }

    public ConditionType getType() {
        return this.type;
    }
}

