/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.json.serializers;

import ca.ubc.cs.beta.aeatk.json.serializers.JsonDeserializerHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ParameterConfigurationSpaceJson {
    public static final String PC_DEFAULT = "pc-default";
    public static final String PC_FORBIDDEN = "pc-forbidden";
    public static final String PC_ACTIVE_PARAMETERS = "pc-active-parameters";
    public static final String PC_SETTINGS = "pc-settings";
    public static final String PC_PCS = "pc-pcs";
    public static final String PC_ID = "@pc-id";
    public static final String PCS_SUBSPACE = "pcs-subspace";
    public static final String PCS_TEXT = "pcs-text";
    public static final String PCS_FILENAME = "pcs-filename";
    public static final String PCS_ID = "@pcs-id";

    public static class ParamConfigurationSpaceSerializer
    extends StdSerializer<ParameterConfigurationSpace> {
        private final ConcurrentHashMap<ParameterConfigurationSpace, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        protected ParamConfigurationSpaceSerializer() {
            super(ParameterConfigurationSpace.class);
        }

        public void serialize(ParameterConfigurationSpace value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeStartObject();
            jgen.writeObjectField(ParameterConfigurationSpaceJson.PCS_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PCS_FILENAME, (Object)value.getParamFileName());
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PCS_TEXT, (Object)value.getPCSFile());
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PCS_SUBSPACE, value.getSearchSubspace());
            }
            jgen.writeEndObject();
        }
    }

    public static class ParamConfigurationSpaceDeserializer
    extends StdDeserializer<ParameterConfigurationSpace> {
        private static final Map<ObjectCodec, Map<Integer, ParameterConfigurationSpace>> cacheMap = JsonDeserializerHelper.getMap();

        protected ParamConfigurationSpaceDeserializer() {
            super(ParameterConfigurationSpace.class);
        }

        public ParameterConfigurationSpace deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (!jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                throw new JsonParseException("Expected start object", jp.getCurrentLocation());
            }
            String pcsText = null;
            String pcsFilename = null;
            TreeMap<String, String> subspace = new TreeMap<String, String>();
            int pcs_id = 0;
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "pcs-text": {
                        pcsText = jp.getValueAsString();
                        break;
                    }
                    case "pcs-filename": {
                        pcsFilename = jp.getValueAsString();
                        break;
                    }
                    case "pcs-subspace": {
                        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
                        Iterator i = node.fields();
                        while (i.hasNext()) {
                            Map.Entry ent = (Map.Entry)i.next();
                            subspace.put((String)ent.getKey(), ((JsonNode)ent.getValue()).asText());
                        }
                        break;
                    }
                    case "@pcs-id": {
                        pcs_id = jp.getValueAsInt();
                        break;
                    }
                }
            }
            if (cache.get(pcs_id) != null) {
                return (ParameterConfigurationSpace)cache.get(pcs_id);
            }
            ParameterConfigurationSpace configSpace = new ParameterConfigurationSpace(new StringReader(pcsText), pcsFilename, subspace);
            if (pcs_id > 0) {
                cache.put(pcs_id, (Integer)((Object)configSpace));
            }
            return configSpace;
        }
    }

    public static class ParamConfigurationSerializer
    extends StdSerializer<ParameterConfiguration> {
        private final ConcurrentHashMap<ParameterConfiguration, Integer> map = new ConcurrentHashMap();
        private final AtomicInteger idMap = new AtomicInteger(1);

        protected ParamConfigurationSerializer() {
            super(ParameterConfiguration.class);
        }

        public void serialize(ParameterConfiguration value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            boolean firstWrite = this.map.putIfAbsent(value, this.idMap.incrementAndGet()) == null;
            Integer id = this.map.get(value);
            jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_ID, (Object)id);
            if (firstWrite) {
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_PCS, (Object)value.getParameterConfigurationSpace());
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_SETTINGS, new LinkedHashMap<String, String>(value));
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_ACTIVE_PARAMETERS, value.getActiveParameters());
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_FORBIDDEN, (Object)value.isForbiddenParameterConfiguration());
                jgen.writeObjectField(ParameterConfigurationSpaceJson.PC_DEFAULT, (Object)value.getParameterConfigurationSpace().getDefaultConfiguration().equals(value));
            }
            jgen.writeEndObject();
        }
    }

    public static class ParamConfigurationDeserializer
    extends StdDeserializer<ParameterConfiguration> {
        private static final Map<ObjectCodec, Map<Integer, ParameterConfiguration>> cacheMap = JsonDeserializerHelper.getMap();

        protected ParamConfigurationDeserializer() {
            super(ParameterConfiguration.class);
        }

        public ParameterConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                jp.nextToken();
            }
            ParameterConfigurationSpace configSpace = null;
            HashMap settings = new HashMap();
            int pc_id = 0;
            Map<Integer, Integer> cache = JsonDeserializerHelper.getCache(cacheMap, jp.getCodec());
            while (jp.nextValue() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                if (jp.getCurrentName() == null) continue;
                switch (jp.getCurrentName()) {
                    case "pc-default": 
                    case "pc-forbidden": 
                    case "pc-active-parameters": {
                        break;
                    }
                    case "pc-pcs": {
                        configSpace = (ParameterConfigurationSpace)JsonDeserializerHelper.getDeserializedVersion(jp, ctxt, ParameterConfigurationSpace.class);
                        if (configSpace != null) break;
                        throw new JsonParseException("Couldn't resolve ParamConfigurationSpace from child", jp.getCurrentLocation());
                    }
                    case "pc-settings": {
                        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
                        Iterator i = node.fields();
                        while (i.hasNext()) {
                            Map.Entry ent = (Map.Entry)i.next();
                            settings.put(ent.getKey(), ((JsonNode)ent.getValue()).asText());
                        }
                        break;
                    }
                    case "@pc-id": {
                        pc_id = jp.getValueAsInt();
                        break;
                    }
                }
            }
            if (cache.get(pc_id) != null) {
                return (ParameterConfiguration)cache.get(pc_id);
            }
            if (configSpace == null) {
                throw new JsonParseException("Couldn't find ParamConfigurationSpace", jp.getCurrentLocation());
            }
            ParameterConfiguration config = configSpace.getDefaultConfiguration();
            config.putAll(settings);
            if (pc_id > 0) {
                cache.put(pc_id, (Integer)((Object)config));
            }
            return config;
        }
    }
}

