/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.misc.bashcompletion;

import ca.ubc.cs.beta.aeatk.misc.MapList;
import ca.ubc.cs.beta.aeatk.misc.bashcompletion.BashCompletionOptions;
import ca.ubc.cs.beta.aeatk.misc.options.UsageSection;
import ca.ubc.cs.beta.aeatk.options.docgen.UsageSectionGenerator;
import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class BashCompletion {
    public static void main(String[] args) throws Exception {
        try {
            BashCompletionOptions opts = new BashCompletionOptions();
            JCommander jcom = new JCommander((Object)opts, true, true);
            jcom.parse(args);
            Object obj = Class.forName(opts.clazz).newInstance();
            List<UsageSection> sections = UsageSectionGenerator.getUsageSections(obj);
            String completionScript = BashCompletion.bash(sections, opts.commandName);
            if (opts.debug) {
                System.out.println(completionScript);
            }
            FileWriter fw = new FileWriter(new File(opts.outputFile), true);
            fw.write(completionScript);
            fw.flush();
            fw.close();
            System.out.println("Bash completion script for " + opts.commandName + " written to: " + new File(opts.outputFile).getAbsolutePath() + "");
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("Couldn't generate bash completion script");
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean isDomainASet(String domain) {
        if (domain == null || domain.length() < 2) {
            return false;
        }
        if ((domain = domain.trim()).charAt(0) != '{') {
            return false;
        }
        return domain.charAt(domain.length() - 1) == '}';
    }

    public static boolean hasNonCamelCase(List<String> strings) {
        for (String s : strings) {
            if (!(s = s.trim()).matches("^--[a-z0-9\\-]+$")) continue;
            return true;
        }
        return false;
    }

    public static List<String> removeCamelCase(List<String> strings) {
        strings = new ArrayList<String>(strings);
        Iterator<String> s = strings.iterator();
        while (s.hasNext()) {
            String str = s.next();
            if (!str.matches("^--.*[a-z0-9][A-Z][a-z0-9].*$")) continue;
            s.remove();
        }
        return strings;
    }

    public static String bash(List<UsageSection> sections, String commandName) {
        StringWriter s = new StringWriter();
        PrintWriter pw = new PrintWriter(s);
        TreeSet<String> sorted = new TreeSet<String>();
        MapList<String, String> domainToOptionsMap = new MapList<String, String>(new TreeMap());
        for (UsageSection usageSection : sections) {
            for (String attr : usageSection) {
                List<String> aliases = Arrays.asList(usageSection.getAttributeAliases(attr).replaceAll("\\s*,\\s*", " ").split(" "));
                if (BashCompletion.hasNonCamelCase(aliases)) {
                    aliases = BashCompletion.removeCamelCase(aliases);
                }
                sorted.addAll(aliases);
                String domain = usageSection.getAttributeDomain(attr).trim();
                if (BashCompletion.isDomainASet(domain) && domain != null && domain.trim().length() > 0) {
                    domainToOptionsMap.addAllToList(domain, aliases);
                }
                if (!domain.trim().equals("FILES")) continue;
                domainToOptionsMap.addAllToList(domain, aliases);
            }
        }
        for (String string : sorted) {
            if (!string.trim().startsWith("--")) continue;
            pw.append(string);
            pw.append(" ");
        }
        StringBuilder allCases = new StringBuilder();
        allCases.append("\t#Adapted from http://www.debian-administration.org/article/317/An_introduction_to_bash_completion_part_2\n");
        allCases.append("\tlocal cur prev opts base\n");
        allCases.append("\tCOMPREPLY=()\n");
        allCases.append("\tcur=\"${COMP_WORDS[COMP_CWORD]}\"\n");
        allCases.append("\tprev=\"${COMP_WORDS[COMP_CWORD-1]}\"\n");
        allCases.append("\tcase \"${prev}\" in\n");
        for (Map.Entry entry : domainToOptionsMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("FILES")) {
                StringBuilder sb = new StringBuilder("\t");
                for (String start : entry.getValue()) {
                    sb.append(start).append("|");
                }
                sb.setCharAt(sb.length() - 1, ')');
                sb.append("\n\t\t _filedir\n");
                sb.append("\t\treturn 0\n");
                sb.append("\t\t;;\n");
                allCases.append((CharSequence)sb);
                continue;
            }
            String possibleCompletions = key.trim().substring(1, key.trim().length() - 1);
            possibleCompletions = possibleCompletions.replaceAll(",", " ");
            StringBuilder sb = new StringBuilder("\t");
            for (String start : entry.getValue()) {
                sb.append(start).append("|");
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n\t\tanswers=\"").append(possibleCompletions).append("\"\n");
            sb.append("\t\tCOMPREPLY=( $(compgen -W \"${answers}\" -- ${cur}) )\n ");
            sb.append("\t\treturn 0\n");
            sb.append("\t\t;;\n");
            allCases.append((CharSequence)sb);
        }
        allCases.append("\t*)\n");
        allCases.append("\t\tanswers=\"").append(s).append("\"\n");
        allCases.append("\t\tif [[ ${cur} == -* ]] ; then\n        \t\tCOMPREPLY=( $(compgen -W \"${answers}\" -- ${cur}) )\n\t        \treturn 0\n    \t\tfi\n");
        allCases.append("\t\t;;\n\tesac\n");
        String string = commandName.replaceAll("-", "_");
        String string2 = "_" + string + "()\n" + "{\n" + allCases.toString() + "}\n" + "complete -F _" + string + " " + commandName + "\n\n";
        return string2;
    }
}

