/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.objectives;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;

public enum RunObjective {
    RUNTIME,
    QUALITY;


    public double getObjective(AlgorithmRunResult r) {
        switch (this) {
            case RUNTIME: {
                switch (r.getRunStatus()) {
                    case TIMEOUT: {
                        return r.getAlgorithmRunConfiguration().getCutoffTime();
                    }
                    case KILLED: 
                    case RUNNING: 
                    case SAT: 
                    case UNSAT: {
                        return r.getRuntime();
                    }
                    case ABORT: 
                    case CRASHED: {
                        return r.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime();
                    }
                }
                throw new IllegalStateException("Unsure how to compute the " + (Object)((Object)this) + " RunOjective for a run with result type " + (Object)((Object)r.getRunStatus()));
            }
            case QUALITY: {
                return r.getQuality();
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this) + ": Run Objective Not Implemented");
    }

    public void validateInstanceSpecificInformation(ProblemInstance pi) {
        switch (this) {
            case RUNTIME: 
            case QUALITY: {
                return;
            }
        }
        throw new UnsupportedOperationException(this.toString() + " Run Objective Not Implemented");
    }
}

