/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.options;

import ca.ubc.cs.beta.aeatk.misc.options.DashedToCamelCaseStringConverter;
import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractOptions
implements Serializable {
    public String toString() {
        return this.toString(0);
    }

    public String toString(int initialTabs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getClass().getSimpleName()).append("]").append("\n");
        try {
            for (Field f : this.getClass().getDeclaredFields()) {
                boolean isAccessible = f.isAccessible();
                f.setAccessible(true);
                StringBuilder line = new StringBuilder();
                if (f.getAnnotation(Parameter.class) != null || f.getAnnotation(ParametersDelegate.class) != null || f.getAnnotation(DynamicParameter.class) != null) {
                    boolean isAbstractOption = false;
                    for (int i = 0; i < initialTabs; ++i) {
                        sb.append("\t");
                    }
                    line.append(f.getName());
                    line.append(" = ");
                    if (f.getName().toLowerCase().contains("password")) {
                        line.append("<<<PASSWORD CENSORED>>>");
                    } else {
                        Class<?> o = f.getType();
                        if (o.isPrimitive()) {
                            line.append(f.get(this).toString());
                        } else {
                            Object obj = f.get(this);
                            if (obj == null) {
                                line.append("null");
                            } else if (obj instanceof File) {
                                line.append(((File)obj).getAbsolutePath());
                            } else if (obj instanceof String) {
                                line.append(obj);
                            } else if (obj instanceof Long) {
                                line.append(obj.toString());
                            } else if (obj instanceof Integer) {
                                line.append(obj.toString());
                            } else if (obj instanceof Enum) {
                                line.append(((Enum)obj).name());
                            } else if (obj instanceof AbstractOptions) {
                                isAbstractOption = true;
                                line.append(((AbstractOptions)obj).toString(initialTabs + 2));
                            } else if (obj instanceof List) {
                                line.append(Arrays.toString(((List)obj).toArray()));
                            } else if (obj instanceof Map) {
                                line.append(obj.toString());
                            } else if (obj instanceof Boolean) {
                                line.append(obj.toString());
                            } else {
                                throw new IllegalArgumentException("Failed to convert type configuration option to a string " + f.getName() + "=" + obj + " type: " + o);
                            }
                        }
                    }
                    if (!isAbstractOption) {
                        sb.append(" ");
                    }
                    sb.append((CharSequence)line).append("\n");
                }
                f.setAccessible(isAccessible);
            }
            return sb.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> configToString() {
        Object o2;
        ParametersDelegate ant;
        boolean isAccessible;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : this.getClass().getDeclaredFields()) {
            isAccessible = f.isAccessible();
            f.setAccessible(true);
            if (!f.isAnnotationPresent(ParametersDelegate.class)) continue;
            ant = f.getAnnotation(ParametersDelegate.class);
            if (ant != null) {
                try {
                    o2 = f.get(this);
                    if (o2 == null) continue;
                    if (o2 instanceof AbstractOptions) {
                        list.addAll(((AbstractOptions)o2).configToString());
                        sb.append(" ").append(((AbstractOptions)o2).configToString());
                    }
                    sb.append(" ");
                }
                catch (Exception o2) {
                    // empty catch block
                }
            }
            f.setAccessible(isAccessible);
        }
        for (Field f : this.getClass().getDeclaredFields()) {
            isAccessible = f.isAccessible();
            f.setAccessible(true);
            if (!f.isAnnotationPresent(Parameter.class)) continue;
            ant = f.getAnnotation(Parameter.class);
            if (ant != null) {
                try {
                    o2 = f.get(this);
                    if (o2 == null) continue;
                    if (o2 instanceof Boolean) {
                        boolean b = (Boolean)o2;
                        if (b) {
                            list.add(ant.names()[0]);
                            sb.append(ant.names()[0]).append(" ");
                        }
                    } else if (o2 instanceof File) {
                        list.add(ant.names()[0]);
                        list.add(((File)o2).getAbsolutePath());
                        sb.append(ant.names()[0]).append(" ");
                        sb.append(((File)o2).getAbsolutePath());
                    } else if (o2 instanceof Integer) {
                        list.add(ant.names()[0]);
                        list.add(o2.toString());
                        sb.append(ant.names()[0]).append(" ");
                        sb.append(o2);
                    } else if (o2 instanceof Long) {
                        list.add(ant.names()[0]);
                        list.add(o2.toString());
                        sb.append(ant.names()[0]).append(" ");
                        sb.append(o2);
                    } else if (o2 instanceof String) {
                        sb.append(ant.names()[0]).append(" ");
                        sb.append("\"" + o2 + "\"");
                        list.add(ant.names()[0]);
                        list.add(o2.toString());
                    } else if (o2 instanceof Double) {
                        sb.append(ant.names()[0]).append(" ");
                        sb.append(o2);
                        list.add(ant.names()[0]);
                        list.add(o2.toString());
                    } else if (o2 instanceof Enum) {
                        sb.append(ant.names()[0]).append(" ");
                        sb.append(((Enum)o2).name());
                        list.add(ant.names()[0]);
                        list.add(((Enum)o2).name());
                    } else if (o2 instanceof Collection) {
                        sb.append(ant.names()[0]).append(" ");
                        sb.append("\"" + o2 + "\"");
                        list.add(ant.names()[0]);
                        list.add(o2.toString());
                    } else if (o2 instanceof AbstractOptions) {
                        list.addAll(((AbstractOptions)o2).configToString());
                        sb.append(" ").append(((AbstractOptions)o2).configToString());
                    } else {
                        System.err.println("No idea what o is " + o2.getClass() + " value:" + o2 + " name " + ant.names()[0] + ". We essentially have no way of faithfully inverting the object back to whatever cli argument generated it");
                    }
                    sb.append(" ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DynamicParameter pmap = f.getAnnotation(DynamicParameter.class);
            System.out.println(f.getName());
            if (pmap != null) {
                try {
                    Object o3 = f.get(this);
                    if (o3 == null) continue;
                    if (o3 instanceof Map) {
                        sb.append(pmap.names()[0]).append(" ");
                        sb.append(o3);
                        list.add(ant.names()[0]);
                        list.add(o3.toString());
                    } else {
                        System.err.println("No idea what o is " + o3.getClass() + " value:" + o3 + " name " + ant.names()[0] + ". We essentially have no way of faithfully inverting the object back to whatever cli argument generated it");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            f.setAccessible(isAccessible);
        }
        return list;
    }

    public void populateOptionsMap(Map<String, String> opts) {
        boolean isAccessible;
        for (Field f : this.getClass().getDeclaredFields()) {
            isAccessible = f.isAccessible();
            f.setAccessible(true);
            if (!f.isAnnotationPresent(Parameter.class)) continue;
            Parameter ant = f.getAnnotation(Parameter.class);
            if (ant != null) {
                try {
                    Object o = f.get(this);
                    if (o == null) continue;
                    if (o instanceof Boolean || o instanceof File || o instanceof Integer || o instanceof Long || o instanceof String || o instanceof Double || o instanceof Enum) {
                        for (String name : ant.names()) {
                            String camelized;
                            if (!name.startsWith("--")) continue;
                            if (!(name = name.substring(2)).contains("-")) {
                                opts.put(name, o.toString());
                            }
                            if (opts.containsKey(camelized = DashedToCamelCaseStringConverter.getCamelCase(name))) continue;
                            opts.put(camelized, o.toString());
                        }
                    } else if (!(o instanceof Collection)) {
                        if (o instanceof AbstractOptions) {
                            AbstractOptions abs = (AbstractOptions)o;
                            abs.populateOptionsMap(opts);
                        } else if (!(o instanceof Map)) {
                            System.err.println("No idea what o is " + o.getClass() + " value:" + o + " name " + ant.names()[0]);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            f.setAccessible(isAccessible);
        }
        for (Field f : this.getClass().getDeclaredFields()) {
            isAccessible = f.isAccessible();
            f.setAccessible(true);
            if (!f.isAnnotationPresent(ParametersDelegate.class)) continue;
            try {
                Object o = f.get(this);
                if (o instanceof AbstractOptions) {
                    AbstractOptions abs = (AbstractOptions)o;
                    abs.populateOptionsMap(opts);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            f.setAccessible(isAccessible);
        }
    }
}

