/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.state.legacy;

import ca.ubc.cs.beta.aeatk.state.legacy.LegacyStateFactory;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;

public class LegacyStateDirectoryScanner {
    public static void main(String[] args) {
        String path;
        File restoreDirectory;
        if (args.length != 1) {
            System.out.println("Shows what iterations are restorable for a given directory");
            System.out.println("Usage java " + LegacyStateDirectoryScanner.class.getCanonicalName() + " <directory to scan>");
            System.exit(1);
        }
        if (!(restoreDirectory = new File(path = args[0])).exists()) {
            System.err.println("[ERROR] Restore directory doesn't exist: " + restoreDirectory);
            System.exit(1);
        }
        if (!restoreDirectory.isDirectory()) {
            System.err.println("[ERROR] Restore directory isn't actually a directory: " + restoreDirectory);
            System.exit(1);
        }
        HashSet<String> filenames = new HashSet<String>();
        filenames.addAll(Arrays.asList(restoreDirectory.list()));
        System.out.println("Scanning directory " + path);
        Object[] files = restoreDirectory.listFiles();
        Arrays.sort(files);
        int i = 0;
        for (Object f : files) {
            int iteration = LegacyStateFactory.readIterationFromObjectFile((File)f);
            if (iteration == -1) continue;
            ++i;
            System.out.println(((File)f).getAbsolutePath().substring(restoreDirectory.getAbsolutePath().length() + 1) + " => Iteration " + iteration);
        }
        if (i == 0) {
            System.out.println("No complete iterations found");
        } else {
            System.out.println(i + " iterations found to restore");
        }
    }
}

