/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.ReducableSemaphore;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluator {
    private final ExecutorService execService;
    private final ReducableSemaphore semaphore;

    public AbstractSyncTargetAlgorithmEvaluator() {
        this(false);
    }

    public AbstractSyncTargetAlgorithmEvaluator(boolean unlimitedThreads) {
        if (unlimitedThreads) {
            this.execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory(this.getClass().getSimpleName() + " Abstract Blocking TAE Async Processing Thread (Cached)"));
            this.semaphore = new ReducableSemaphore(Integer.MAX_VALUE, true);
        } else {
            int procs = Runtime.getRuntime().availableProcessors();
            this.execService = Executors.newFixedThreadPool(procs, new SequentiallyNamedThreadFactory(this.getClass().getSimpleName() + " Abstract Blocking TAE Async Processing Thread (Available Processors " + Runtime.getRuntime().availableProcessors() + ")"));
            this.semaphore = new ReducableSemaphore(procs, true);
        }
    }

    public AbstractSyncTargetAlgorithmEvaluator(int aThreads) {
        if (aThreads <= 0) {
            throw new IllegalArgumentException("Number of threads must be greater than 0");
        }
        this.execService = Executors.newFixedThreadPool(aThreads, new SequentiallyNamedThreadFactory(this.getClass().getSimpleName() + " Abstract Blocking TAE Async Processing Thread (Explicit " + aThreads + ")"));
        this.semaphore = new ReducableSemaphore(aThreads, true);
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        if (runConfigs.size() == 0) {
            obs.currentStatus(Collections.emptyList());
            handler.onSuccess(Collections.emptyList());
            return;
        }
        try {
            this.semaphore.acquire();
            this.semaphore.reducePermits(runConfigs.size() - 1);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            handler.onFailure(new IllegalStateException(e1));
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        List<AlgorithmRunResult> runs = AbstractSyncTargetAlgorithmEvaluator.this.evaluateRun(runConfigs, obs);
                        handler.onSuccess(runs);
                    }
                    catch (RuntimeException e) {
                        handler.onFailure(e);
                    }
                    catch (Throwable t) {
                        handler.onFailure(new IllegalStateException("Unexpected throwable detected", t));
                        if (t instanceof Error) {
                            throw t;
                        }
                    }
                }
                finally {
                    AbstractSyncTargetAlgorithmEvaluator.this.semaphore.release(runConfigs.size());
                }
            }
        };
        if (this.areRunsPersisted()) {
            run.run();
        } else {
            this.execService.execute(run);
        }
    }

    protected abstract void subtypeShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyShutdown() {
        this.execService.shutdown();
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            boolean shutdown;
            try {
                shutdown = this.execService.awaitTermination(120L, TimeUnit.SECONDS);
                if (!shutdown) {
                    log.warn("Outstanding evaluations on Target Algorithm Evaluator did not complete within 120 seconds, will try to interrupt currently executing tasks.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting for TAE shutdown");
            }
            this.execService.shutdownNow();
            try {
                shutdown = this.execService.awaitTermination(120L, TimeUnit.SECONDS);
                if (!shutdown) {
                    LoggerFactory.getLogger(this.getClass()).warn("Outstanding evaluations on Target Algorithm Evaluator did not complete within 120 seconds, even after interruption");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting for TAE shutdown after interruption");
            }
        }
        finally {
            this.subtypeShutdown();
        }
    }
}

