/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final double scalingFactor;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, double scalingFactor) {
        super(tae);
        if (scalingFactor <= 1.0) {
            throw new ParameterException("Scaling Factor for killing cannot be less than or equal to 1.0");
        }
        if (scalingFactor < 2.0) {
            this.log.warn("Scaling factors less than 2.0 are STRONGLY discouraged, as the runtime observations we make are only very approximate.");
        }
        this.scalingFactor = scalingFactor;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        KillingTargetAlgorithmEvaluatorRunObserver kObs = new KillingTargetAlgorithmEvaluatorRunObserver(obs);
        List<AlgorithmRunResult> runs = this.tae.evaluateRun(runConfigs, kObs);
        return this.fixAlgorithmRunResults(kObs, runs);
    }

    public List<AlgorithmRunResult> fixAlgorithmRunResults(KillingTargetAlgorithmEvaluatorRunObserver kObs, List<AlgorithmRunResult> runs) {
        if (kObs.killedRuns.size() > 0) {
            runs = new ArrayList<AlgorithmRunResult>(runs);
            for (int i = 0; i < runs.size(); ++i) {
                AlgorithmRunResult run = runs.get(i);
                if (!run.getRunStatus().equals((Object)RunStatus.KILLED) || !kObs.killedRuns.contains(run.getAlgorithmRunConfiguration())) continue;
                runs.set(i, new ExistingAlgorithmRunResult(run.getAlgorithmRunConfiguration(), RunStatus.CRASHED, run.getRuntime(), run.getRunLength(), run.getQuality(), run.getResultSeed(), "Run Exceeded Captime -- Treating as " + (Object)((Object)RunStatus.CRASHED) + ";" + run.getAdditionalRunData(), run.getWallclockExecutionTime()));
            }
        }
        return runs;
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        final KillingTargetAlgorithmEvaluatorRunObserver kObs = new KillingTargetAlgorithmEvaluatorRunObserver(obs);
        TargetAlgorithmEvaluatorCallback myCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                oHandler.onSuccess(KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.fixAlgorithmRunResults(kObs, runs));
            }

            @Override
            public void onFailure(RuntimeException e) {
                oHandler.onFailure(e);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myCallback, kObs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }

    private class KillingTargetAlgorithmEvaluatorRunObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;
        final Set<AlgorithmRunConfiguration> killedRuns = Collections.newSetFromMap(new ConcurrentHashMap());

        KillingTargetAlgorithmEvaluatorRunObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            for (AlgorithmRunResult algorithmRunResult : runs) {
                if (!algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING) || !(algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime() * KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.scalingFactor < algorithmRunResult.getRuntime()) || this.killedRuns.contains(algorithmRunResult.getAlgorithmRunConfiguration())) continue;
                Object[] args = new Object[]{algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRuntime(), KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.scalingFactor, algorithmRunResult.getAlgorithmRunConfiguration().getCutoffTime()};
                if (this.killedRuns.add(algorithmRunResult.getAlgorithmRunConfiguration())) {
                    KillCaptimeExceedingRunsRunsTargetAlgorithmEvaluatorDecorator.this.log.warn("Killed run {} at {} for exceeding {} times its cutoff time of {} (secs)", args);
                }
                algorithmRunResult.kill();
            }
            if (this.obs != null) {
                this.obs.currentStatus(runs);
            }
        }
    }
}

