/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AbstractAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final double wallclockMultScaleFactor;
    private final double startAt;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
        this.wallclockMultScaleFactor = 0.95;
        this.startAt = 0.05;
    }

    public WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, double scaleFactor, double startAt) {
        super(tae);
        this.wallclockMultScaleFactor = scaleFactor;
        this.startAt = startAt;
    }

    @Override
    public final List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.processRuns(this.tae.evaluateRun(runConfigs, new WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(obs)));
    }

    public List<AlgorithmRunResult> processRuns(List<AlgorithmRunResult> runs) {
        ArrayList<AlgorithmRunResult> myRuns = new ArrayList<AlgorithmRunResult>(runs.size());
        for (AlgorithmRunResult run : runs) {
            myRuns.add(this.processRun(run));
        }
        return myRuns;
    }

    public AlgorithmRunResult processRun(AlgorithmRunResult run) {
        if (run.getRunStatus().equals((Object)RunStatus.KILLED) && run.getRuntime() == 0.0 && run.getWallclockExecutionTime() > this.startAt) {
            return new WalltimeAsRuntimeAlgorithmRun(run, this.wallclockMultScaleFactor);
        }
        return run;
    }

    @Override
    public final void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                runs = WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, new WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(obs));
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }

    private static class WalltimeAsRuntimeAlgorithmRun
    implements AlgorithmRunResult {
        private static final long serialVersionUID = 9082975671200245863L;
        AlgorithmRunResult wrappedRun;
        AlgorithmRunResult wrappedKillableRun;
        private final double wallclockMultScaleFactor;

        public WalltimeAsRuntimeAlgorithmRun(AlgorithmRunResult r, double wallClockMultScaleFactor) {
            if (r instanceof AlgorithmRunResult) {
                this.wrappedKillableRun = r;
            }
            this.wrappedRun = r;
            this.wallclockMultScaleFactor = wallClockMultScaleFactor;
        }

        @Override
        public AlgorithmRunConfiguration getAlgorithmRunConfiguration() {
            return this.wrappedRun.getAlgorithmRunConfiguration();
        }

        @Override
        public RunStatus getRunStatus() {
            return this.wrappedRun.getRunStatus();
        }

        @Override
        public double getRuntime() {
            return Math.max(this.wrappedRun.getWallclockExecutionTime() * this.wallclockMultScaleFactor, 0.0);
        }

        @Override
        public double getRunLength() {
            return this.wrappedRun.getRunLength();
        }

        @Override
        public double getQuality() {
            return this.wrappedRun.getQuality();
        }

        @Override
        public long getResultSeed() {
            return this.wrappedRun.getResultSeed();
        }

        @Override
        public String getResultLine() {
            return AbstractAlgorithmRunResult.getResultLine(this);
        }

        @Override
        public String getAdditionalRunData() {
            return this.wrappedRun.getAdditionalRunData();
        }

        @Override
        public boolean isRunCompleted() {
            return this.wrappedRun.isRunCompleted();
        }

        @Override
        public String rawResultLine() {
            return "[Probably not accurate:]" + this.wrappedRun.rawResultLine();
        }

        @Override
        public double getWallclockExecutionTime() {
            return this.wrappedRun.getWallclockExecutionTime();
        }

        @Override
        public boolean isCensoredEarly() {
            return this.getRunStatus().equals((Object)RunStatus.TIMEOUT) && this.getAlgorithmRunConfiguration().hasCutoffLessThanMax() || this.getRunStatus().equals((Object)RunStatus.KILLED) && this.getRuntime() < this.getAlgorithmRunConfiguration().getCutoffTime();
        }

        @Override
        public void kill() {
            if (this.wrappedKillableRun != null) {
                this.wrappedKillableRun.kill();
            }
        }

        public String toString() {
            return AbstractAlgorithmRunResult.toString(this);
        }

        @Override
        public ParameterConfiguration getParameterConfiguration() {
            return this.wrappedRun.getParameterConfiguration();
        }

        @Override
        public AlgorithmExecutionConfiguration getAlgorithmExecutionConfiguration() {
            return this.wrappedRun.getAlgorithmExecutionConfiguration();
        }

        @Override
        public ProblemInstanceSeedPair getProblemInstanceSeedPair() {
            return this.wrappedRun.getProblemInstanceSeedPair();
        }

        @Override
        public ProblemInstance getProblemInstance() {
            return this.wrappedRun.getProblemInstance();
        }
    }

    private class WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private TargetAlgorithmEvaluatorRunObserver obs;

        WalltimeAsRuntimeTargetAlgorithmEvaluatorObserver(TargetAlgorithmEvaluatorRunObserver obs) {
            this.obs = obs;
        }

        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            ArrayList<AlgorithmRunResult> myRuns = new ArrayList<AlgorithmRunResult>(runs.size());
            for (AlgorithmRunResult algorithmRunResult : runs) {
                if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING)) {
                    if (algorithmRunResult.getRuntime() == 0.0 && algorithmRunResult.getWallclockExecutionTime() > WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.startAt) {
                        myRuns.add(new WalltimeAsRuntimeAlgorithmRun(algorithmRunResult, WalltimeAsRuntimeTargetAlgorithmEvaluatorDecorator.this.wallclockMultScaleFactor));
                        continue;
                    }
                    myRuns.add(algorithmRunResult);
                    continue;
                }
                myRuns.add(algorithmRunResult);
            }
            if (this.obs != null) {
                this.obs.currentStatus(myRuns);
            }
        }
    }
}

