/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aeatk.concurrent.FairMultiPermitSemaphore;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmEvaluatorShutdownException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BoundedTargetAlgorithmEvaluator
extends AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator {
    private final ReentrantLock enqueueLock = new ReentrantLock(true);
    private final FairMultiPermitSemaphore availableRuns;
    private static final Logger log = LoggerFactory.getLogger(BoundedTargetAlgorithmEvaluator.class);
    private final ExecutorService execService = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Bounded Target Algorithm Evaluator Callback Thread"));
    private final int NUMBER_OF_CONCURRENT_RUNS;
    public static final String KILLED_BY_DECORATOR_ADDL_RUN_INFO = "Kill intercepted by decorator before dispatch to TAE";

    public BoundedTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae, int numberOfConcurrentRuns) {
        super(tae);
        if (numberOfConcurrentRuns <= 0) {
            throw new IllegalArgumentException("Must be able to schedule at least one run");
        }
        this.availableRuns = new FairMultiPermitSemaphore(numberOfConcurrentRuns);
        this.NUMBER_OF_CONCURRENT_RUNS = numberOfConcurrentRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        if (runConfigs.isEmpty()) {
            handler.onSuccess(Collections.emptyList());
            return;
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
            handler.onFailure(new TargetAlgorithmEvaluatorShutdownException(new InterruptedException()));
            return;
        }
        if (this.enqueueLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Current Thread already holds the lock");
        }
        try {
            int killInterceptedCount;
            this.enqueueLock.lock();
            ConcurrentHashMap<AlgorithmRunConfiguration, Integer> orderOfRuns = new ConcurrentHashMap<AlgorithmRunConfiguration, Integer>();
            Set<AlgorithmRunResult> completedRuns = Collections.newSetFromMap(new ConcurrentHashMap());
            ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> outstandingRuns = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
            ConcurrentHashMap<AlgorithmRunConfiguration, KillHandler> killHandlers = new ConcurrentHashMap<AlgorithmRunConfiguration, KillHandler>();
            for (int i = 0; i < runConfigs.size(); ++i) {
                AlgorithmRunConfiguration rc = runConfigs.get(i);
                orderOfRuns.put(rc, i);
                StatusVariableKillHandler kh = new StatusVariableKillHandler();
                killHandlers.put(rc, kh);
                outstandingRuns.put(runConfigs.get(i), new RunningAlgorithmRunResult(rc, 0.0, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), 0.0, kh));
            }
            AtomicBoolean completionCallbackFired = new AtomicBoolean(false);
            int totalRunsNeeded = runConfigs.size();
            AtomicBoolean failureOccured = new AtomicBoolean(false);
            AtomicLong lastUpdate = new AtomicLong(0L);
            for (int numberOfDispatchedRuns = 0; numberOfDispatchedRuns < runConfigs.size() && !failureOccured.get(); numberOfDispatchedRuns += killInterceptedCount) {
                int index;
                int oNumRunConfigToRun;
                if (this.availableRuns.availablePermits() > this.NUMBER_OF_CONCURRENT_RUNS) {
                    throw new IllegalStateException("Somehow I now have more permits than I should be limited to");
                }
                log.trace("Asking for permission for {} things config id of first: ({})", (Object)(runConfigs.size() - numberOfDispatchedRuns), (Object)runConfigs.get(0).getParameterConfiguration().getFriendlyIDHex());
                try {
                    oNumRunConfigToRun = this.availableRuns.getUpToNPermits(runConfigs.size() - numberOfDispatchedRuns);
                }
                catch (InterruptedException e) {
                    log.debug("Thread was interrupted while waiting, aborting execution for runs with config id of first: ({})", (Object)runConfigs.get(0).getParameterConfiguration().getFriendlyIDHex());
                    completionCallbackFired.set(true);
                    failureOccured.set(true);
                    handler.onFailure(new TargetAlgorithmEvaluatorShutdownException(e));
                    Thread.currentThread().interrupt();
                    this.enqueueLock.unlock();
                    return;
                }
                int numRunConfigToRun = oNumRunConfigToRun;
                log.trace("Asked for permission to run {} things, got permission to run {} things, total completed for this batch {}  config id of first: ({})", new Object[]{runConfigs.size() - numberOfDispatchedRuns, numRunConfigToRun, numberOfDispatchedRuns, runConfigs.get(0).getParameterConfiguration().getFriendlyIDHex()});
                ArrayList<AlgorithmRunConfiguration> runsToDo = new ArrayList<AlgorithmRunConfiguration>(numRunConfigToRun);
                killInterceptedCount = 0;
                int numberOfRunToSelect = 0;
                while (runsToDo.size() < numRunConfigToRun && (index = numberOfDispatchedRuns + numberOfRunToSelect + killInterceptedCount) < runConfigs.size()) {
                    AlgorithmRunConfiguration possibleRC = runConfigs.get(index);
                    if (index < runConfigs.size() - 1 && ((KillHandler)killHandlers.get(possibleRC)).isKilled()) {
                        log.trace("Run {} was killed already not dispatching, marking killed", (Object)possibleRC);
                        ++killInterceptedCount;
                        ExistingAlgorithmRunResult completedRun = new ExistingAlgorithmRunResult(possibleRC, RunStatus.KILLED, 0.0, 0.0, 0.0, possibleRC.getProblemInstanceSeedPair().getSeed(), KILLED_BY_DECORATOR_ADDL_RUN_INFO, 0.0);
                        outstandingRuns.put(possibleRC, completedRun);
                        completedRuns.add(completedRun);
                        continue;
                    }
                    runsToDo.add(possibleRC);
                    ++numberOfRunToSelect;
                }
                numRunConfigToRun = runsToDo.size();
                if (oNumRunConfigToRun != numRunConfigToRun) {
                    log.debug("Runs have been killed preemptively total {} permits immediately available are {}", (Object)(oNumRunConfigToRun - numRunConfigToRun), (Object)this.availableRuns.availablePermits());
                    this.availableRuns.releasePermits(oNumRunConfigToRun - numRunConfigToRun);
                }
                if (runsToDo.size() == 0) {
                    throw new IllegalStateException("Runs to do size is now zero, this is a bug and this state is irrecoverable, sorry.");
                }
                AtomicInteger completedCount = new AtomicInteger(0);
                AtomicInteger releaseCount = new AtomicInteger(0);
                SubListTargetAlgorithmEvaluatorCallback callBack = new SubListTargetAlgorithmEvaluatorCallback(this.availableRuns, numRunConfigToRun, runConfigs, handler, failureOccured, totalRunsNeeded, completedRuns, orderOfRuns, completionCallbackFired, this.execService, completedCount, releaseCount);
                BoundedTargetAlgorithmEvaluatorMapUpdateObserver updateMapObserver = new BoundedTargetAlgorithmEvaluatorMapUpdateObserver(this.availableRuns, numRunConfigToRun, runConfigs, obs, outstandingRuns, orderOfRuns, killHandlers, completionCallbackFired, this.execService, completedCount, releaseCount, lastUpdate);
                this.tae.evaluateRunsAsync(runsToDo, callBack, updateMapObserver);
                numberOfDispatchedRuns += numRunConfigToRun;
            }
        }
        finally {
            this.enqueueLock.unlock();
        }
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        this.execService.shutdown();
        try {
            this.execService.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            log.warn("Thread shutdown interrupted");
            Thread.currentThread().interrupt();
            return;
        }
    }

    static class SubListTargetAlgorithmEvaluatorCallback
    implements TargetAlgorithmEvaluatorCallback {
        private final FairMultiPermitSemaphore availableRunsSemaphore;
        private final int numRunConfigToRun;
        private final List<AlgorithmRunConfiguration> runConfigs;
        private final TargetAlgorithmEvaluatorCallback calleeCallback;
        private final AtomicBoolean failureOccured;
        private final Set<AlgorithmRunResult> completedRuns;
        private final int totalRunsNeeded;
        private final Map<AlgorithmRunConfiguration, Integer> orderOfRuns;
        private final AtomicBoolean completionCallbackFired;
        private final ExecutorService execService;
        private final AtomicInteger completedCount;
        private final AtomicInteger runPermitsReleased;

        public SubListTargetAlgorithmEvaluatorCallback(FairMultiPermitSemaphore availableRunsSemaphore, int numRunConfigToRun, List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorCallback calleeCallback, AtomicBoolean failureOccured, int totalRunsNeeded, Set<AlgorithmRunResult> completedRuns, Map<AlgorithmRunConfiguration, Integer> orderOfRuns, AtomicBoolean onSuccessFired, ExecutorService execService, AtomicInteger completedCount, AtomicInteger releaseCount) {
            this.availableRunsSemaphore = availableRunsSemaphore;
            this.numRunConfigToRun = numRunConfigToRun;
            this.runConfigs = runConfigs;
            this.calleeCallback = calleeCallback;
            this.failureOccured = failureOccured;
            this.completedRuns = completedRuns;
            this.totalRunsNeeded = totalRunsNeeded;
            this.orderOfRuns = orderOfRuns;
            this.completionCallbackFired = onSuccessFired;
            this.execService = execService;
            this.completedCount = completedCount;
            this.runPermitsReleased = releaseCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseRemaining(int completedSize) {
            List<AlgorithmRunConfiguration> list = this.runConfigs;
            synchronized (list) {
                int previousCompletedCount = this.completedCount.get();
                if (previousCompletedCount > completedSize) {
                    throw new IllegalStateException("Somehow I determined that there were " + this.completedCount.get() + " but previously we detected: " + previousCompletedCount);
                }
                this.completedCount.set(completedSize);
                int releasesNeeded = this.completedCount.get() - this.runPermitsReleased.get();
                if (releasesNeeded < 0) {
                    throw new IllegalStateException("Somehow I have gotten to a state where I need to take back some releases completed:" + this.completedCount.get() + " releaseCount: " + this.runPermitsReleased.get());
                }
                this.runPermitsReleased.addAndGet(releasesNeeded);
                this.availableRunsSemaphore.releasePermits(releasesNeeded);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(List<AlgorithmRunResult> runs) {
            List<AlgorithmRunConfiguration> list = this.runConfigs;
            synchronized (list) {
                this.releaseRemaining(this.numRunConfigToRun);
                if (this.failureOccured.get()) {
                    this.completionCallbackFired.set(true);
                    log.debug("Failure occured, silently discarding runs: {}", runs);
                    return;
                }
                this.completedRuns.addAll(runs);
                if (this.totalRunsNeeded == this.completedRuns.size()) {
                    this.completionCallbackFired.set(true);
                    final ArrayList<AlgorithmRunResult> allRuns = new ArrayList<AlgorithmRunResult>(this.completedRuns.size());
                    for (int i = 0; i < this.completedRuns.size(); ++i) {
                        allRuns.add(runs.get(0));
                    }
                    for (AlgorithmRunResult run : this.completedRuns) {
                        int index = this.orderOfRuns.get(run.getAlgorithmRunConfiguration());
                        allRuns.set(index, run);
                    }
                    this.execService.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                List list = SubListTargetAlgorithmEvaluatorCallback.this.runConfigs;
                                synchronized (list) {
                                    try {
                                        SubListTargetAlgorithmEvaluatorCallback.this.calleeCallback.onSuccess(allRuns);
                                    }
                                    catch (RuntimeException e) {
                                        SubListTargetAlgorithmEvaluatorCallback.this.calleeCallback.onFailure(e);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                log.error("Unknown exception occured ", t);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(final RuntimeException t) {
            List<AlgorithmRunConfiguration> list = this.runConfigs;
            synchronized (list) {
                this.releaseRemaining(this.numRunConfigToRun);
                this.completionCallbackFired.set(true);
                if (this.failureOccured.get()) {
                    log.debug("Failure occured already, silently discarding subsequent failures");
                }
                this.failureOccured.set(true);
                this.execService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            List list = SubListTargetAlgorithmEvaluatorCallback.this.runConfigs;
                            synchronized (list) {
                                SubListTargetAlgorithmEvaluatorCallback.this.calleeCallback.onFailure(t);
                            }
                        }
                        catch (Throwable t2) {
                            log.error("Unknown exception occured ", t2);
                        }
                    }
                });
            }
        }
    }

    static class BoundedTargetAlgorithmEvaluatorMapUpdateObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private final FairMultiPermitSemaphore availableRuns;
        private final List<AlgorithmRunConfiguration> runConfigs;
        private final TargetAlgorithmEvaluatorRunObserver callerRunObserver;
        private final Map<AlgorithmRunConfiguration, AlgorithmRunResult> outstandingRuns;
        private final Map<AlgorithmRunConfiguration, Integer> orderOfRuns;
        private final Map<AlgorithmRunConfiguration, KillHandler> killHandlers;
        private final AtomicBoolean completedCallbackFired;
        private final ExecutorService cachedThreadPool;
        private final AtomicInteger completedCount;
        private final AtomicInteger releaseCount;
        private final int numRunConfigToRun;
        private AtomicLong lastUpdate;

        BoundedTargetAlgorithmEvaluatorMapUpdateObserver(FairMultiPermitSemaphore availableRuns, int numRunConfigToRun, List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver callerRunObserver, Map<AlgorithmRunConfiguration, AlgorithmRunResult> outstandingRuns, Map<AlgorithmRunConfiguration, Integer> orderOfRuns, Map<AlgorithmRunConfiguration, KillHandler> killHandlers, AtomicBoolean onSuccessFired, ExecutorService cachedThreadPool, AtomicInteger completedCount, AtomicInteger releaseCount, AtomicLong lastUpdate) {
            this.numRunConfigToRun = numRunConfigToRun;
            this.availableRuns = availableRuns;
            this.runConfigs = runConfigs;
            this.callerRunObserver = callerRunObserver;
            this.outstandingRuns = outstandingRuns;
            this.orderOfRuns = orderOfRuns;
            this.killHandlers = killHandlers;
            this.completedCallbackFired = onSuccessFired;
            this.cachedThreadPool = cachedThreadPool;
            this.completedCount = completedCount;
            this.releaseCount = releaseCount;
            this.lastUpdate = lastUpdate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            if (runs.size() != this.numRunConfigToRun) {
                log.error("Um what");
                throw new IllegalStateException("Runs seem to have disappeared, I was expecting to observer " + this.numRunConfigToRun + " but only saw " + runs.size());
            }
            List<AlgorithmRunConfiguration> list = this.runConfigs;
            synchronized (list) {
                int i;
                if (this.completedCallbackFired.get()) {
                    return;
                }
                int completedRuns = 0;
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    this.outstandingRuns.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                    if (!algorithmRunResult.isRunCompleted()) continue;
                    ++completedRuns;
                }
                int previousCompletedCount = this.completedCount.get();
                if (previousCompletedCount > completedRuns) {
                    IllegalStateException illegalStateException = new IllegalStateException("Somehow I determined that there were " + completedRuns + " but previously we detected: " + previousCompletedCount);
                    throw illegalStateException;
                }
                this.completedCount.set(completedRuns);
                int n = this.completedCount.get() - this.releaseCount.get();
                if (n < 0) {
                    throw new IllegalStateException("Somehow I have gotten to a state where I need to take back some releases completed:" + completedRuns + " releaseCount: " + this.releaseCount.get());
                }
                this.releaseCount.addAndGet(n);
                this.availableRuns.releasePermits(n);
                final ArrayList<AlgorithmRunResult> allRunsForCaller = new ArrayList<AlgorithmRunResult>();
                if (this.runConfigs.size() != this.outstandingRuns.size()) {
                    throw new IllegalStateException("Expected " + this.runConfigs.size() + " to equal " + this.outstandingRuns.size());
                }
                for (i = 0; i < this.runConfigs.size(); ++i) {
                    allRunsForCaller.add(runs.get(0));
                }
                for (i = 0; i < this.runConfigs.size(); ++i) {
                    AlgorithmRunResult algoRun = this.outstandingRuns.get(this.runConfigs.get(i));
                    allRunsForCaller.set(this.orderOfRuns.get(this.runConfigs.get(i)), algoRun);
                }
                for (Map.Entry<AlgorithmRunConfiguration, KillHandler> ent : this.killHandlers.entrySet()) {
                    if (!ent.getValue().isKilled()) continue;
                    this.outstandingRuns.get(ent.getKey()).kill();
                }
                final long currentTime = System.currentTimeMillis();
                if (this.callerRunObserver != null) {
                    this.cachedThreadPool.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List list = BoundedTargetAlgorithmEvaluatorMapUpdateObserver.this.runConfigs;
                            synchronized (list) {
                                long lastUpdateValue = BoundedTargetAlgorithmEvaluatorMapUpdateObserver.this.lastUpdate.get();
                                if (lastUpdateValue >= currentTime) {
                                    return;
                                }
                                if (!BoundedTargetAlgorithmEvaluatorMapUpdateObserver.this.lastUpdate.compareAndSet(lastUpdateValue, currentTime)) {
                                    throw new IllegalStateException("Inappropriate Synchronization detected on lastUpdate. All updates should have been guarded by a lock on runConfigs but somehow the value has changed");
                                }
                                if (BoundedTargetAlgorithmEvaluatorMapUpdateObserver.this.completedCallbackFired.get()) {
                                    return;
                                }
                                try {
                                    BoundedTargetAlgorithmEvaluatorMapUpdateObserver.this.callerRunObserver.currentStatus(allRunsForCaller);
                                }
                                catch (Throwable t) {
                                    log.error("UNCAUGHT EXCEPTION: Error occured while notifying observer ", t);
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

