/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.caching;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.concurrent.ReducableSemaphore;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.logging.CommonMarkers;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CachingTargetAlgorithmEvaluatorDecorator
extends AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger cacheRequests = new AtomicInteger(0);
    private final AtomicInteger cacheRequestMisses = new AtomicInteger(0);
    private final AtomicInteger submittedToDecoratee = new AtomicInteger(0);
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final LinkedBlockingQueue<List<AlgorithmRunConfiguration>> submissionQueue = new LinkedBlockingQueue();
    private final Executor submissionExecService = Executors.newFixedThreadPool(AVAILABLE_PROCESSORS, new SequentiallyNamedThreadFactory("Caching Target Algorithm Evaulator Submission Thread"));
    private final LinkedBlockingQueue<EvaluationRequestToken> tokenToCallbackQueue = new LinkedBlockingQueue();
    private final Executor callbackExecService = Executors.newFixedThreadPool(AVAILABLE_PROCESSORS, new SequentiallyNamedThreadFactory("Caching Target Algorithm Evaulator Callback Thread"));
    private final LinkedBlockingQueue<EvaluationRequestToken> tokenToObserverQueue = new LinkedBlockingQueue();
    private final Executor observerExecService = Executors.newFixedThreadPool(AVAILABLE_PROCESSORS, new SequentiallyNamedThreadFactory("Caching Target Algorithm Evaulator Observer Thread"));
    private final ConcurrentHashMap<AlgorithmRunConfiguration, ReducableSemaphore> runConfigsSubmittedToWrappedDecoratorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, Set<AlgorithmRunConfiguration>> outstandingRunsForTokenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, AtomicInteger> outstandingRunsCountForTokenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, List<AlgorithmRunConfiguration>> allRunConfigsForTokenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, Set<EvaluationRequestToken>> runConfigToTokenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, TargetAlgorithmEvaluatorCallback> evalRequestToCallbackMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, TargetAlgorithmEvaluatorRunObserver> evalRequestToObserverMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AtomicBoolean> outstandingRunConfigMap = new ConcurrentHashMap();
    private final Set<AlgorithmRunConfiguration> completedRunConfigs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> completedRunsMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, RuntimeException> completedExceptionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> killedRunsMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<EvaluationRequestToken, Set<AlgorithmRunConfiguration>> killedRunsForToken = new ConcurrentHashMap();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AtomicInteger> runConfigToInterestedEvaluationsCounter = new ConcurrentHashMap();
    private static final NullTargetAlgorithmEvaluatorRunObserver NULL_OBSERVER = new NullTargetAlgorithmEvaluatorRunObserver();
    private final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> runConfigToLiveLatestStatusMap = new ConcurrentHashMap();
    private final boolean shutdownOnError;
    private final AtomicReference<RuntimeException> storedException = new AtomicReference();
    private final AtomicBoolean errorDetected = new AtomicBoolean(false);
    private final boolean notifyCallbacksOnError = false;
    private final Thread debugThread;

    public CachingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        this(tae, false);
    }

    public CachingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, boolean logDebugMessages) {
        super(tae);
        this.shutdownOnError = true;
        for (int i = 0; i < AVAILABLE_PROCESSORS; ++i) {
            this.submissionExecService.execute(new RunSubmitter());
            this.callbackExecService.execute(new CallbackInvoker());
            this.observerExecService.execute(new ObserverInvoker());
        }
        this.debugThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(60000L);
                            }
                        }
                        finally {
                            CachingTargetAlgorithmEvaluatorDecorator.this.debugMessage();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
        if (logDebugMessages) {
            this.debugThread.setDaemon(true);
            this.debugThread.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> rcs, TargetAlgorithmEvaluatorCallback callback, TargetAlgorithmEvaluatorRunObserver observer) {
        try {
            if (this.shutdownOnError && this.errorDetected.get()) {
                return;
            }
            if (rcs.isEmpty()) {
                callback.onSuccess(Collections.emptyList());
                return;
            }
            if (new HashSet<AlgorithmRunConfiguration>(rcs).size() != rcs.size()) {
                throw new IllegalArgumentException("Run Configurations list has duplicates in it, this isn't legal");
            }
            List<AlgorithmRunConfiguration> runConfigs = Collections.unmodifiableList(rcs);
            if (observer == null) {
                observer = NULL_OBSERVER;
            }
            TargetAlgorithmEvaluatorRunObserver obs = observer;
            EvaluationRequestToken evalToken = new EvaluationRequestToken();
            this.evalRequestToCallbackMap.put(evalToken, callback);
            this.evalRequestToObserverMap.put(evalToken, obs);
            Set outstandingRunsForTokenSet = Collections.newSetFromMap(new ConcurrentHashMap());
            AtomicInteger outstandingRunsCountForToken = new AtomicInteger(rcs.size());
            outstandingRunsForTokenSet.addAll(runConfigs);
            this.outstandingRunsForTokenMap.put(evalToken, outstandingRunsForTokenSet);
            this.outstandingRunsCountForTokenMap.put(evalToken, outstandingRunsCountForToken);
            this.allRunConfigsForTokenMap.put(evalToken, runConfigs);
            this.killedRunsForToken.put(evalToken, Collections.newSetFromMap(new ConcurrentHashMap()));
            ArrayList<AlgorithmRunConfiguration> runConfigsCurrentThreadSubmits = new ArrayList<AlgorithmRunConfiguration>(runConfigs.size());
            ReducableSemaphore runsSubmittedToWrappedTAECompletedSemaphore = new ReducableSemaphore(0);
            Set callbacksForRunConfig = Collections.newSetFromMap(new ConcurrentHashMap());
            for (AlgorithmRunConfiguration rc : runConfigs) {
                Set oSet;
                Semaphore value = this.runConfigsSubmittedToWrappedDecoratorMap.putIfAbsent(rc, runsSubmittedToWrappedTAECompletedSemaphore);
                if (value == null) {
                    runConfigsCurrentThreadSubmits.add(rc);
                    runsSubmittedToWrappedTAECompletedSemaphore = new ReducableSemaphore(0);
                    this.outstandingRunConfigMap.putIfAbsent(rc, new AtomicBoolean(true));
                }
                this.runConfigToLiveLatestStatusMap.putIfAbsent(rc, new RunningAlgorithmRunResult(rc, 0.0, 0.0, 0.0, rc.getProblemInstanceSeedPair().getSeed(), 0.0, new NullKillHandler()));
                AtomicInteger oldValue = this.runConfigToInterestedEvaluationsCounter.putIfAbsent(rc, new AtomicInteger(1));
                if (oldValue != null) {
                    this.runConfigToInterestedEvaluationsCounter.get(rc).incrementAndGet();
                }
                if ((oSet = this.runConfigToTokenMap.putIfAbsent(rc, callbacksForRunConfig)) == null) {
                    oSet = callbacksForRunConfig;
                    callbacksForRunConfig = Collections.newSetFromMap(new ConcurrentHashMap());
                }
                oSet.add(evalToken);
            }
            int requests = this.cacheRequests.addAndGet(runConfigs.size());
            int misses = this.cacheRequestMisses.addAndGet(runConfigsCurrentThreadSubmits.size());
            NumberFormat nf = NumberFormat.getPercentInstance();
            this.log.trace("Cache Local misses: {}, Local request: {},  Global misses {}, Global Requests {}, Hit Rate {} ", new Object[]{runConfigsCurrentThreadSubmits.size(), runConfigs.size(), misses, requests, nf.format(((double)requests - (double)misses) / (double)requests)});
            if (runConfigsCurrentThreadSubmits.size() > 0) {
                this.submissionQueue.add(runConfigsCurrentThreadSubmits);
            }
            this.log.trace("Token {} submitted with outstanding runs: {} map size {}: {}", new Object[]{evalToken, outstandingRunsCountForToken.get(), outstandingRunsForTokenSet.size(), outstandingRunsForTokenSet});
            for (AlgorithmRunConfiguration rc : runConfigs) {
                try {
                    this.runConfigsSubmittedToWrappedDecoratorMap.get(rc).acquire();
                    this.runConfigsSubmittedToWrappedDecoratorMap.get(rc).release();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.log.trace("Token {} has completed submission: {} map size{} :{}", new Object[]{evalToken, outstandingRunsCountForToken.get(), outstandingRunsForTokenSet.size(), outstandingRunsForTokenSet});
            for (AlgorithmRunConfiguration rc : runConfigs) {
                if (!this.completedRunConfigs.contains(rc) && !this.killedRunsMap.containsKey(rc) || !this.processRunConfigurationForRequestToken(evalToken, rc)) continue;
                try {
                    this.runConfigsSubmittedToWrappedDecoratorMap.get(rc).acquire();
                    this.runConfigsSubmittedToWrappedDecoratorMap.get(rc).release();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            if (!this.errorDetected.compareAndSet(false, true)) throw e;
            this.storedException.set(e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        int misses = this.cacheRequestMisses.get();
        int requests = this.cacheRequests.get();
        int submittedToNextTAE = this.submittedToDecoratee.get();
        this.log.info("Cache misses {}, Submitted to Decoratee: {}, Cache requests {}, Hit Rate {} ", new Object[]{misses, submittedToNextTAE, requests, nf.format(((double)requests - (double)misses) / (double)requests)});
        this.debugThread.interrupt();
    }

    private final boolean processRunConfigurationForRequestToken(EvaluationRequestToken token, AlgorithmRunConfiguration rc) {
        if (this.shutdownOnError && this.errorDetected.get()) {
            return false;
        }
        Set<AlgorithmRunConfiguration> outstandingRunsForCallback = this.outstandingRunsForTokenMap.get(token);
        if (outstandingRunsForCallback == null) {
            return false;
        }
        this.log.trace("Token {} called for {} , map has {} elements {} ", new Object[]{token, rc, outstandingRunsForCallback.size(), outstandingRunsForCallback});
        this.log.trace("Token {} called for {} still running ", (Object)token, (Object)rc);
        boolean rcRemoved = outstandingRunsForCallback.remove(rc);
        if (rcRemoved) {
            boolean runIsMarkedCompleted = this.completedRunConfigs.contains(rc);
            boolean tokensKilledRunsContainRC = this.killedRunsForToken.get(token).contains(rc);
            if (!runIsMarkedCompleted && !tokensKilledRunsContainRC) {
                if (!this.killedRunsMap.containsKey(rc)) {
                    this.log.error("Run not completed, but not killed either token: {} run {}", (Object)token, (Object)rc);
                    this.log.error("Error", this.killedRunsMap);
                    if (this.shutdownOnError) {
                        throw new IllegalStateException("Run not completed, but not killed either:" + rc + " token: " + token + " " + runIsMarkedCompleted + "," + tokensKilledRunsContainRC);
                    }
                } else {
                    ReducableSemaphore semi = this.runConfigsSubmittedToWrappedDecoratorMap.get(rc);
                    boolean shouldResubmit = semi.tryAcquire();
                    outstandingRunsForCallback.add(rc);
                    if (shouldResubmit) {
                        boolean changedToOutstanding = this.outstandingRunConfigMap.get(rc).compareAndSet(false, true);
                        if (changedToOutstanding) {
                            this.log.debug("Run was killed but caller: {} didn't expect it to be so, rescheduling.", (Object)rc);
                            this.submissionQueue.add(Collections.singletonList(rc));
                        } else {
                            semi.release();
                        }
                    } else {
                        this.log.debug("Run was killed but caller: {} didn't expect it to be so. Run will be rescheduled by someone else.", (Object)rc);
                    }
                }
                return true;
            }
            int remaining = this.outstandingRunsCountForTokenMap.get(token).decrementAndGet();
            this.log.trace("Remaining runs for {} are {} after removing {}", new Object[]{token, remaining, rc});
            if (remaining < 0) {
                this.log.error("Desynchronization detected as the number of remaining elements seems to be less than zero for token: {} and rc: {}", (Object)token, (Object)rc);
                if (this.shutdownOnError) {
                    throw new IllegalStateException("Desynchronization error as the number of remaining elements is less than zero:" + rc + " token: " + token);
                }
            }
            if (remaining == 0) {
                try {
                    this.tokenToCallbackQueue.add(token);
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    this.log.error("Exception occurred while adding stuff for callback", (Throwable)e);
                    throw e;
                }
            }
        } else {
            this.log.trace("Token {} called for {} was spurious ", (Object)token, (Object)rc);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void notifyObserverOfToken(EvaluationRequestToken token) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void debugMessage() {
        StringBuilder sb = new StringBuilder();
        String banner = "====================";
        sb.append(banner).append("[ " + this.getClass().getSimpleName() + " Status ]").append(banner);
        sb.append("\nDecorated TAE Reports:" + this.tae.getNumberOfOutstandingBatches() + " Batches, " + this.tae.getNumberOfOutstandingRuns() + " runs");
        sb.append("\nOutstanding RunConfigs: ");
        try {
            int count = 0;
            for (Map.Entry<AlgorithmRunConfiguration, AtomicBoolean> entry : this.outstandingRunConfigMap.entrySet()) {
                if (!entry.getValue().get()) continue;
                if (++count < 5) {
                    sb.append(entry.getKey() + ",");
                    continue;
                }
                if (count != 5) continue;
                sb.append("...");
            }
            sb.append("\nOutstanding RunConfigs count:" + count);
            sb.append("\nOutstanding Evaluations (from outstandingRunsCountForTokenMap): ").append(this.outstandingRunsCountForTokenMap.size());
            if (this.outstandingRunsCountForTokenMap.size() < 200) {
                sb.append("Outstanding Tokens to Size Display:");
                for (Map.Entry<Object, Serializable> entry : this.outstandingRunsCountForTokenMap.entrySet()) {
                    sb.append("\n" + entry.getKey() + "=> " + entry.getValue());
                    sb.append("  Specific Runs Size: " + this.outstandingRunsForTokenMap.get(entry.getKey()).size());
                    if (this.outstandingRunsForTokenMap.get(entry.getKey()).size() < 5) {
                        sb.append("\n Outstanding Runs for Token :" + this.outstandingRunsForTokenMap.get(entry.getKey()));
                    }
                    sb.append("\n" + this.outstandingRunsForTokenMap.get(entry.getKey()));
                    for (AlgorithmRunConfiguration rc : this.outstandingRunsForTokenMap.get(entry.getKey())) {
                        sb.append("\n " + rc + "=>");
                        if (this.completedRunConfigs.contains(rc)) {
                            if (this.completedExceptionMap.get(rc) != null) {
                                sb.append("RunConfig has Error?:" + this.completedExceptionMap.get(rc));
                                continue;
                            }
                            if (this.completedRunsMap.get(rc) != null) {
                                sb.append("Outstanding RunConfig Completed?:" + this.completedExceptionMap.get(rc));
                                continue;
                            }
                            if (this.killedRunsMap.get(rc) != null) {
                                sb.append("Run Config is killed, and completed:?" + this.killedRunsMap.get(rc));
                                continue;
                            }
                            sb.append("No idea where the completed run is?");
                            continue;
                        }
                        if (this.killedRunsMap.get(rc) != null) {
                            sb.append("==> Killed properly " + this.killedRunsMap.get(rc));
                            sb.append(this.killedRunsForToken.get(entry.getKey()).contains(rc) ? "[Expected to be killed]" : "[Didn't want killed]");
                            sb.append("Interested parties:" + this.runConfigToInterestedEvaluationsCounter.get(rc));
                            continue;
                        }
                        if (this.outstandingRunConfigMap.get(rc).get()) {
                            sb.append("Still outstanding.");
                            continue;
                        }
                        sb.append("Not outstanding, yet no where to be found");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            sb.append("Error occurred trying to make debug information ");
            e.printStackTrace();
        }
        System.err.println(sb.toString());
        this.log.info(CommonMarkers.SKIP_CONSOLE_PRINTING, sb.toString());
    }

    @Override
    public boolean isRunFinal() {
        return true;
    }

    private static final class NullKillHandler
    implements KillHandler {
        private NullKillHandler() {
        }

        @Override
        public void kill() {
            throw new IllegalStateException("Wasn't expecting this to be called");
        }

        @Override
        public boolean isKilled() {
            throw new IllegalStateException("Wasn't expecting this to be called");
        }
    }

    private final class ExternalCallerKillHandler
    implements KillHandler {
        private final EvaluationRequestToken token;
        private final AlgorithmRunConfiguration rc;

        private ExternalCallerKillHandler(EvaluationRequestToken token, AlgorithmRunConfiguration rc) {
            this.token = token;
            this.rc = rc;
        }

        @Override
        public void kill() {
            if (((Set)CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsForToken.get(this.token)).add(this.rc)) {
                CachingTargetAlgorithmEvaluatorDecorator.this.log.debug("Run {} has been killed for token: {}", (Object)this.rc, (Object)this.token);
                int remainingInterestedJobs = ((AtomicInteger)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToInterestedEvaluationsCounter.get(this.rc)).decrementAndGet();
                if (remainingInterestedJobs <= 0 && remainingInterestedJobs != 0) {
                    IllegalStateException e = new IllegalStateException("Interested parties is seemingly negative for runConfig:" + this.rc + " value " + remainingInterestedJobs);
                    if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        }

        @Override
        public boolean isKilled() {
            try {
                return ((Set)CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsForToken.get(this.token)).contains(this.rc);
            }
            catch (RuntimeException e) {
                if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                    e.printStackTrace();
                }
                return false;
            }
        }
    }

    private static final class NullTargetAlgorithmEvaluatorRunObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private NullTargetAlgorithmEvaluatorRunObserver() {
        }

        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
        }
    }

    private static final class EvaluationRequestToken {
        private final ReentrantLock lock = new ReentrantLock();
        private final AtomicBoolean callbackFired = new AtomicBoolean();
        private final AtomicLong lastChangeUpdate = new AtomicLong(0L);
        private final AtomicLong lastNotification = new AtomicLong(0L);

        private EvaluationRequestToken() {
        }

        public boolean callbackFired() {
            return this.callbackFired.get();
        }

        public void fireCallback() {
            this.callbackFired.set(true);
        }

        public boolean tryLock() {
            return this.lock.tryLock();
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void updatedRuns() {
            this.lastChangeUpdate.set(System.currentTimeMillis());
        }

        public boolean shouldNotify() {
            long lastChange;
            long lastNotifyTime = this.lastNotification.get();
            while (lastNotifyTime < (lastChange = this.lastChangeUpdate.get())) {
                long currentTime = System.currentTimeMillis();
                if (!this.lastNotification.compareAndSet(lastNotifyTime, currentTime)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "ExecToken:" + String.format("0x%X", this.hashCode());
        }
    }

    private class CallbackInvoker
    implements Runnable {
        private CallbackInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                EvaluationRequestToken token;
                try {
                    token = (EvaluationRequestToken)CachingTargetAlgorithmEvaluatorDecorator.this.tokenToCallbackQueue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError && CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.get()) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.info("Callback Invoker detected error, and has shutdown");
                    return;
                }
                token.fireCallback();
                token.lock();
                try {
                    TargetAlgorithmEvaluatorCallback callback = (TargetAlgorithmEvaluatorCallback)CachingTargetAlgorithmEvaluatorDecorator.this.evalRequestToCallbackMap.get(token);
                    try {
                        List rcs = (List)CachingTargetAlgorithmEvaluatorDecorator.this.allRunConfigsForTokenMap.get(token);
                        ArrayList<AlgorithmRunResult> runs = new ArrayList<AlgorithmRunResult>(rcs.size());
                        for (AlgorithmRunConfiguration rc : rcs) {
                            AlgorithmRunResult run;
                            if (!CachingTargetAlgorithmEvaluatorDecorator.this.completedRunConfigs.contains(rc) && !((Set)CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsForToken.get(token)).contains(rc)) {
                                CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Run is not marked as completed, we didn't kill it, yet callback is being fired: {}", (Object)rc);
                                if (CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError && CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                                    IllegalStateException e = new IllegalStateException("Callback fired but not all runs are complete");
                                    CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                                    e.printStackTrace();
                                }
                            }
                            if ((run = (AlgorithmRunResult)CachingTargetAlgorithmEvaluatorDecorator.this.completedRunsMap.get(rc)) == null) {
                                run = (AlgorithmRunResult)CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsMap.get(rc);
                            }
                            if (!((Set)CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsForToken.get(token)).contains(rc)) {
                                ((AtomicInteger)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToInterestedEvaluationsCounter.get(rc)).decrementAndGet();
                            }
                            if (run == null) {
                                throw (RuntimeException)CachingTargetAlgorithmEvaluatorDecorator.this.completedExceptionMap.get(rc);
                            }
                            runs.add(run);
                            ((Set)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToTokenMap.get(rc)).remove(token);
                        }
                        callback.onSuccess(runs);
                    }
                    catch (RuntimeException e) {
                        callback.onFailure(e);
                    }
                    continue;
                }
                finally {
                    CachingTargetAlgorithmEvaluatorDecorator.this.allRunConfigsForTokenMap.remove(token);
                    CachingTargetAlgorithmEvaluatorDecorator.this.outstandingRunsCountForTokenMap.remove(token);
                    CachingTargetAlgorithmEvaluatorDecorator.this.evalRequestToCallbackMap.remove(token);
                    CachingTargetAlgorithmEvaluatorDecorator.this.outstandingRunsForTokenMap.remove(token);
                    token.unlock();
                    continue;
                }
                break;
            }
        }
    }

    private class ObserverInvoker
    implements Runnable {
        private ObserverInvoker() {
        }

        @Override
        public void run() {
            while (true) {
                EvaluationRequestToken token;
                try {
                    token = (EvaluationRequestToken)CachingTargetAlgorithmEvaluatorDecorator.this.tokenToObserverQueue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError && CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.get()) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.info("Observer notification detected error, and has shutdown");
                    return;
                }
                CachingTargetAlgorithmEvaluatorDecorator.this.notifyObserverOfToken(token);
            }
        }
    }

    private class SubmissionObserver
    implements TargetAlgorithmEvaluatorRunObserver {
        private SubmissionObserver() {
        }

        @Override
        public void currentStatus(List<? extends AlgorithmRunResult> runs) {
            try {
                HashSet<EvaluationRequestToken> updateTokens = new HashSet<EvaluationRequestToken>();
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    AlgorithmRunConfiguration rc = algorithmRunResult.getAlgorithmRunConfiguration();
                    CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToLiveLatestStatusMap.put(rc, new RunningAlgorithmRunResult(rc, algorithmRunResult.getRuntime(), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getWallclockExecutionTime(), new NullKillHandler()));
                    for (EvaluationRequestToken token : (Set)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToTokenMap.get(rc)) {
                        updateTokens.add(token);
                    }
                    int interestedEvaluations = ((AtomicInteger)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToInterestedEvaluationsCounter.get(rc)).get();
                    if (interestedEvaluations == 0) {
                        algorithmRunResult.kill();
                    }
                    if (interestedEvaluations >= 0) continue;
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Run Config {} has negative interested parties, how odd: {}", (Object)rc, (Object)interestedEvaluations);
                    System.err.println("Run Config " + rc + " has negative interested parties, how odd: " + interestedEvaluations);
                }
                for (EvaluationRequestToken evaluationRequestToken : updateTokens) {
                    evaluationRequestToken.updatedRuns();
                    CachingTargetAlgorithmEvaluatorDecorator.this.tokenToObserverQueue.add(evaluationRequestToken);
                }
            }
            catch (RuntimeException e) {
                if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                    e.printStackTrace();
                }
                throw e;
            }
        }
    }

    private class SubmissionOnCompleteHandler
    implements TargetAlgorithmEvaluatorCallback {
        private final List<AlgorithmRunConfiguration> submissionRunConfigs;

        public SubmissionOnCompleteHandler(List<AlgorithmRunConfiguration> rcs) {
            this.submissionRunConfigs = rcs;
        }

        @Override
        public void onSuccess(List<AlgorithmRunResult> runs) {
            try {
                if (CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError && CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.get()) {
                    return;
                }
                for (AlgorithmRunResult run : runs) {
                    AlgorithmRunConfiguration rc = run.getAlgorithmRunConfiguration();
                    if (run.getRunStatus().equals((Object)RunStatus.KILLED)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.log.debug("Inserting killed run: {}", (Object)run);
                        CachingTargetAlgorithmEvaluatorDecorator.this.killedRunsMap.put(rc, run);
                    } else {
                        CachingTargetAlgorithmEvaluatorDecorator.this.completedRunsMap.put(rc, run);
                        CachingTargetAlgorithmEvaluatorDecorator.this.completedRunConfigs.add(rc);
                    }
                    AtomicBoolean b = (AtomicBoolean)CachingTargetAlgorithmEvaluatorDecorator.this.outstandingRunConfigMap.get(rc);
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.trace("RunConfig in onSuccess() current value is {} ==> {}", (Object)rc, (Object)b);
                    if (!b.compareAndSet(true, false)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Marking outstanding run {} as not outstanding didn't work, synchronization error detected", (Object)run);
                        IllegalStateException e = new IllegalStateException("Outstanding run " + rc + " wasn't set as running, this is a synchronization error");
                        if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                            CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                            e.printStackTrace();
                        }
                        if (CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError) {
                            throw e;
                        }
                    } else {
                        CachingTargetAlgorithmEvaluatorDecorator.this.log.trace("Marked run as no longer outstanding: {}", (Object)rc);
                    }
                    for (EvaluationRequestToken t : (Set)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToTokenMap.get(rc)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.processRunConfigurationForRequestToken(t, rc);
                    }
                }
            }
            catch (RuntimeException e) {
                if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                    e.printStackTrace();
                }
                throw e;
            }
        }

        @Override
        public void onFailure(RuntimeException e) {
            try {
                for (AlgorithmRunConfiguration rc : this.submissionRunConfigs) {
                    AtomicBoolean b = (AtomicBoolean)CachingTargetAlgorithmEvaluatorDecorator.this.outstandingRunConfigMap.get(rc);
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.trace("RunConfig in onFailure() current value is {} ==> {}", (Object)rc, (Object)b);
                    if (!b.compareAndSet(true, false)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Marking outstanding run {} as not outstanding didn't work, synchronization error detected", (Object)rc);
                        IllegalStateException e2 = new IllegalStateException("Outstanding run " + rc + " wasn't set as running, this is a synchronization error");
                        if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                            CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e2);
                            e.printStackTrace();
                        }
                        if (!CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError) continue;
                        throw e2;
                    }
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.trace("Marked run as no longer outstanding: {}", (Object)rc);
                }
                for (AlgorithmRunConfiguration rc : this.submissionRunConfigs) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.completedExceptionMap.put(rc, e);
                }
                for (AlgorithmRunConfiguration rc : this.submissionRunConfigs) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.completedRunConfigs.add(rc);
                    for (EvaluationRequestToken t : (Set)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigToTokenMap.get(rc)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.processRunConfigurationForRequestToken(t, rc);
                    }
                }
            }
            catch (RuntimeException e2) {
                if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                    CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e2);
                    e2.printStackTrace();
                }
                throw e;
            }
        }
    }

    private class RunSubmitter
    implements Runnable {
        private RunSubmitter() {
        }

        @Override
        public void run() {
            SubmissionObserver tObs = new SubmissionObserver();
            do {
                try {
                    List rcs;
                    try {
                        rcs = (List)CachingTargetAlgorithmEvaluatorDecorator.this.submissionQueue.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    for (AlgorithmRunConfiguration rc : rcs) {
                        if (((AtomicBoolean)CachingTargetAlgorithmEvaluatorDecorator.this.outstandingRunConfigMap.get(rc)).get()) continue;
                        CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Outstanding run being submitted {} is not marked outstanding, synchronization error detected", (Object)rc);
                        IllegalStateException e = new IllegalStateException("Outstanding run being submitted" + rc + "is not marked outstanding, synchronization error detected");
                        if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                            CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                            e.printStackTrace();
                        }
                        if (!CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError) continue;
                        throw e;
                    }
                    CachingTargetAlgorithmEvaluatorDecorator.this.tae.evaluateRunsAsync(rcs, new SubmissionOnCompleteHandler(rcs), tObs);
                    CachingTargetAlgorithmEvaluatorDecorator.this.submittedToDecoratee.addAndGet(rcs.size());
                    CachingTargetAlgorithmEvaluatorDecorator.this.log.trace("Runs have been successfully submitted to TAE: {}", (Object)rcs);
                    for (AlgorithmRunConfiguration rc : rcs) {
                        Semaphore lt = (Semaphore)CachingTargetAlgorithmEvaluatorDecorator.this.runConfigsSubmittedToWrappedDecoratorMap.get(rc);
                        if (lt == null) {
                            CachingTargetAlgorithmEvaluatorDecorator.this.log.error("No Semaphores for run config, this is a violation of our invariant {}", (Object)rc);
                            if (!CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError) continue;
                            throw new IllegalStateException("No Semaphores for run config, this is a violation of our invariant" + rc);
                        }
                        if (lt.availablePermits() != 0) {
                            CachingTargetAlgorithmEvaluatorDecorator.this.log.error("Semaphores seemingly has the wrong value of latches left for rc  {}  value {} ", (Object)rc, (Object)lt);
                            if (!CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError) continue;
                            throw new IllegalStateException("Semaphores seemingly has the wrong value of latches left for " + rc + " value " + lt);
                        }
                        lt.release();
                    }
                }
                catch (RuntimeException e) {
                    if (CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.compareAndSet(false, true)) {
                        CachingTargetAlgorithmEvaluatorDecorator.this.storedException.set(e);
                        e.printStackTrace();
                    }
                    throw e;
                }
            } while (!CachingTargetAlgorithmEvaluatorDecorator.this.shutdownOnError || !CachingTargetAlgorithmEvaluatorDecorator.this.errorDetected.get());
        }
    }
}

