/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.caching.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.runhistory.ReadOnlyThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunHistoryCachingTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final ThreadSafeRunHistory runHistory;
    private static final Logger log = LoggerFactory.getLogger(RunHistoryCachingTargetAlgorithmEvaluatorDecorator.class);
    private final AtomicInteger requests = new AtomicInteger(0);
    private final AtomicInteger cacheHits = new AtomicInteger(0);

    public RunHistoryCachingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, ThreadSafeRunHistory runHistory) {
        super(tae);
        this.runHistory = new ReadOnlyThreadSafeRunHistoryWrapper(runHistory);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver observer) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, observer);
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback callback, final TargetAlgorithmEvaluatorRunObserver observer) {
        ArrayList<AlgorithmRunConfiguration> runsToSubmit = new ArrayList<AlgorithmRunConfiguration>();
        final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> currentStatus = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
        for (AlgorithmRunConfiguration rc : runConfigs) {
            AlgorithmRunResult run = this.runHistory.getAlgorithmRunResultForAlgorithmRunConfiguration(rc);
            if (run == null) {
                runsToSubmit.add(rc);
                continue;
            }
            currentStatus.put(rc, run);
        }
        TargetAlgorithmEvaluatorCallback newCallback = new TargetAlgorithmEvaluatorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                for (AlgorithmRunResult run : runs) {
                    currentStatus.put(run.getAlgorithmRunConfiguration(), run);
                }
                ArrayList<AlgorithmRunResult> returnList = new ArrayList<AlgorithmRunResult>(runConfigs.size());
                for (AlgorithmRunConfiguration runConfig : runConfigs) {
                    returnList.add((AlgorithmRunResult)currentStatus.get(runConfig));
                }
                if (observer != null) {
                    TargetAlgorithmEvaluatorRunObserver targetAlgorithmEvaluatorRunObserver = observer;
                    synchronized (targetAlgorithmEvaluatorRunObserver) {
                        observer.currentStatus(returnList);
                    }
                }
                callback.onSuccess(returnList);
            }

            @Override
            public void onFailure(RuntimeException e) {
                callback.onFailure(e);
            }
        };
        this.requests.addAndGet(runConfigs.size());
        this.cacheHits.addAndGet(runConfigs.size() - runsToSubmit.size());
        log.trace("Submitting {} runs out of {} requested ", (Object)runsToSubmit.size(), (Object)runConfigs.size());
        TargetAlgorithmEvaluatorRunObserver runObserver = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    currentStatus.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                }
                ArrayList returnList = new ArrayList(runConfigs.size());
                for (AlgorithmRunConfiguration runConfig : runConfigs) {
                    returnList.add(currentStatus.get(runConfig));
                }
                if (observer != null) {
                    observer.currentStatus(returnList);
                }
            }
        };
        this.tae.evaluateRunsAsync(runsToSubmit, newCallback, runObserver);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        int misses = this.requests.get() - this.cacheHits.get();
        int requestCount = this.requests.get();
        log.info(this.getClass().getSimpleName() + ": Cache misses {}, Cache requests {}, Hit Rate {} ", new Object[]{misses, this.requests, nf.format(((double)requestCount - (double)misses) / (double)requestCount)});
    }
}

