/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AbortOnFirstRunCrashTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final AtomicBoolean firstRunChecked = new AtomicBoolean(false);

    public AbortOnFirstRunCrashTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.validate(super.evaluateRun(runConfigs, obs));
    }

    private List<AlgorithmRunResult> validate(List<AlgorithmRunResult> runs) {
        if (runs.size() == 0) {
            return runs;
        }
        if (this.firstRunChecked.getAndSet(true)) {
            return runs;
        }
        if (runs.get(0).getRunStatus().equals((Object)RunStatus.CRASHED)) {
            if (runs.get(0).getAdditionalRunData().startsWith("ERROR:")) {
                throw new TargetAlgorithmAbortException(runs.get(0).getAdditionalRunData().substring(6));
            }
            throw new TargetAlgorithmAbortException("First Run Crashed : " + runs.toString());
        }
        return runs;
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                try {
                    AbortOnFirstRunCrashTargetAlgorithmEvaluator.this.validate(runs);
                    handler.onSuccess(runs);
                }
                catch (TargetAlgorithmAbortException e) {
                    handler.onFailure(e);
                }
            }

            @Override
            public void onFailure(RuntimeException t) {
                handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

