/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractForEachRunTargetAlgorithmEvaluatorDecorator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrashedSolutionQualityTransformingTargetAlgorithmEvaluatorDecorator
extends AbstractForEachRunTargetAlgorithmEvaluatorDecorator {
    private final AtomicBoolean transformedResponseValueWarning = new AtomicBoolean(false);
    private final double crashedSolutionQualityValue;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected AlgorithmRunResult processRun(AlgorithmRunResult run) {
        if (run.getRunStatus().equals((Object)RunStatus.CRASHED) && run.getQuality() < this.crashedSolutionQualityValue) {
            if (this.transformedResponseValueWarning.compareAndSet(false, true)) {
                this.log.warn("Detected CRASHED run. The Solution Quality of CRASHED runs will be transformed to the MAX(quality, {}), to disable this use --transform-crashed-quality false to change the value use --transform-crashed-quality-value", (Object)this.crashedSolutionQualityValue);
            }
            run = new ExistingAlgorithmRunResult(run.getAlgorithmRunConfiguration(), run.getRunStatus(), run.getRuntime(), run.getRunLength(), Math.max(this.crashedSolutionQualityValue, run.getQuality()), run.getResultSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
        }
        return run;
    }

    public CrashedSolutionQualityTransformingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, double crashedSolutionQualityValue) {
        super(tae);
        this.crashedSolutionQualityValue = crashedSolutionQualityValue;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

