/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExitOnFailureTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private static final Logger log = LoggerFactory.getLogger(ExitOnFailureTargetAlgorithmEvaluatorDecorator.class);
    private static final int WAIT_TIME = 10;

    public ExitOnFailureTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    private static final synchronized void exit() {
        Thread exitThread = new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName(this.getClass().getSimpleName() + ":System.Exit Thread ");
                log.warn("Exiting process.");
                System.exit(1);
            }
        };
        exitThread.start();
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.err.println("Could not gracefully exit out of current thread in 10 seconds, halting process. Abandon ship.");
        Runtime.getRuntime().halt(1);
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback decoratedCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                handler.onSuccess(runs);
            }

            @Override
            public void onFailure(final RuntimeException e) {
                try {
                    Thread onFailureNotifier = new Thread(){

                        @Override
                        public void run() {
                            Thread.currentThread().setName(this.getClass().getSimpleName() + ":onFailureNotifying Thread ");
                            handler.onFailure(e);
                        }
                    };
                    onFailureNotifier.start();
                }
                finally {
                    log.warn("On failure detected, exiting current process.");
                    ExitOnFailureTargetAlgorithmEvaluatorDecorator.exit();
                }
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, decoratedCallback, obs);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
    }
}

