/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ClassParams;
import autoweka.Util;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;
import weka.core.Instances;
import weka.core.UnsupportedAttributeTypeException;

public class ApplicabilityTester {
    static final Logger log = LoggerFactory.getLogger(ApplicabilityTester.class);

    public static ApplicableClassifiers getApplicableClassifiers(Instances instances, String baseDir, List<String> allowed) {
        ApplicableClassifiers app = new ApplicableClassifiers();
        String dir = baseDir + File.separator + "base" + File.separator;
        app.base = ApplicabilityTester.getApplicable(instances, dir, Testable.CLASSIFIER, allowed, null);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-W");
        options.add(app.base.get(0).getTargetClass());
        dir = baseDir + File.separator + "meta" + File.separator;
        app.meta = ApplicabilityTester.getApplicable(instances, dir, Testable.CLASSIFIER, allowed, options);
        options.clear();
        options.add("-W");
        options.add(app.base.get(0).getTargetClass());
        dir = baseDir + File.separator + "ensemble" + File.separator;
        app.ensemble = ApplicabilityTester.getApplicable(instances, dir, Testable.CLASSIFIER, allowed, options);
        return app;
    }

    public static List<ClassParams> getApplicableAttributeEvaluators(Instances instances, String paramDirName) {
        return ApplicabilityTester.getApplicable(instances, paramDirName + File.separator + "attribselection" + File.separator + "eval" + File.separator, Testable.ATTRIBUTE_EVAL, null, null);
    }

    public static List<ClassParams> getApplicableAttributeSearchers(Instances instances, String paramDirName) {
        return ApplicabilityTester.getApplicable(instances, paramDirName + File.separator + "attribselection" + File.separator + "search" + File.separator, Testable.ATTRIBUTE_SEARCH, null, null);
    }

    private static List<ClassParams> getApplicable(Instances instances, String paramDirName, Testable type, List<String> allowed, List<String> options) {
        File[] params;
        File paramDir = new File(paramDirName);
        if (!paramDir.exists() || !paramDir.isDirectory()) {
            throw new RuntimeException(paramDirName + " is not a valid directory");
        }
        FileFilter paramFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".params") && !file.getName().startsWith(".");
            }
        };
        ArrayList<String> names = new ArrayList<String>();
        for (File i : params = paramDir.listFiles(paramFilter)) {
            names.add(Util.removeExtension(i.getName()));
        }
        Collections.sort(names);
        ArrayList<ClassParams> goodMethods = new ArrayList<ClassParams>();
        for (String name : names) {
            if (allowed != null && !allowed.contains(name) || !ApplicabilityTester.isApplicable(name, instances, options, type)) continue;
            goodMethods.add(new ClassParams(paramDirName + File.separatorChar + name + ".params"));
        }
        return goodMethods;
    }

    private static boolean isApplicable(String method, Instances instances, List<String> options, Testable type) {
        switch (type) {
            case CLASSIFIER: {
                return ApplicabilityTester.isApplicableClassifier(method, instances, options);
            }
            case ATTRIBUTE_EVAL: {
                return ApplicabilityTester.isApplicableAttributeEvaluator(method, instances);
            }
            case ATTRIBUTE_SEARCH: {
                return ApplicabilityTester.isApplicableAttributeSearch(method, instances);
            }
        }
        return false;
    }

    private static boolean isApplicableClassifier(String method, Instances instances, List<String> options) {
        try {
            Class<?> cls = Class.forName(method);
            AbstractClassifier classifier = (AbstractClassifier)cls.newInstance();
            if (options != null) {
                try {
                    classifier.setOptions(options.toArray(new String[options.size()]));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set options during applicability testing", e);
                }
            }
            classifier.getCapabilities().testWithFail(instances);
            return true;
        }
        catch (ClassNotFoundException e) {
            log.debug("No class {} found", (Object)method);
        }
        catch (InstantiationException e) {
            log.debug("Failed to instantiate {}: {}", method, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.debug("Illegal access exception creating {}: {}", method, e.getMessage(), e);
        }
        catch (UnsupportedAttributeTypeException e) {
            log.debug("{} failed: {}", new Object[]{method, e.getMessage(), e});
        }
        catch (Exception e) {
            log.debug("{} not supported: {}", method, e.getMessage(), e);
        }
        return false;
    }

    private static boolean isApplicableAttributeSearch(String method, Instances instances) {
        try {
            ASSearch aSSearch = ASSearch.forName((String)method, (String[])new String[0]);
        }
        catch (UnsupportedAttributeTypeException e) {
            log.debug("{} failed: {}", new Object[]{method, e.getMessage(), e});
            return false;
        }
        catch (Exception e) {
            log.debug("{} not supported: {}", method, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private static boolean isApplicableAttributeEvaluator(String method, Instances instances) {
        try {
            ASEvaluation eval = ASEvaluation.forName((String)method, (String[])new String[0]);
            eval.getCapabilities().testWithFail(instances);
        }
        catch (UnsupportedAttributeTypeException e) {
            log.debug("{} failed: {}", new Object[]{method, e.getMessage(), e});
            return false;
        }
        catch (Exception e) {
            log.debug("{} not supported: {}", method, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static class ApplicableClassifiers {
        public List<ClassParams> base;
        public List<ClassParams> meta;
        public List<ClassParams> ensemble;
    }

    private static enum Testable {
        CLASSIFIER,
        ATTRIBUTE_SEARCH,
        ATTRIBUTE_EVAL;

    }
}

