/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ClassifierResult;
import autoweka.Configuration;
import autoweka.InstanceGenerator;
import autoweka.Util;
import autoweka.WekaArgumentConverter;
import autoweka.WorkerThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.output.prediction.CSV;
import weka.classifiers.meta.AutoWEKAClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class ClassifierRunner {
    final Logger log = LoggerFactory.getLogger(ClassifierRunner.class);
    private InstanceGenerator mInstanceGenerator = null;
    private boolean mTestOnly = false;
    private boolean mDisableOutput = false;
    private PrintStream mSavedOutput = null;
    private String mPredictionsFileName = null;

    public ClassifierRunner(Properties props) {
        this.mInstanceGenerator = InstanceGenerator.create(props.getProperty("instanceGenerator"), props.getProperty("datasetString"));
        this.mTestOnly = Boolean.valueOf(props.getProperty("onlyTest", "false"));
        this.mDisableOutput = Boolean.valueOf(props.getProperty("disableOutput", "false"));
        this.mPredictionsFileName = props.getProperty("predictionsFileName", null);
    }

    public InstanceGenerator getInstanceGenerator() {
        return this.mInstanceGenerator;
    }

    public ClassifierResult run(String instanceStr, String resultMetric, float timeout, String mSeed, List<String> args) {
        PrintStream stderr = System.err;
        System.setErr(System.out);
        RunnerThread runner = new RunnerThread(instanceStr, resultMetric, timeout, mSeed, args);
        float time = runner.runWorker(timeout * 2.05f);
        System.setErr(stderr);
        if (runner.getException() != null) {
            throw (RuntimeException)runner.getException();
        }
        if (runner.terminated()) {
            ClassifierResult res = new ClassifierResult(resultMetric);
            res.setTrainingTime(time);
        }
        return runner.result;
    }

    public ClassifierResult evaluateClassifierOnTesting(AbstractClassifier classifier, String instanceStr, String resultMetric, float evaluateClassifierOnInstances) {
        ClassifierResult res = new ClassifierResult(resultMetric);
        res.setClassifier(classifier);
        Instances instances = this.mInstanceGenerator.getTestingFromParams(instanceStr);
        this._evaluateClassifierOnInstances(classifier, res, instances, evaluateClassifierOnInstances, null, null);
        return res;
    }

    private ClassifierResult _run(String instanceStr, String resultMetric, float timeout, String mSeed, List<String> args) {
        AbstractClassifier classifier;
        String targetClassifierName;
        Instances training = this.mInstanceGenerator.getTrainingFromParams(instanceStr);
        Instances testing = this.mInstanceGenerator.getTestingFromParams(instanceStr);
        WekaArgumentConverter.Arguments wekaArgs = WekaArgumentConverter.convert(args);
        Map<String, String> propertyMap = wekaArgs.propertyMap;
        Map<String, List<String>> argMap = wekaArgs.argMap;
        ClassifierResult res = new ClassifierResult(resultMetric);
        String attribSearchClassName = propertyMap.get("attributesearch");
        String attribEvalClassName = propertyMap.get("attributeeval");
        String attribTime = propertyMap.get("attributetime");
        if (!this.mTestOnly && (attribSearchClassName != null && !attribSearchClassName.equals("NONE") || attribEvalClassName != null)) {
            if (attribSearchClassName == null) {
                throw new RuntimeException("Missing attribute search class name");
            }
            if (attribEvalClassName == null) {
                throw new RuntimeException("Missing attribute eval class name");
            }
            if (attribTime == null) {
                throw new RuntimeException("Missing the attribute evaluation time param");
            }
            float attribTimeout = Float.parseFloat(attribTime);
            ASEvaluation asEval = null;
            ASSearch asSearch = null;
            try {
                asEval = ASEvaluation.forName((String)attribEvalClassName, (String[])argMap.get("attributeeval").toArray(new String[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create ASEvaluation " + attribEvalClassName + ": " + e.getMessage(), e);
            }
            try {
                asSearch = ASSearch.forName((String)attribSearchClassName, (String[])argMap.get("attributesearch").toArray(new String[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create ASSearch " + attribSearchClassName + ": " + e.getMessage(), e);
            }
            AttributeSelection attribSelect = new AttributeSelection();
            attribSelect.setEvaluator(asEval);
            attribSelect.setSearch(asSearch);
            AttributeSelectorThread asThread = new AttributeSelectorThread(attribSelect, training);
            this.disableOutput();
            float asTime = asThread.runWorker(attribTimeout);
            this.enableOutput();
            res.setAttributeSelectionTime(asTime);
            if (asThread.getException() != null || asThread.terminated()) {
                if (asThread.getException() != null) {
                    res.setMemOut(asThread.getException().getCause() instanceof OutOfMemoryError);
                    this.log.warn("Attribute selection (search {} {}, eval {} {}) failed: {}", attribSearchClassName, argMap.get("attributeeval"), attribEvalClassName, argMap.get("attributesearch"), asThread.getException().getMessage(), asThread.getException());
                }
                asThread = null;
                res.setCompleted(false);
                return res;
            }
            res.setAttributeSelection(attribSelect);
            try {
                int[] attrs = attribSelect.selectedAttributes();
                this.log.debug("Using {}% attributes:", (Object)(100.0 * (double)attrs.length / (double)training.numAttributes()));
                for (int i = 0; i < attrs.length; ++i) {
                    this.log.debug("{}", (Object)i);
                }
                training = attribSelect.reduceDimensionality(training);
                testing = attribSelect.reduceDimensionality(testing);
                this.log.debug("Target class: {}", (Object)training.classAttribute());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((targetClassifierName = propertyMap.get("targetclass")) == null || targetClassifierName.isEmpty()) {
            throw new RuntimeException("No target classifier name specified!");
        }
        float regPenalty = 0.0f;
        res.setRegularizationPenalty(regPenalty);
        String[] argsArray = argMap.get("classifier").toArray(new String[0]);
        Object[] argsArraySaved = argMap.get("classifier").toArray(new String[0]);
        try {
            classifier = (AbstractClassifier)AbstractClassifier.forName((String)targetClassifierName, (String[])argsArray);
            res.setClassifier(classifier);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + targetClassifierName + "': " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate '" + targetClassifierName + "' with options " + Arrays.toString(argsArraySaved) + ": " + e.getMessage(), e);
        }
        if (this.mTestOnly) {
            res.setCompleted(true);
            return res;
        }
        BuilderThread builderThread = new BuilderThread(classifier, training);
        this.disableOutput();
        float trainingTime = builderThread.runWorker(timeout);
        this.enableOutput();
        res.setTrainingTime(trainingTime);
        if (builderThread.getException() != null) {
            this.log.warn("Training classifier ({} {}) failed: {}", targetClassifierName, argsArraySaved, builderThread.getException().getMessage(), builderThread.getException());
            res.setMemOut(builderThread.getException().getCause() instanceof OutOfMemoryError);
        }
        if (builderThread.getException() != null || builderThread.terminated()) {
            builderThread = null;
            res.setCompleted(false);
            return res;
        }
        res.setCompleted(true);
        this.log.debug("Performing evaluation on {} instances.", (Object)testing.numInstances());
        if (!this._evaluateClassifierOnInstances(classifier, res, testing, timeout, args, instanceStr)) {
            return res;
        }
        this.log.info("{};{};{};{};{};{};{};{}", targetClassifierName, argsArraySaved, attribEvalClassName, argMap.get("attributeeval"), attribSearchClassName, argMap.get("attributesearch"), instanceStr, res.getRawScore());
        this.log.debug("Num Training: {}, num testing: {}", (Object)training.numInstances(), (Object)testing.numInstances());
        return res;
    }

    private boolean _evaluateClassifierOnInstances(AbstractClassifier classifier, ClassifierResult res, Instances instances, float timeout, List<String> args, String instanceStr) {
        Evaluation eval = null;
        try {
            eval = new Evaluation(instances);
            EvaluatorThread evalThread = new EvaluatorThread(eval, classifier, instances, this.mPredictionsFileName);
            this.disableOutput();
            float evalTime = evalThread.runWorker(timeout);
            this.enableOutput();
            res.setEvaluationTime(evalTime);
            if (evalThread.getException() != null) {
                throw evalThread.getException();
            }
            this.log.debug("Completed evaluation on {}/{} instances.", (Object)((double)instances.numInstances() - eval.unclassified()), (Object)instances.numInstances());
            res.setCompleted(!evalThread.terminated());
            res.setPercentEvaluated(100.0f * (float)(1.0 - eval.unclassified() / (double)instances.numInstances()));
            this.log.debug("Percent evaluated: {}", (Object)res.getPercentEvaluated());
            if (res.getPercentEvaluated() < 100.0) {
                res.setCompleted(false);
                this.log.debug("Evaluated less than 100% of the data.");
            } else if (!evalThread.terminated()) {
                res.setScoreFromEval(eval, instances);
                this.saveConfiguration(res, args, instanceStr);
            }
        }
        catch (Exception e) {
            this.log.debug("Evaluating classifier failed: {}", (Object)e.getMessage(), (Object)e);
            res.setCompleted(false);
            res.setMemOut(e.getCause() instanceof OutOfMemoryError);
            return false;
        }
        this.log.trace(eval.toSummaryString("\nResults\n======\n", false));
        try {
            this.log.trace(eval.toMatrixString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.debug(res.getDescription());
        return true;
    }

    protected void saveConfiguration(ClassifierResult res, List<String> args, String instanceStr) {
        File sortedLog = new File(AutoWEKAClassifier.configurationRankingPath);
        if (!sortedLog.exists()) {
            return;
        }
        Configuration ciConfig = new Configuration(args);
        int ciHash = ciConfig.hashCode();
        String ciFilename = AutoWEKAClassifier.configurationInfoDirPath + ciHash + ".xml";
        File ciFile = new File(ciFilename);
        String configIndex = AutoWEKAClassifier.configurationHashSetPath;
        Properties pInstanceString = Util.parsePropertyString(instanceStr);
        int ciFold = Integer.parseInt(pInstanceString.getProperty("fold", "-1"));
        double ciScore = res.getScore();
        ciConfig.setEvaluationValues(ciScore, ciFold);
        if (ciFile.exists()) {
            Configuration ciConfigFull = Configuration.fromXML(ciFilename, Configuration.class);
            ciConfigFull.mergeWith(ciConfig);
            ciConfigFull.toXML(ciFilename);
        } else {
            Util.initializeFile(ciFilename);
            ciConfig.toXML(ciFilename);
        }
        try {
            BufferedWriter fp = new BufferedWriter(new FileWriter(AutoWEKAClassifier.configurationHashSetPath, true));
            fp.write(ciHash + ",");
            fp.flush();
            fp.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write to configIndex");
        }
    }

    protected void disableOutput() {
        if (!this.mDisableOutput) {
            return;
        }
        this.mSavedOutput = System.out;
        System.setOut(new Util.NullPrintStream());
    }

    protected void enableOutput() {
        if (!this.mDisableOutput) {
            return;
        }
        System.setOut(this.mSavedOutput);
    }

    class AttributeSelectorThread
    extends WorkerThread {
        private AttributeSelection mSelection;
        private Instances mInstances;

        public AttributeSelectorThread(AttributeSelection selection, Instances inst) {
            this.mInstances = inst;
            this.mSelection = selection;
        }

        @Override
        protected void doWork() throws Exception {
            this.mSelection.SelectAttributes(this.mInstances);
        }

        @Override
        protected String getOpName() {
            return "Attribute selection";
        }
    }

    public static class EvaluatorThread
    extends WorkerThread {
        private AbstractClassifier mClassifier;
        private Instances mInstances;
        private Evaluation mEval;
        private String mPredictionsFile;

        public EvaluatorThread(Evaluation ev, AbstractClassifier cls, Instances inst) {
            this(ev, cls, inst, null);
        }

        public EvaluatorThread(Evaluation ev, AbstractClassifier cls, Instances inst, String predictionsFile) {
            this.mEval = ev;
            this.mClassifier = cls;
            this.mInstances = inst;
            this.mPredictionsFile = predictionsFile;
        }

        @Override
        protected void doWork() throws Exception {
            CSV out = null;
            StringBuffer buffer = null;
            if (this.mPredictionsFile != null) {
                out = new CSV();
                buffer = new StringBuffer();
                out.setBuffer(buffer);
                out.setHeader(this.mInstances);
                out.setOutputDistribution(true);
                out.printHeader();
                this.mEval.evaluateModel((Classifier)this.mClassifier, this.mInstances, new Object[]{out});
                out.printFooter();
                try {
                    BufferedWriter fp = new BufferedWriter(new FileWriter(this.mPredictionsFile));
                    fp.write(buffer.toString());
                    fp.flush();
                    fp.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                for (Instance instance : this.mInstances) {
                    this.mEval.evaluateModelOnceAndRecordPrediction((Classifier)this.mClassifier, instance);
                }
            }
        }

        @Override
        protected String getOpName() {
            return "Evaluation of classifier";
        }
    }

    class BuilderThread
    extends WorkerThread {
        private AbstractClassifier mClassifier;
        private Instances mTrainInstances;

        public BuilderThread(AbstractClassifier cls, Instances inst) {
            this.mClassifier = cls;
            this.mTrainInstances = inst;
        }

        @Override
        protected void doWork() throws Exception {
            this.mClassifier.buildClassifier(this.mTrainInstances);
        }

        @Override
        protected String getOpName() {
            return "Training of classifier";
        }
    }

    private class RunnerThread
    extends WorkerThread {
        private String instanceStr;
        private String resultMetric;
        private float timeout;
        private String mSeed;
        private List<String> args;
        public ClassifierResult result;

        public RunnerThread(String _instanceStr, String _resultMetric, float _timeout, String _mSeed, List<String> _args) {
            this.instanceStr = _instanceStr;
            this.resultMetric = _resultMetric;
            this.timeout = _timeout;
            this.mSeed = _mSeed;
            this.args = _args;
        }

        @Override
        protected void doWork() throws Exception {
            this.result = ClassifierRunner.this._run(this.instanceStr, this.resultMetric, this.timeout, this.mSeed, this.args);
        }

        @Override
        protected String getOpName() {
            return "Main Thread";
        }
    }
}

