/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Parameter;
import autoweka.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Conditional {
    public Parameter parameter;
    public Parameter parent;
    public Collection<String> domain = new LinkedList<String>();
    private static final Pattern conditionalPattern = Pattern.compile("\\s*([a-zA-Z0-9_-]*)\\s*\\|\\s*([a-zA-Z0-9_]*)\\s*in\\s*\\{(.*)\\}.*");

    public Conditional(String line, HashMap<String, Parameter> paramMap) {
        Matcher m = conditionalPattern.matcher(line);
        if (!m.matches()) {
            throw new RuntimeException("Failed to match parameter line '" + line + "'");
        }
        this.parameter = paramMap.get(m.group(1));
        this.parent = paramMap.get(m.group(2));
        if (this.parameter == null) {
            throw new IllegalArgumentException("Can't find conditional target parameter with name '" + m.group(1) + "'");
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("Can't find conditional parent parameter with name '" + m.group(2) + "'");
        }
        String[] elements = m.group(3).split(",");
        for (int i = 0; i < elements.length; ++i) {
            this.domain.add(elements[i].trim());
        }
    }

    public Conditional(Parameter _param, Parameter _parent, String _domain) {
        this(_param, _parent, Collections.singleton(_domain));
    }

    public Conditional(Parameter _param, Parameter _parent, Collection<String> _domain) {
        this.parameter = _param;
        this.parent = _parent;
        for (String s : _domain) {
            this.domain.add(s);
        }
    }

    public Conditional(Parameter _param, Parameter _parent, Conditional previous) {
        this(_param, _parent, previous.domain);
    }

    public String toString() {
        return this.parameter.name + " | " + this.parent.name + " in {" + Util.joinStrings(", ", this.domain) + "}";
    }
}

