/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Configuration;
import autoweka.ConfigurationCollection;
import autoweka.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import weka.classifiers.meta.AutoWEKAClassifier;

public class ConfigurationRanker {
    public static void rank(int n, String temporaryDirPath, String smacBest) throws FileNotFoundException, NoSuchElementException {
        String hsPath = temporaryDirPath + AutoWEKAClassifier.configurationHashSetPath;
        String cdPath = temporaryDirPath + AutoWEKAClassifier.configurationInfoDirPath;
        String rPath = temporaryDirPath + AutoWEKAClassifier.configurationRankingPath;
        List<Configuration> configs = new ArrayList<Configuration>();
        File hashSetFile = new File(hsPath);
        String[] redundantConfigHashes = new Scanner(hashSetFile).nextLine().split(",");
        HashSet<String> configHashes = new HashSet<String>(Arrays.asList(redundantConfigHashes));
        for (String hash : configHashes) {
            configs.add(Configuration.fromXML(cdPath + hash + ".xml", Configuration.class));
        }
        for (Configuration c : configs) {
            c.forceUpdateAverage();
        }
        Collections.sort(configs);
        Collections.reverse(configs);
        if (!smacBest.equals("IGNORE")) {
            ConfigurationRanker.forceFirst(configs, smacBest);
        }
        configs = configs.subList(0, n < configs.size() ? n : configs.size());
        Util.initializeFile(rPath);
        ConfigurationCollection spitMe = new ConfigurationCollection(configs);
        spitMe.toXML(rPath);
    }

    private static void forceFirst(List<Configuration> configs, String smacBest) {
        Configuration bestConfig = configs.get(0);
        if (bestConfig.getArgStrings().equals(smacBest)) {
            return;
        }
        double bestScore = bestConfig.getAverageScore();
        for (int i = 1; i < configs.size(); ++i) {
            Configuration c = configs.get(i);
            if (!c.getArgStrings().equals(smacBest)) continue;
            if (c.getAverageScore() != bestScore) {
                throw new RuntimeException("Final incumbent doesn't have the best score");
            }
            configs.set(0, c);
            configs.set(i, bestConfig);
            return;
        }
        throw new RuntimeException("Couldn't find final incumbent on the log");
    }
}

