/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.Util;
import autoweka.XmlSerializable;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="experimentBatch")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExperimentBatch
extends XmlSerializable {
    static final Logger log = LoggerFactory.getLogger(ExperimentBatch.class);
    @XmlElement(name="datasetComponent")
    public List<DatasetComponent> mDatasets = new ArrayList<DatasetComponent>();
    @XmlElement(name="experimentComponent")
    public List<ExperimentComponent> mExperiments = new ArrayList<ExperimentComponent>();

    public static ExperimentBatch fromXML(String filename) {
        return XmlSerializable.fromXML(filename, ExperimentBatch.class);
    }

    public static ExperimentBatch fromXML(InputStream xml) {
        return XmlSerializable.fromXML(xml, ExperimentBatch.class);
    }

    public static Experiment createExperiment(ExperimentComponent expComp, DatasetComponent datasetComp) {
        Experiment exp = new Experiment();
        exp.name = expComp.name + "-" + datasetComp.name;
        exp.resultMetric = expComp.resultMetric;
        exp.instanceGenerator = expComp.instanceGenerator;
        exp.instanceGeneratorArgs = expComp.instanceGeneratorArgs;
        exp.datasetString = datasetComp.getDatasetString();
        exp.attributeSelection = expComp.attributeSelection;
        exp.attributeSelectionTimeout = expComp.attributeSelectionTimeout;
        exp.callString = new ArrayList<String>();
        exp.envVariables = new ArrayList<String>();
        exp.tunerTimeout = expComp.tunerTimeout;
        exp.trainTimeout = expComp.trainTimeout;
        exp.memory = expComp.memory;
        exp.extraPropsString = expComp.extraProps;
        exp.trajectoryPointExtras = expComp.trajectoryPointExtras;
        exp.allowedClassifiers = new ArrayList<String>(expComp.allowedClassifiers);
        return exp;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            log.error("Usage: {} <xmlfilename>", (Object)ExperimentBatch.class.getCanonicalName());
            log.error("Makes a template experiment batch file");
            System.exit(1);
        }
        ExperimentBatch batch = new ExperimentBatch();
        DatasetComponent dataset = new DatasetComponent();
        dataset.name = "";
        dataset.zipFile = "(Optional - One must be defined though)";
        batch.mDatasets = Collections.singletonList(dataset);
        ExperimentComponent experiment = new ExperimentComponent();
        experiment.name = "";
        experiment.constructor = "";
        experiment.instanceGenerator = "";
        experiment.instanceGeneratorArgs = "(Optional)";
        experiment.tunerTimeout = -1.0f;
        experiment.trainTimeout = -1.0f;
        experiment.memory = "";
        experiment.extraProps = "(Optional)";
        experiment.constructorArgs = Collections.singletonList("(Optional List)");
        batch.mExperiments = Collections.singletonList(experiment);
        batch.toXML(args[0]);
    }

    @XmlRootElement(name="experiment")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ExperimentComponent {
        @XmlElement(name="name")
        public String name;
        @XmlElement(name="resultMetric")
        public String resultMetric;
        @XmlElement(name="experimentConstructor")
        public String constructor;
        @XmlElement(name="experimentConstructorArgs")
        public List<String> constructorArgs = new ArrayList<String>();
        @XmlElement(name="instanceGenerator")
        public String instanceGenerator;
        @XmlElement(name="instanceGeneratorArgs")
        public String instanceGeneratorArgs;
        @XmlElement(name="tunerTimeout")
        public float tunerTimeout = -1.0f;
        @XmlElement(name="trainTimeout")
        public float trainTimeout = -1.0f;
        @XmlElement(name="attributeSelection")
        public boolean attributeSelection = false;
        @XmlElement(name="attributeSelectionTimeout")
        public float attributeSelectionTimeout = -1.0f;
        @XmlElement(name="memory")
        public String memory;
        @XmlElement(name="extraProps")
        public String extraProps;
        @XmlElement(name="trajectoryPointExtras")
        public List<Experiment.TrajectoryPointExtra> trajectoryPointExtras = new ArrayList<Experiment.TrajectoryPointExtra>();
        @XmlElement(name="allowedClassifiers")
        public List<String> allowedClassifiers = new ArrayList<String>();
    }

    @XmlRootElement(name="dataset")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class DatasetComponent {
        @XmlElement(name="classIndex")
        private String classIndex;
        @XmlElement(name="zipFile")
        private String zipFile;
        @XmlElement(name="trainArff")
        private String trainArff;
        @XmlElement(name="testArff")
        private String testArff;
        @XmlElement(name="name")
        public String name;

        public String getDatasetString() {
            int count = 0;
            count += this.zipFile != null ? 1 : 0;
            if ((count += this.trainArff != null && this.testArff != null ? 1 : 0) != 1) {
                throw new IllegalArgumentException("A datasetComponent was found where the type could not be determined");
            }
            Properties props = new Properties();
            if (this.classIndex != null) {
                props.setProperty("classIndex", this.classIndex);
            }
            if (this.zipFile != null) {
                props.setProperty("type", "zipFile");
                props.setProperty("zipFile", URLDecoder.decode(new File(this.zipFile).getAbsolutePath()));
            }
            if (this.trainArff != null && this.testArff != null) {
                props.setProperty("type", "trainTestArff");
                props.setProperty("trainArff", URLDecoder.decode(new File(this.trainArff).getAbsolutePath()));
                props.setProperty("testArff", URLDecoder.decode(new File(this.testArff).getAbsolutePath()));
            }
            if (props.getProperty("type") == null) {
                throw new RuntimeException("No type was determined for this datasetComponent");
            }
            return Util.propertiesToString(props);
        }

        public void setTrainTestArff(String _trainArff, String _testArff) {
            this.trainArff = _trainArff;
            this.testArff = _testArff;
        }
    }
}

