/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.ApplicabilityTester;
import autoweka.ClassParams;
import autoweka.Conditional;
import autoweka.Experiment;
import autoweka.ExperimentBatch;
import autoweka.InstanceGenerator;
import autoweka.Parameter;
import autoweka.ParameterConditionalGroup;
import autoweka.Util;
import autoweka.XmlSerializable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public abstract class ExperimentConstructor {
    static final Logger log = LoggerFactory.getLogger(ExperimentConstructor.class);
    protected String mParamBaseDir = Util.getAutoWekaDistributionPath() + File.separator + "params";
    protected List<ClassParams> mBaseClassParams = new ArrayList<ClassParams>();
    protected List<ClassParams> mMetaClassParams = new ArrayList<ClassParams>();
    protected List<ClassParams> mEnsembleClassParams = new ArrayList<ClassParams>();
    protected List<ClassParams> mAttribSearchClassParams = new ArrayList<ClassParams>();
    protected List<ClassParams> mAttribEvalClassParams = new ArrayList<ClassParams>();
    protected List<String> mAllowedClassifiers = new ArrayList<String>();
    protected int mEnsembleMaxNum = 5;
    protected boolean mIncludeBase = true;
    protected boolean mIncludeMeta = true;
    protected boolean mIncludeEnsemble = true;
    protected String mExperimentPath = "experiments";
    protected Experiment mExperiment = null;
    protected Properties mProperties = null;
    protected InstanceGenerator mInstanceGenerator = null;

    public static void main(String[] args) {
        if (args.length < 0) {
            log.error("Arguments missing. Please refer to manual for help.");
        } else if (args[0].equals("-batch") || new File(args[0]).isFile()) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) continue;
                ExperimentConstructor.generateBatches(args[i]);
            }
        } else {
            LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
            String constructorName = argList.poll();
            Experiment exp = new Experiment();
            XmlSerializable.populateObjectFromCMDParams((Object)exp, argList);
            ExperimentConstructor.buildSingle(constructorName, exp, argList);
        }
    }

    public static void generateBatches(String xmlFile) {
        try {
            ExperimentBatch batch = ExperimentBatch.fromXML(xmlFile);
            for (ExperimentBatch.ExperimentComponent expComp : batch.mExperiments) {
                for (ExperimentBatch.DatasetComponent datasetComp : batch.mDatasets) {
                    Experiment exp = ExperimentBatch.createExperiment(expComp, datasetComp);
                    ExperimentConstructor.buildSingle(expComp.constructor, exp, new LinkedList<String>(expComp.constructorArgs));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create batch for " + xmlFile, e);
        }
    }

    public static void buildSingle(String builderClassName, Experiment exp, List<String> args) {
        ExperimentConstructor builder;
        exp.validate();
        log.debug("Making Experiment {}", (Object)exp.name);
        try {
            Class<?> cls = Class.forName(builderClassName);
            builder = (ExperimentConstructor)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class '" + builderClassName + "': " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate '" + builderClassName + "': " + e.getMessage(), e);
        }
        builder.run(exp, new LinkedList<String>(args));
    }

    private void run(Experiment exp, List<String> args) {
        this.mProperties = new Properties();
        String propsFilePath = Util.getAutoWekaDistributionPath() + File.separator + this.getClass().getCanonicalName() + ".properties";
        try {
            this.mProperties.load(new FileInputStream(new File(propsFilePath)));
        }
        catch (FileNotFoundException e) {
            log.warn("No property file {}.properties found", (Object)propsFilePath);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        if (exp.resultMetric == null) {
            throw new RuntimeException("No Result Metric defined");
        }
        this.mExperiment = exp;
        LinkedList<String> argQueue = new LinkedList<String>(args);
        while (!argQueue.isEmpty()) {
            String arg = (String)argQueue.poll();
            if (arg.equals("-nometa")) {
                this.mIncludeMeta = false;
                continue;
            }
            if (arg.equals("-noensemble")) {
                this.mIncludeEnsemble = false;
                continue;
            }
            if (arg.equals("-experimentpath")) {
                this.mExperimentPath = (String)argQueue.poll();
                continue;
            }
            if (arg.equals("-propertyoverride")) {
                Util.parsePropertyString(this.mProperties, (String)argQueue.poll());
                continue;
            }
            this.processArg(arg, argQueue);
        }
        this.mInstanceGenerator = InstanceGenerator.create(this.mExperiment.instanceGenerator, this.mExperiment.datasetString);
        if (this.mExperiment.attributeSelection) {
            this.loadAttributeSelectors();
        }
        this.mAllowedClassifiers = exp.allowedClassifiers;
        this.loadClassifiers();
        if (this.mAllowedClassifiers.isEmpty()) {
            if (this.mIncludeBase) {
                for (ClassParams clsParams : this.mBaseClassParams) {
                    this.mAllowedClassifiers.add(clsParams.getTargetClass());
                }
            }
            if (this.mIncludeMeta) {
                for (ClassParams clsParams : this.mMetaClassParams) {
                    this.mAllowedClassifiers.add(clsParams.getTargetClass());
                }
            }
            if (this.mIncludeEnsemble) {
                for (ClassParams clsParams : this.mEnsembleClassParams) {
                    this.mAllowedClassifiers.add(clsParams.getTargetClass());
                }
            }
        }
        this.checkPrefixes();
        Util.makePath(this.mExperimentPath + File.separator + this.mExperiment.name);
        String absExperimentDir = URLDecoder.decode(new File(this.mExperimentPath + File.separator + this.mExperiment.name + File.separator).getAbsolutePath()) + File.separator;
        this.prepareExperiment(absExperimentDir);
        this.mExperiment.type = this.getType();
        this.mExperiment.trajectoryParserClassName = this.getTrajectoryParserClassName();
        this.mExperiment.callString = this.getCallString(absExperimentDir);
        this.mExperiment.envVariables = this.getEnvVariables();
        this.mExperiment.toXML(this.mExperimentPath + File.separator + this.mExperiment.name + File.separator + this.mExperiment.name + ".experiment");
    }

    protected String getWrapperPropString() {
        Properties props = new Properties();
        props.setProperty("datasetString", this.mExperiment.datasetString);
        props.setProperty("instanceGenerator", this.mExperiment.instanceGenerator);
        props.setProperty("resultMetric", this.mExperiment.resultMetric);
        return Util.propertiesToString(props);
    }

    public abstract void prepareExperiment(String var1);

    public void processArg(String arg, Queue<String> args) {
        log.warn("Ignoring unknown argument {}", (Object)arg);
    }

    protected abstract String getType();

    protected abstract String getTrajectoryParserClassName();

    protected abstract List<String> getCallString(String var1);

    protected List<String> getEnvVariables() {
        return Collections.emptyList();
    }

    private void loadAttributeSelectors() {
        Instances instances = this.mInstanceGenerator.getTraining();
        this.mAttribEvalClassParams = ApplicabilityTester.getApplicableAttributeEvaluators(instances, this.mParamBaseDir);
        this.mAttribSearchClassParams = ApplicabilityTester.getApplicableAttributeSearchers(instances, this.mParamBaseDir);
    }

    private void loadClassifiers() {
        Instances instances = this.mInstanceGenerator.getTraining();
        List<String> allowed = null;
        if (this.mAllowedClassifiers.size() > 0) {
            allowed = this.mAllowedClassifiers;
        }
        ApplicabilityTester.ApplicableClassifiers app = ApplicabilityTester.getApplicableClassifiers(instances, this.mParamBaseDir, allowed);
        this.mBaseClassParams = app.base;
        this.mMetaClassParams = app.meta;
        this.mEnsembleClassParams = app.ensemble;
    }

    private void checkPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<List<ClassParams>> classParams = new ArrayList<List<ClassParams>>();
        classParams.add(this.mBaseClassParams);
        classParams.add(this.mMetaClassParams);
        classParams.add(this.mEnsembleClassParams);
        classParams.add(this.mAttribEvalClassParams);
        classParams.add(this.mAttribSearchClassParams);
        for (List list : classParams) {
            for (ClassParams param : list) {
                String prefix = this.getPrefix(param.getTargetClass());
                if (prefixes.contains(prefix)) {
                    throw new RuntimeException("Prefix '" + prefix + "' (" + param.getTargetClass() + ") is already in use.");
                }
                prefixes.add(prefix);
            }
        }
    }

    public String getPrefix(String classifierName) {
        return classifierName.replaceAll("\\.", "").toLowerCase();
    }

    public ParameterConditionalGroup generateAlgorithmParameterConditionalGroupForDAG() {
        String className;
        ParameterConditionalGroup paramGroup = new ParameterConditionalGroup();
        if (this.mExperiment.attributeSelection) {
            if (this.mAttribEvalClassParams.isEmpty()) {
                throw new RuntimeException("Couldn't find any attribute eval methods");
            }
            if (this.mAttribSearchClassParams.isEmpty()) {
                throw new RuntimeException("Couldn't find any attribute search methods");
            }
            ArrayList<String> searchParamNames = new ArrayList<String>();
            searchParamNames.add("NONE");
            for (ClassParams classParams : this.mAttribSearchClassParams) {
                searchParamNames.add(classParams.getTargetClass());
            }
            Parameter attributesearch = new Parameter("attributesearch", searchParamNames);
            paramGroup.add(attributesearch);
            searchParamNames.remove(0);
            for (ClassParams classParams : this.mAttribSearchClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, classParams, "assearch_", attributesearch);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ClassParams classParams : this.mAttribEvalClassParams) {
                arrayList.add(classParams.getTargetClass());
            }
            Parameter parameter = new Parameter("attributeeval", arrayList);
            paramGroup.add(parameter);
            for (ClassParams classParams : this.mAttribEvalClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, classParams, "aseval_", parameter);
            }
            paramGroup.add(new Parameter("attributetime", "" + this.mExperiment.attributeSelectionTimeout));
            paramGroup.add(new Conditional(parameter, attributesearch, searchParamNames));
        }
        ArrayList<String> classifiers = new ArrayList<String>();
        ArrayList<String> baseClassifiers = new ArrayList<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ClassParams classParams : this.mBaseClassParams) {
            className = classParams.getTargetClass();
            classifiers.add(className);
            baseClassifiers.add(className);
        }
        if (this.mIncludeMeta) {
            for (ClassParams classParams : this.mMetaClassParams) {
                className = classParams.getTargetClass();
                classifiers.add(className);
                arrayList.add(className);
            }
        }
        if (this.mIncludeEnsemble) {
            for (ClassParams classParams : this.mEnsembleClassParams) {
                className = classParams.getTargetClass();
                classifiers.add(className);
                arrayList2.add(className);
            }
        }
        if (baseClassifiers.isEmpty()) {
            throw new RuntimeException("No Base classifiers could be applied to this data set");
        }
        Parameter parameter = new Parameter("targetclass", classifiers, "weka.classifiers.trees.RandomForest");
        paramGroup.add(parameter);
        if (this.mIncludeBase) {
            for (ClassParams clsParams : this.mBaseClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, clsParams, "_0_", parameter);
            }
        }
        if (this.mIncludeMeta) {
            for (ClassParams clsParams : this.mMetaClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, clsParams, "_0_", parameter);
            }
        }
        if (this.mIncludeEnsemble) {
            for (ClassParams clsParams : this.mEnsembleClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, clsParams, "_0_", parameter);
            }
        }
        if (!arrayList.isEmpty()) {
            Parameter parameter2 = new Parameter("_1_W", baseClassifiers);
            paramGroup.add(parameter2);
            paramGroup.add(new Conditional(parameter2, parameter, arrayList));
            Parameter _1_W_0_DASHDASH = new Parameter("_1_W_0_DASHDASH", "REMOVED");
            paramGroup.add(_1_W_0_DASHDASH);
            paramGroup.add(new Conditional(_1_W_0_DASHDASH, parameter, arrayList));
            for (ClassParams clsParams : this.mBaseClassParams) {
                this.addClassifierToParameterConditionalGroupForDAG(paramGroup, clsParams, "_1_W_1_", parameter2);
            }
        }
        if (!arrayList2.isEmpty()) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int l = 0; l < this.mEnsembleMaxNum; ++l) {
                arrayList3.add(String.format("%d", l));
            }
            Parameter _HIDDEN_ensemble_depth = new Parameter("_HIDDEN_ensemble_depth", arrayList3);
            paramGroup.add(_HIDDEN_ensemble_depth);
            paramGroup.add(new Conditional(_HIDDEN_ensemble_depth, parameter, arrayList2));
            for (int i = 0; i < this.mEnsembleMaxNum; ++i) {
                String prefix = "_1_" + String.format("%02d", i);
                Parameter gateParam = new Parameter(prefix + "_0_QUOTE_START_B", baseClassifiers, "weka.classifiers.trees.RandomForest");
                paramGroup.add(gateParam);
                for (ClassParams clsParams : this.mBaseClassParams) {
                    this.addClassifierToParameterConditionalGroupForDAG(paramGroup, clsParams, prefix + "_1_", gateParam);
                }
                arrayList3.clear();
                for (int l = i; l < this.mEnsembleMaxNum; ++l) {
                    arrayList3.add(String.format("%d", l));
                }
                paramGroup.add(new Conditional(gateParam, _HIDDEN_ensemble_depth, arrayList3));
                Parameter endQuote = new Parameter("_1_" + String.format("%02d", i) + "_2_QUOTE_END", "REMOVED");
                paramGroup.add(endQuote);
                paramGroup.add(new Conditional(endQuote, _HIDDEN_ensemble_depth, arrayList3));
            }
        }
        return paramGroup;
    }

    private void addClassifierToParameterConditionalGroupForDAG(ParameterConditionalGroup paramGroup, ClassParams clsParams, String prefix, Parameter parent) {
        HashMap<Parameter, Parameter> paramMap = new HashMap<Parameter, Parameter>();
        prefix = prefix + "_" + this.getPrefix(clsParams.getTargetClass()) + "_";
        int i = 0;
        for (Parameter oldParam : clsParams.getParameters()) {
            String tempPrefix = prefix + String.format("%02d", i++) + "_";
            Parameter param = new Parameter(tempPrefix + oldParam.name, oldParam);
            paramMap.put(oldParam, param);
            paramGroup.add(param);
            paramGroup.add(new Conditional(param, parent, clsParams.getTargetClass()));
        }
        for (Conditional cond : clsParams.getConditionals()) {
            paramGroup.add(new Conditional((Parameter)paramMap.get(cond.parameter), (Parameter)paramMap.get(cond.parent), cond));
        }
    }
}

