/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import autoweka.Experiment;
import autoweka.TrajectoryGroup;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryMerger {
    static final Logger log = LoggerFactory.getLogger(TrajectoryMerger.class);

    public static void main(String[] args) throws Exception {
        ArrayList<String> experimentFolders = new ArrayList<String>();
        for (String arg : args) {
            experimentFolders.add(arg);
        }
        for (String experimentPath : experimentFolders) {
            File folder = new File(experimentPath);
            TrajectoryGroup group = TrajectoryMerger.mergeExperimentFolder(experimentPath);
            group.toXML(experimentPath + File.separator + folder.getName() + ".trajectories");
        }
    }

    public static TrajectoryGroup mergeExperimentFolder(String experimentPath) {
        try {
            File[] experimentDirFiles;
            File folder = new File(experimentPath);
            Experiment experiment = Experiment.fromXML(experimentPath + File.separator + folder.getName() + ".experiment");
            TrajectoryGroup group = new TrajectoryGroup(experiment);
            log.info("Experiment {}", (Object)experimentPath);
            for (File f : experimentDirFiles = new File(experimentPath + File.separator).listFiles()) {
                if (!f.getName().matches("^" + folder.getName() + ".trajectories.[^\\.]+")) continue;
                String seed = f.getName().substring(f.getName().lastIndexOf(".") + 1);
                TrajectoryGroup childGroup = TrajectoryGroup.fromXML(new FileInputStream(f));
                group.addTrajectory(childGroup.getTrajectory(seed));
            }
            return group;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

