/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;

public class Util {
    static final Logger log = LoggerFactory.getLogger(Util.class);
    private static Pattern msPropertyStringPattern = Pattern.compile("(?<!\\[\\]|\\[\\@\\]|\\\\|__COLONESCAPE__):");
    private static boolean msFailedToFindDistributionOnce = false;

    public static Properties parsePropertyString(String propStr) {
        Properties props = new Properties();
        Util.parsePropertyString(props, propStr);
        return props;
    }

    public static void parsePropertyString(Properties props, String propStr) {
        String[] strArray;
        if (propStr == null || propStr.isEmpty()) {
            return;
        }
        for (String str : strArray = msPropertyStringPattern.split(propStr)) {
            int equalsIndex = str.indexOf("=");
            if (equalsIndex == -1) {
                throw new RuntimeException("Invalid property '" + str + "'");
            }
            String key = str.substring(0, equalsIndex);
            String value = str.substring(equalsIndex + 1).replace("[@]:", ":").replace("\\:", ":").replace("[]:", ":").replace("__COLONESCAPE__:", ":");
            props.setProperty(key, value);
        }
    }

    public static String propertiesToString(Properties props) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : props.stringPropertyNames()) {
            if (!first) {
                sb.append(":");
            }
            first = false;
            sb.append(key);
            sb.append("=");
            sb.append(props.getProperty(key).replaceAll("\\:", "__COLONESCAPE__:"));
        }
        return sb.toString();
    }

    public static void parseCommandLineProperties(Properties props, String[] cmdLineArgs) {
        Util.parseCommandLineProperties(props, Arrays.asList(cmdLineArgs));
    }

    public static void parseCommandLineProperties(Properties props, List<String> cmdLineArgs) {
        for (int i = 0; i < cmdLineArgs.size(); ++i) {
            if (!cmdLineArgs.get(i).startsWith("-prop")) continue;
            Util.parsePropertyString(props, cmdLineArgs.get(++i));
        }
    }

    public static void initializeFile(String aLogPath) {
        try {
            File logFile = new File(aLogPath);
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't initialize file at this path: " + aLogPath);
        }
    }

    public static void makePath(String basePath) {
        File path = new File(basePath);
        try {
            if (!path.exists()) {
                if (!path.mkdirs() && !path.exists()) {
                    throw new RuntimeException("Failed to create directory:" + basePath);
                }
            } else if (!path.isDirectory()) {
                throw new RuntimeException("Something is already has this name, and it's not a dir: " + basePath);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException("Failed to create directory:" + basePath);
        }
    }

    public static String getAbsoluteClasspath() {
        return System.getProperty("java.class.path") + File.pathSeparatorChar + URLDecoder.decode(Util.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public static String getJavaExecutable() {
        return System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public static File findExecutableOnPath(String executableName) {
        String[] pathDirs;
        File fullyQualifiedExecutable = null;
        fullyQualifiedExecutable = new File(Util.expandPath(executableName));
        if (fullyQualifiedExecutable.isFile()) {
            return fullyQualifiedExecutable;
        }
        String systemPath = System.getenv("PATH");
        for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
            fullyQualifiedExecutable = new File(pathDir, executableName);
            if (!fullyQualifiedExecutable.isFile()) continue;
            return fullyQualifiedExecutable;
        }
        return null;
    }

    public static String expandEnvironmentVariable(String var) {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == 0) {
            try {
                String[] splitVar = var.split(File.pathSeparator);
                String expanded = "";
                for (int i = 0; i < splitVar.length; ++i) {
                    Process shellExec = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "echo", splitVar[i]});
                    BufferedReader reader = new BufferedReader(new InputStreamReader(shellExec.getInputStream()));
                    String res = reader.readLine();
                    if (res == null) continue;
                    expanded = expanded + res;
                    if (i >= splitVar.length - 1) continue;
                    expanded = expanded + File.pathSeparator;
                }
                return expanded;
            }
            catch (IOException ex) {
                log.warn("Failed to evaluate environment variable contents {}", (Object)var);
            }
        } else {
            try {
                String[] splitVar = var.split(File.pathSeparator);
                String expanded = "";
                for (int i = 0; i < splitVar.length; ++i) {
                    String v = splitVar[i];
                    String command = "eval echo \"" + v + "\"";
                    Process shellExec = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
                    BufferedReader reader = new BufferedReader(new InputStreamReader(shellExec.getInputStream()));
                    String res = reader.readLine();
                    if (res == null) continue;
                    expanded = expanded + res;
                    if (i >= splitVar.length - 1) continue;
                    expanded = expanded + File.pathSeparator;
                }
                return expanded;
            }
            catch (IOException ex) {
                log.warn("Failed to evaluate environment variable contents {} - probably due to a lack of unix...", (Object)var);
            }
        }
        return var;
    }

    public static String expandPath(String path) {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == 0) {
            String exp = path;
            try {
                Process shellExec = Runtime.getRuntime().exec("cmd.exe /C echo " + exp);
                BufferedReader reader = new BufferedReader(new InputStreamReader(shellExec.getInputStream()));
                String expandedPath = reader.readLine();
                if (expandedPath != null) {
                    exp = expandedPath;
                }
            }
            catch (IOException ex) {
                log.warn("Failed to expand path {}", (Object)path, (Object)ex);
            }
            File f = new File(exp);
            path = URLDecoder.decode(f.getAbsolutePath());
        } else {
            try {
                String command = "ls -d " + path;
                Process shellExec = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
                BufferedReader reader = new BufferedReader(new InputStreamReader(shellExec.getInputStream()));
                String expandedPath = reader.readLine();
                if (expandedPath != null) {
                    path = expandedPath;
                }
            }
            catch (IOException ex) {
                log.warn("Failed to expand path {}", (Object)path, (Object)ex);
            }
        }
        return path;
    }

    public static List<List<String>> cartesianProduct(List<List<String>> sets) {
        if (sets.size() < 2) {
            return sets;
        }
        return Util._cartesianProduct(sets.size() - 1, sets);
    }

    private static List<List<String>> _cartesianProduct(int index, List<List<String>> sets) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        if (index < 0) {
            ret.add(new ArrayList());
        } else {
            for (String obj : sets.get(index)) {
                for (List<String> set : Util._cartesianProduct(index - 1, sets)) {
                    set.add(obj);
                    ret.add(set);
                }
            }
        }
        return ret;
    }

    public static String argMapToString(Map<String, String> argMap) {
        ArrayList<String> argKeys = new ArrayList<String>(argMap.keySet());
        Collections.sort(argKeys);
        StringBuilder sb = new StringBuilder();
        for (String k : argKeys) {
            sb.append("-");
            sb.append(k);
            sb.append(" ");
            sb.append(argMap.get(k));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static Map<String, String> removeHidden(Map<String, String> inputMap) {
        HashMap<String, String> argMap = new HashMap<String, String>(inputMap);
        HashSet keys = new HashSet(argMap.keySet());
        for (String key : keys) {
            if (!key.contains("HIDDEN")) continue;
            argMap.remove(key);
        }
        return argMap;
    }

    public static String removeExtension(String s) {
        int lastSeparatorIndex = s.lastIndexOf(System.getProperty("file.separator"));
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static String joinStrings(String delim, String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length - 1; ++i) {
            sb.append(strs[i]);
            sb.append(delim);
        }
        sb.append(strs[strs.length - 1]);
        return sb.toString();
    }

    public static String joinStrings(String delim, Collection<String> strs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : strs) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static List<String> quoteStrings(Collection<String> oldStrs) {
        ArrayList<String> strs = new ArrayList<String>(oldStrs);
        for (int i = 0; i < strs.size(); ++i) {
            if (!((String)strs.get(i)).contains(" ")) continue;
            strs.set(i, "\"" + (String)strs.get(i) + "\"");
        }
        return strs;
    }

    public static List<String> splitNestedString(String params, String delimStr, int numLeft, int numRight) {
        ArrayList<String> args = new ArrayList<String>(numLeft);
        ArrayList<String> endArgs = new ArrayList<String>(numRight);
        int startIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < numLeft; ++i) {
            endIndex = params.indexOf(delimStr, startIndex);
            if (endIndex == -1) {
                throw new IllegalArgumentException("Could only find " + i + " left args before not finding the delimiter");
            }
            args.add(params.substring(startIndex, endIndex));
            startIndex = endIndex + delimStr.length();
        }
        int middleStart = startIndex;
        startIndex = endIndex = params.length();
        for (int i = 0; i < numRight; ++i) {
            startIndex = params.lastIndexOf(delimStr, endIndex - 1);
            if (startIndex == -1) {
                throw new IllegalArgumentException("Could only find " + i + " right args before not finding the delimeter");
            }
            endArgs.add(params.substring(startIndex + delimStr.length(), endIndex));
            endIndex = startIndex;
        }
        int middleEnd = startIndex;
        if (middleStart >= middleEnd) {
            throw new IllegalArgumentException("The number of left and right args doesn't leave anything in the middle");
        }
        args.add(params.substring(middleStart, middleEnd));
        for (int i = endArgs.size() - 1; i >= 0; --i) {
            args.add((String)endArgs.get(i));
        }
        return args;
    }

    public static Instances createDummyInstances(int numInstances, int numClasses, int numUsefulNumeric, int numUsefulCategorical, int numRandomNumeric, int numRandomCategorical, int randomCategoricalSize, int seed) {
        int i;
        ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
        ArrayList<String> classes = new ArrayList<String>();
        for (int i2 = 0; i2 < numClasses; ++i2) {
            classes.add(Integer.toString(i2));
        }
        ArrayList<String> randomCategorical = new ArrayList<String>();
        for (i = 0; i < randomCategoricalSize; ++i) {
            randomCategorical.add("rcat" + Integer.toString(i));
        }
        for (i = 0; i < numUsefulNumeric; ++i) {
            attInfo.add(new Attribute("usefulNumeric" + Integer.toString(i)));
        }
        for (i = 0; i < numUsefulCategorical; ++i) {
            attInfo.add(new Attribute("usefulCategorical" + Integer.toString(i), classes));
        }
        for (i = 0; i < numRandomNumeric; ++i) {
            attInfo.add(new Attribute("randomNumeric" + Integer.toString(i)));
        }
        for (i = 0; i < numRandomCategorical; ++i) {
            attInfo.add(new Attribute("randomCategorical" + Integer.toString(i), randomCategorical));
        }
        attInfo.add(new Attribute("class", classes));
        Random rand = new Random(seed);
        Instances instances = new Instances("dummy", attInfo, numInstances);
        instances.setClassIndex(attInfo.size() - 1);
        for (int j = 0; j < numInstances; ++j) {
            int i3;
            double[] features = new double[attInfo.size()];
            int classValue = j % numClasses;
            int index = 0;
            for (i3 = 0; i3 < numUsefulNumeric; ++i3) {
                features[index++] = classValue * (i3 + 1);
            }
            for (i3 = 0; i3 < numUsefulCategorical; ++i3) {
                features[index++] = classValue * (i3 + 1) % numClasses;
            }
            for (i3 = 0; i3 < numRandomNumeric; ++i3) {
                features[index++] = rand.nextGaussian();
            }
            for (i3 = 0; i3 < numRandomCategorical; ++i3) {
                features[index++] = rand.nextInt(randomCategoricalSize);
            }
            features[index++] = classValue;
            instances.add((Instance)new DenseInstance(1.0, features));
        }
        return instances;
    }

    public static String getAutoWekaDistributionPath() {
        for (File dir = (locStr = URLDecoder.decode(Util.class.getClassLoader().getResource(new StringBuilder().append(Util.class.getCanonicalName().replaceAll("\\.", "/")).append(".class").toString()).toString())).startsWith("jar") ? new File(locStr.substring(9, locStr.lastIndexOf("!"))) : new File(locStr); dir != null; dir = dir.getParentFile()) {
            File paramDir = new File(URLDecoder.decode(dir.getAbsolutePath()) + File.separator + "params");
            if (!paramDir.exists() || !paramDir.isDirectory()) continue;
            log.trace("Found install dir: {}", (Object)URLDecoder.decode(dir.getAbsolutePath()));
            return URLDecoder.decode(dir.getAbsolutePath());
        }
        if (!msFailedToFindDistributionOnce) {
            log.warn("Could not auto-detect the location of your Auto-WEKA install - have you moved the classes away from the 'params' diectory?");
            msFailedToFindDistributionOnce = true;
        }
        return ".";
    }

    public static List<String> splitQuotedString(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int level = 0;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c == 34 && ((i == 0 || str.charAt(i - 1) == ' ') && ++level == 1 || (i == str.length() - 1 || str.charAt(i + 1) == ' ' || str.charAt(i + 1) == '\"') && --level == 0)) continue;
            if (c == 92 && i < str.length() - 1 && str.charAt(i + 1) == '\"') {
                c = 34;
                ++i;
            }
            if (level == 0 && str.charAt(i) == ' ') {
                if (buffer.length() <= 0) continue;
                strings.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append((char)c);
        }
        if (buffer.length() > 0) {
            strings.add(buffer.toString());
        }
        return strings;
    }

    public static Instances loadDataSource(InputStream stream) throws Exception {
        ArffLoader loader = new ArffLoader();
        loader.setSource(stream);
        return loader.getDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) {
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ProcessKillerShutdownHook
    extends Thread {
        private Process mProc;

        public ProcessKillerShutdownHook(Process proc) {
            this.mProc = proc;
        }

        @Override
        public void run() {
            this.mProc.destroy();
        }
    }

    public static class NullPrintStream
    extends PrintStream {
        public NullPrintStream() {
            super((OutputStream)null);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    }
}

