/*
 * Decompiled with CFR 0.152.
 */
package autoweka;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WorkerThread
extends Thread {
    final Logger log = LoggerFactory.getLogger(WorkerThread.class);
    private OperatingSystemMXBean mOSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final int msPollInterval = 5;
    private static final float msTimeoutMultiplyer = 1.5f;
    private static final float msWalltimeMultiplyer = 2.0f;
    private volatile Exception mException = null;
    private volatile boolean mCompleted = false;
    private volatile boolean mTerminated = false;

    WorkerThread() {
    }

    @Override
    public void run() {
        try {
            this.doWork();
            if (!this.mTerminated) {
                this.mCompleted = true;
            }
        }
        catch (Exception e) {
            this.mException = e;
        }
        catch (Throwable t) {
            this.mException = new RuntimeException(t);
        }
    }

    public Exception getException() {
        return this.mException;
    }

    protected abstract void doWork() throws Exception;

    protected abstract String getOpName();

    public boolean completed() {
        return this.mCompleted;
    }

    public void terminate() {
        this.mTerminated = true;
        this.suspend();
        this.setPriority(1);
    }

    public boolean terminated() {
        return this.mTerminated;
    }

    float runWorker(float timeoutSeconds) {
        long startTime;
        block5: {
            long timeout = (long)((double)timeoutSeconds * 1.0E9);
            long wallTime = 0L;
            startTime = this.mOSBean.getProcessCpuTime();
            this.start();
            boolean interrupted = false;
            boolean stopped = false;
            long pollInterval = timeout / 1000000L;
            while (true) {
                try {
                    this.join(pollInterval);
                    wallTime += pollInterval;
                    pollInterval = 5L;
                }
                catch (InterruptedException e) {
                    break block5;
                }
                if (this.completed() || this.getException() != null) {
                    this.log.debug("{} completed", (Object)this.getOpName());
                    break block5;
                }
                if (!interrupted && this.mOSBean.getProcessCpuTime() - startTime > timeout) {
                    this.interrupt();
                    pollInterval = (long)((float)timeout * Math.max(0.0f, 0.5f)) / 1000000L;
                    this.log.debug("{} interrupted", (Object)this.getOpName());
                    interrupted = true;
                    continue;
                }
                if (!stopped && (float)(this.mOSBean.getProcessCpuTime() - startTime) > (float)timeout * 1.5f) break;
            }
            this.terminate();
            this.log.debug("{} aborted (it's only been suspended - leaks are likely!)", (Object)this.getOpName());
            stopped = true;
        }
        long stopTime = this.mOSBean.getProcessCpuTime();
        return (float)(stopTime - startTime) * 1.0E-9f;
    }
}

