/*
 * Decompiled with CFR 0.152.
 */
package autoweka.smac;

import autoweka.ClassifierResult;
import autoweka.SubProcessWrapper;
import autoweka.Util;
import autoweka.smac.SMACWrapper;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInstanceWrapper
extends SMACWrapper {
    final Logger log = LoggerFactory.getLogger(MultiInstanceWrapper.class);
    public String mParams;

    public static void main(String[] args) {
        MultiInstanceWrapper wrapper = new MultiInstanceWrapper();
        wrapper.run(args);
    }

    @Override
    protected ClassifierResult _doRun(List<String> runnerArgs) {
        List<String> instances = this.mRunner.getInstanceGenerator().getAllInstanceStrings(this.mInstance);
        ClassifierResult res = new ClassifierResult(this.mResultMetric);
        res.setCompleted(false);
        String memory = "3000m";
        int executedCount = 0;
        int failedCount = 0;
        for (String instance : instances) {
            this.log.debug("Instance: {}", (Object)instance);
            Properties props = new Properties();
            props.put("datasetString", this.mProperties.getProperty("datasetString"));
            props.put("instanceGenerator", this.mProperties.getProperty("instanceGenerator"));
            props.put("instanceGeneratorArgs", this.mInstance);
            props.put("resultMetric", this.mResultMetric);
            SubProcessWrapper.ErrorAndTime errTime = SubProcessWrapper.getErrorAndTime(null, memory, props, this.mTimeout, instance, Util.joinStrings(" ", runnerArgs), this.mExperimentSeed);
            res._setRawScore((res.getRawScore() * (double)executedCount + (double)errTime.error) / (double)(executedCount + 1));
            res.setTrainingTime(res.getTrainingTime() + (double)errTime.time);
            if ((double)errTime.error > 99.99 && ++failedCount >= 3) {
                return res;
            }
            ++executedCount;
        }
        res.setCompleted(true);
        return res;
    }
}

