/*
 * Decompiled with CFR 0.152.
 */
package autoweka.tools;

import autoweka.Experiment;
import autoweka.Trajectory;
import autoweka.TrajectoryGroup;
import autoweka.Util;
import autoweka.WekaArgumentConverter;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBestFromTrajectoryGroup {
    static final Logger log = LoggerFactory.getLogger(GetBestFromTrajectoryGroup.class);
    public Experiment experiment = null;
    public int numTrajectories = 0;
    public float errorEstimate = -1.0f;
    public String seed = null;
    public String classifierClass = null;
    public String classifierArgs = null;
    public String attributeSearchClass = null;
    public String attributeSearchArgs = null;
    public String attributeEvalClass = null;
    public String attributeEvalArgs = null;
    public int numEval = -1;
    public int numTimeOut = -1;
    public int numMemOut = -1;
    public String rawArgs;

    public static void main(String[] args) {
        GetBestFromTrajectoryGroup res = new GetBestFromTrajectoryGroup(args[0]);
        log.info("Experiment: {}", (Object)res.experiment.name);
        log.info("Num Trajectories: {}", (Object)res.numTrajectories);
        log.info("Best point seed: {}", (Object)res.seed);
        log.info("Best point error estimate: {}", (Object)Float.valueOf(res.errorEstimate));
        log.info("Classifier: {}", (Object)res.classifierClass);
        log.info(" Args: {}", (Object)res.classifierArgs);
        if (res.attributeSearchClass != null && res.attributeEvalClass != null) {
            log.info("ASSearch: {}", (Object)res.attributeSearchClass);
            log.info(" Args: {}", (Object)res.attributeSearchArgs);
            log.info("ASEval: {}", (Object)res.attributeEvalClass);
            log.info(" Args: {}", (Object)res.attributeEvalArgs);
        }
    }

    public GetBestFromTrajectoryGroup(String trajGroupFileName) {
        this(TrajectoryGroup.fromXML(trajGroupFileName));
    }

    public GetBestFromTrajectoryGroup(TrajectoryGroup trajGroup) {
        this.experiment = trajGroup.getExperiment();
        this.numTrajectories = trajGroup.getTrajectories().size();
        Trajectory.Point bestPt = new Trajectory.Point(0.0, 1.0E30f, "");
        Trajectory bestTraj = new Trajectory("");
        for (Trajectory traj : trajGroup.getTrajectories()) {
            Trajectory.Point pt = traj.getLastPoint();
            if (pt == null || !(bestPt.mErrorEstimate > pt.mErrorEstimate)) continue;
            bestPt = pt;
            bestTraj = traj;
            this.seed = traj.getSeed();
            this.errorEstimate = (float)bestPt.mErrorEstimate;
        }
        this.rawArgs = bestPt.mArgs;
        WekaArgumentConverter.Arguments wekaArgs = WekaArgumentConverter.convert(Arrays.asList(bestPt.mArgs.split(" ")));
        this.classifierClass = wekaArgs.propertyMap.get("targetclass");
        this.classifierArgs = Util.joinStrings(" ", Util.quoteStrings((Collection<String>)wekaArgs.argMap.get("classifier")));
        if (wekaArgs.propertyMap.containsKey("attributesearch") && !"NONE".equals(wekaArgs.propertyMap.get("attributesearch"))) {
            this.attributeSearchClass = wekaArgs.propertyMap.get("attributesearch");
            this.attributeSearchArgs = Util.joinStrings(" ", Util.quoteStrings((Collection<String>)wekaArgs.argMap.get("attributesearch")));
            this.attributeEvalClass = wekaArgs.propertyMap.get("attributeeval");
            this.attributeEvalArgs = Util.joinStrings(" ", Util.quoteStrings((Collection<String>)wekaArgs.argMap.get("attributeeval")));
        }
        this.numEval = bestTraj.getNumEvaluations();
        this.numTimeOut = bestTraj.getNumTimedOutEvaluations();
        this.numMemOut = bestTraj.getNumMemOutEvaluations();
    }
}

