/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.AutoWEKAClassifier;
import weka.core.Instances;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.explorer.Explorer;

public class AutoWEKAPanel
extends ClassifierPanel
implements Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 3089066653508312179L;
    protected Explorer m_Explorer = null;
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, (Component)((Object)this));
    protected ResultHistoryPanel m_History = new ResultHistoryPanel((JTextComponent)this.m_OutText);
    protected JComboBox m_ClassCombo = new JComboBox();
    protected JButton m_ManualBut = new JButton("Auto-WEKA Manual");
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel((PropertyEditor)this.m_ClassifierEditor, true);
    protected Instances m_Instances;
    protected Thread m_RunThread;
    protected AutoWEKAClassifier aw;

    public AutoWEKAPanel() {
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    AutoWEKAPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder((Border)BorderFactory.createTitledBorder("Result list (right-click for options)"));
        this.m_ClassifierEditor.setClassType(Classifier.class);
        this.m_ClassifierEditor.setValue((Object)new AutoWEKAClassifier());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AutoWEKAPanel.this.repaint();
            }
        });
        this.m_StartBut.setToolTipText("Starts Auto-WEKA");
        this.m_StartBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoWEKAPanel.this.startAutoWEKA();
            }
        });
        this.m_ManualBut.setToolTipText("Starts a browser to the Auto-WEKA manual");
        this.m_ManualBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.cs.ubc.ca/labs/beta/Projects/autoweka/manual.pdf"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_StopBut.setToolTipText("Stops Auto-WEKA");
        this.m_StopBut.setEnabled(false);
        this.m_StopBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoWEKAPanel.this.stopAutoWEKA();
            }
        });
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    int index = AutoWEKAPanel.this.m_History.getList().locationToIndex(e.getPoint());
                    if (index != -1) {
                        String name = AutoWEKAPanel.this.m_History.getNameAtIndex(index);
                        AutoWEKAPanel.this.showPopup(name, e.getX(), e.getY());
                    } else {
                        AutoWEKAPanel.this.showPopup(null, e.getX(), e.getY());
                    }
                }
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        buttons.add((Component)this.m_ClassCombo, "North");
        this.m_ClassCombo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel ssButs = new JPanel();
        ssButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ssButs.setLayout(new GridLayout(1, 2, 5, 5));
        ssButs.add(this.m_StartBut);
        ssButs.add(this.m_StopBut);
        buttons.add((Component)ssButs, "South");
        JPanel p3 = new JPanel();
        p3.setBorder(BorderFactory.createTitledBorder("Auto-WEKA output"));
        p3.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_OutText);
        p3.add((Component)js, "Center");
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        JPanel mondo = new JPanel();
        GridBagLayout gbL = new GridBagLayout();
        mondo.setLayout(gbL);
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 11;
        gbC.fill = 2;
        gbC.gridy = 1;
        gbC.gridx = 0;
        gbL.setConstraints(buttons, gbC);
        mondo.add(buttons);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 2;
        gbC.gridx = 0;
        gbC.weightx = 0.0;
        gbL.setConstraints((Component)this.m_History, gbC);
        mondo.add((Component)this.m_History);
        gbC = new GridBagConstraints();
        gbC.fill = 1;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.gridheight = 3;
        gbC.weightx = 100.0;
        gbC.weighty = 100.0;
        gbL.setConstraints(p3, gbC);
        mondo.add(p3);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)this.m_CEPanel, "North");
        top.add((Component)this.m_ManualBut, "South");
        this.setLayout(new BorderLayout());
        this.add(top, "North");
        this.add(mondo, "Center");
        Dimension pref = this.m_CEPanel.getPreferredSize();
        pref.height += 5;
        this.m_CEPanel.setPreferredSize(pref);
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        String[] attribNames = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < attribNames.length; ++i) {
            String type = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    type = "(Nom) ";
                    break;
                }
                case 0: {
                    type = "(Num) ";
                    break;
                }
                case 2: {
                    type = "(Str) ";
                    break;
                }
                case 3: {
                    type = "(Dat) ";
                    break;
                }
                case 4: {
                    type = "(Rel) ";
                    break;
                }
                default: {
                    type = "(???) ";
                }
            }
            attribNames[i] = type + this.m_Instances.attribute(i).name();
        }
        this.m_ClassCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        if (attribNames.length > 0) {
            if (inst.classIndex() == -1) {
                this.m_ClassCombo.setSelectedIndex(attribNames.length - 1);
            } else {
                this.m_ClassCombo.setSelectedIndex(inst.classIndex());
            }
            this.m_ClassCombo.setEnabled(true);
            this.m_StartBut.setEnabled(this.m_RunThread == null);
            this.m_StopBut.setEnabled(this.m_RunThread != null);
        } else {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(false);
        }
    }

    protected void showPopup(String name, int x, int y) {
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem viewMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            viewMainBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoWEKAPanel.this.m_History.setSingle(selectedName);
                }
            });
        } else {
            viewMainBuffer.setEnabled(false);
        }
        resultListMenu.add(viewMainBuffer);
        JMenuItem viewSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            viewSepBuffer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoWEKAPanel.this.m_History.openFrame(selectedName);
                }
            });
        } else {
            viewSepBuffer.setEnabled(false);
        }
        resultListMenu.add(viewSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoWEKAPanel.this.saveBuffer(selectedName);
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoWEKAPanel.this.m_History.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        AutoWEKAClassifier classifier = this.aw;
        Instances trainHeader = this.m_Instances;
        JMenuItem saveModel = new JMenuItem("Save model");
        if (selectedName != null) {
            saveModel.addActionListener(new ActionListener((Classifier)classifier, trainHeader){
                final /* synthetic */ Classifier val$classifier;
                final /* synthetic */ Instances val$trainHeader;
                {
                    this.val$classifier = classifier;
                    this.val$trainHeader = instances;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoWEKAPanel.this.saveClassifier("Auto-WEKA", this.val$classifier, this.val$trainHeader);
                }
            });
        } else {
            saveModel.setEnabled(false);
        }
        resultListMenu.add(saveModel);
        resultListMenu.show(this.m_History.getList(), x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAutoWEKA() {
        if (this.m_RunThread == null) {
            AutoWEKAPanel autoWEKAPanel = this;
            synchronized (autoWEKAPanel) {
                this.m_StartBut.setEnabled(false);
                this.m_StopBut.setEnabled(true);
            }
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AutoWEKAPanel.this.m_Log.statusMessage("Setting up...");
                    try {
                        AutoWEKAPanel.this.m_Log.logMessage("Started Auto-WEKA for " + AutoWEKAPanel.this.m_Instances.relationName());
                        if (AutoWEKAPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)AutoWEKAPanel.this.m_Log).taskStarted();
                        }
                        AutoWEKAPanel.this.m_Log.statusMessage("Auto-WEKA started...");
                        Object name = "Auto-WEKA: " + AutoWEKAPanel.this.m_Instances.relationName();
                        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                        name = df.format(new Date()) + " - " + (String)name;
                        AutoWEKAPanel.this.aw = (AutoWEKAClassifier)AbstractClassifier.makeCopy((Classifier)((AutoWEKAClassifier)((Object)AutoWEKAPanel.this.m_ClassifierEditor.getValue())));
                        AutoWEKAPanel.this.m_Instances.setClassIndex(AutoWEKAPanel.this.m_ClassCombo.getSelectedIndex());
                        AutoWEKAPanel.this.aw.setLog(AutoWEKAPanel.this.m_Log);
                        AutoWEKAPanel.this.aw.buildClassifier(AutoWEKAPanel.this.m_Instances);
                        StringBuffer outBuff = new StringBuffer();
                        outBuff.append("Auto-WEKA result:\n");
                        outBuff.append(AutoWEKAPanel.this.aw.toString());
                        AutoWEKAPanel.this.m_History.addResult((String)name, outBuff);
                        AutoWEKAPanel.this.m_History.setSingle((String)name);
                        AutoWEKAPanel.this.m_Log.logMessage("Auto-WEKA finished for " + AutoWEKAPanel.this.m_Instances.relationName());
                        AutoWEKAPanel.this.m_Log.statusMessage("OK");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        AutoWEKAPanel.this.m_Log.logMessage(ex.getMessage());
                        JOptionPane.showMessageDialog((Component)((Object)AutoWEKAPanel.this), "Problem running Auto-WEKA:\n" + ex.getMessage(), "Running Auto-WEKA", 0);
                        AutoWEKAPanel.this.m_Log.statusMessage("Problem running Auto-WEKA!");
                    }
                    finally {
                        13 var1_3 = this;
                        synchronized (var1_3) {
                            AutoWEKAPanel.this.m_StartBut.setEnabled(true);
                            AutoWEKAPanel.this.m_StopBut.setEnabled(false);
                            AutoWEKAPanel.this.m_RunThread = null;
                        }
                        if (AutoWEKAPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)AutoWEKAPanel.this.m_Log).taskFinished();
                        }
                    }
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void saveBuffer(String name) {
        StringBuffer sb = this.m_History.getNamedBuffer(name);
        if (sb != null && this.m_SaveOut.save(sb)) {
            this.m_Log.logMessage("Save successful.");
        }
    }

    protected void stopAutoWEKA() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Auto-WEKA";
    }

    public String getTabTitleToolTip() {
        return "Run Auto-WEKA";
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Auto-WEKA");
            jf.getContentPane().setLayout(new BorderLayout());
            AutoWEKAPanel sp = new AutoWEKAPanel();
            jf.getContentPane().add((Component)((Object)sp), "Center");
            LogPanel lp = new LogPanel();
            sp.setLog((Logger)lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances((Reader)r);
                sp.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

